/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.DELETE;

import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E20;
import io.agrest.cayenne.cayenne.main.E21;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import org.junit.jupiter.api.Test;

public class NaturalIdIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = NaturalIdIT.tester(Resource.class).entitiesAndDependencies(E20.class, E21.class).build();

    @Test
    public void singleId() {
        tester.e20().insertColumns(new String[]{"name_col"}).values(new Object[]{"John"}).values(new Object[]{"Brian"}).exec();
        tester.target("/single-id/John").delete().wasOk().bodyEquals("{}");
        tester.e20().matcher().assertOneMatch();
        tester.e20().matcher().eq("name_col", (Object)"Brian").assertOneMatch();
    }

    @Test
    public void multiId() {
        tester.e21().insertColumns(new String[]{"age", "name"}).values(new Object[]{18, "John"}).values(new Object[]{27, "Brian"}).exec();
        tester.target("/multi-id").queryParam("age", new Object[]{18}).queryParam("name", new Object[]{"John"}).delete().wasOk().bodyEquals("{}");
        tester.e21().matcher().assertOneMatch();
        tester.e21().matcher().eq("name", (Object)"Brian").andEq("age", (Object)27).assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @DELETE
        @Path(value="multi-id")
        public SimpleResponse deleteE21ById(@QueryParam(value="age") int age, @QueryParam(value="name") String name) {
            HashMap<String, Object> id = new HashMap<String, Object>(3);
            id.put("age", age);
            id.put("name", name);
            return AgJaxrs.delete(E21.class, (Configuration)this.config).byId(id).sync();
        }

        @DELETE
        @Path(value="single-id/{id}")
        public SimpleResponse deleteE20ById(@PathParam(value="id") String name, @Context UriInfo uriInfo) {
            return AgJaxrs.delete(E20.class, (Configuration)this.config).byId((Object)name).sync();
        }
    }
}

