/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.DELETE;

import io.agrest.DeleteBuilder;
import io.agrest.SimpleResponse;
import io.agrest.cayenne.cayenne.main.E17;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.cayenne.main.E24;
import io.agrest.cayenne.cayenne.main.E3;
import io.agrest.cayenne.cayenne.main.E4;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Test;

public class BasicIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = BasicIT.tester(Resource.class).entities(E2.class, E3.class, E4.class, E17.class, E24.class).build();

    @Test
    public void deleteAll() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "xxx"}).values(new Object[]{35, "zzz"}).values(new Object[]{8, "yyy"}).exec();
        tester.target("/e4").delete().wasOk().bodyEquals("{}");
        tester.e4().matcher().assertNoMatches();
    }

    @Test
    public void deleteAll_Empty() {
        tester.target("/e4").delete().wasOk().bodyEquals("{}");
    }

    @Test
    public void deleteById() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "xxx"}).values(new Object[]{8, "yyy"}).exec();
        tester.target("/e4/8").delete().wasOk().bodyEquals("{}");
        tester.e4().matcher().assertOneMatch();
    }

    @Test
    public void deleteByIds() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "xxx"}).values(new Object[]{7, "aaa"}).values(new Object[]{8, "yyy"}).exec();
        tester.target("/e4").queryParam("ids", new Object[]{1, 8}).delete().wasOk().bodyEquals("{}");
        tester.e4().matcher().assertOneMatch();
    }

    @Test
    public void deleteById_CompoundId() {
        tester.e17().insertColumns(new String[]{"id1", "id2", "name"}).values(new Object[]{1, 1, "aaa"}).values(new Object[]{2, 2, "bbb"}).exec();
        tester.target("/e17").queryParam("id1", new Object[]{1}).queryParam("id2", new Object[]{1}).delete().wasOk().bodyEquals("{}");
        tester.e17().matcher().assertOneMatch();
        tester.e17().matcher().eq("id2", (Object)2).andEq("id2", (Object)2).andEq("name", (Object)"bbb").assertOneMatch();
    }

    @Test
    public void deleteById_BadId() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "xxx"}).exec();
        tester.target("/e4/7").delete().wasNotFound().bodyEquals("{\"message\":\"No matching objects for entity 'E4' and ids: 7\"}");
        tester.e4().matcher().assertMatches(1);
    }

    @Test
    public void deleteTwice() {
        tester.e4().insertColumns(new String[]{"id", "c_varchar"}).values(new Object[]{1, "xxx"}).values(new Object[]{8, "yyy"}).exec();
        tester.target("/e4/8").delete().wasOk().bodyEquals("{}");
        tester.target("/e4/8").delete().wasNotFound().bodyEquals("{\"message\":\"No matching objects for entity 'E4' and ids: 8\"}");
    }

    @Test
    public void delete_UpperCasePK() {
        tester.e24().insertColumns(new String[]{"TYPE", "name"}).values(new Object[]{1, "xyz"}).exec();
        tester.target("/e24/1").delete().wasOk().bodyEquals("{}");
    }

    @Test
    public void delete_ByParentId() {
        tester.e2().insertColumns(new String[]{"id_"}).values(new Object[]{1}).values(new Object[]{2}).values(new Object[]{3}).exec();
        tester.e3().insertColumns(new String[]{"id_", "e2_id"}).values(new Object[]{1, 1}).values(new Object[]{2, 2}).values(new Object[]{3, 2}).values(new Object[]{4, 3}).exec();
        tester.target("/e2/2/e3s").delete().wasOk().bodyEquals("{}");
        tester.e3().matcher().assertMatches(2);
        tester.e3().matcher().eq("id_", (Object)1).assertOneMatch();
        tester.e3().matcher().eq("id_", (Object)4).assertOneMatch();
    }

    @Path(value="")
    public static class Resource {
        @Context
        private Configuration config;

        @DELETE
        @Path(value="e2/{e2_id}/e3s")
        public SimpleResponse deleteByParent(@PathParam(value="e2_id") int e2Id) {
            return AgJaxrs.delete(E3.class, (Configuration)this.config).parent(E2.class, (Object)e2Id, E2.E3S.getName()).sync();
        }

        @DELETE
        @Path(value="e4")
        public SimpleResponse deleteAll(@QueryParam(value="ids") List<Integer> ids) {
            DeleteBuilder builder = AgJaxrs.delete(E4.class, (Configuration)this.config);
            if (ids != null && !ids.isEmpty()) {
                builder.byIds(ids);
            }
            return builder.sync();
        }

        @DELETE
        @Path(value="e4/{id}")
        public SimpleResponse deleteById(@PathParam(value="id") int id) {
            return AgJaxrs.delete(E4.class, (Configuration)this.config).byId((Object)id).sync();
        }

        @DELETE
        @Path(value="e17")
        public SimpleResponse deleteByMultiId(@Context UriInfo uriInfo, @QueryParam(value="id1") Integer id1, @QueryParam(value="id2") Integer id2) {
            HashMap<String, Integer> id = new HashMap<String, Integer>();
            id.put(E17.ID1.getName(), id1);
            id.put(E17.ID2.getName(), id2);
            return AgJaxrs.delete(E17.class, (Configuration)this.config).byId(id).sync();
        }

        @DELETE
        @Path(value="e24/{id}")
        public SimpleResponse deleteE24ById(@PathParam(value="id") int id) {
            return AgJaxrs.delete(E24.class, (Configuration)this.config).byId((Object)id).sync();
        }
    }
}

