/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise.jmx;

import io.activej.async.callback.Callback;
import io.activej.async.function.AsyncSupplier;
import io.activej.eventloop.Eventloop;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.jmx.stats.ValueStats;
import io.activej.promise.Promise;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public class PromiseStats {
    @Nullable
    private Eventloop eventloop;
    private int activePromises = 0;
    private long lastStartTimestamp = 0L;
    private long lastCompleteTimestamp = 0L;
    private final ValueStats duration;
    private final ExceptionStats exceptions = ExceptionStats.create();

    protected PromiseStats(@Nullable Eventloop eventloop, ValueStats duration) {
        this.eventloop = eventloop;
        this.duration = duration;
    }

    public static PromiseStats createMBean(Eventloop eventloop, Duration smoothingWindow) {
        return new PromiseStats(eventloop, ValueStats.create((Duration)smoothingWindow));
    }

    public static PromiseStats create(Duration smoothingWindow) {
        return new PromiseStats(null, ValueStats.create((Duration)smoothingWindow));
    }

    public PromiseStats withHistogram(int[] levels) {
        this.setHistogram(levels);
        return this;
    }

    public PromiseStats withHistogram(JmxHistogram histogram) {
        this.setHistogram(histogram);
        return this;
    }

    public void setHistogram(int[] levels) {
        this.duration.setHistogram(levels);
    }

    public void setHistogram(JmxHistogram histogram) {
        this.duration.setHistogram(histogram);
    }

    private long currentTimeMillis() {
        if (this.eventloop == null) {
            this.eventloop = Eventloop.getCurrentEventloop();
        }
        return this.eventloop.currentTimeMillis();
    }

    public <T> AsyncSupplier<T> wrapper(AsyncSupplier<T> callable) {
        return () -> this.monitor(callable.get());
    }

    public <T> Promise<T> monitor(Promise<T> promise) {
        return promise.whenComplete(this.recordStats());
    }

    public <T> Callback<T> recordStats() {
        long before;
        ++this.activePromises;
        this.lastStartTimestamp = before = this.currentTimeMillis();
        return (value, e) -> {
            --this.activePromises;
            long now = this.currentTimeMillis();
            long durationMillis = now - before;
            this.lastCompleteTimestamp = now;
            this.duration.recordValue((double)durationMillis);
            if (e != null) {
                this.exceptions.recordException(e);
            }
        };
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getActivePromises() {
        return this.activePromises;
    }

    @JmxAttribute
    @Nullable
    public Instant getLastStartTime() {
        return this.lastStartTimestamp != 0L ? Instant.ofEpochMilli(this.lastStartTimestamp) : null;
    }

    @JmxAttribute
    @Nullable
    public Instant getLastCompleteTime() {
        return this.lastCompleteTimestamp != 0L ? Instant.ofEpochMilli(this.lastCompleteTimestamp) : null;
    }

    @JmxAttribute
    @Nullable
    public Duration getCurrentDuration() {
        return this.activePromises != 0 ? Duration.ofMillis(this.currentTimeMillis() - this.lastStartTimestamp) : null;
    }

    @JmxAttribute
    public ValueStats getDuration() {
        return this.duration;
    }

    @JmxAttribute
    public ExceptionStats getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        return "PromiseStats{activePromises=" + this.activePromises + ", lastStartTimestamp=" + Instant.ofEpochMilli(this.lastStartTimestamp) + ", lastCompleteTimestamp=" + Instant.ofEpochMilli(this.lastCompleteTimestamp) + ", duration=" + this.duration + ", exceptions=" + this.exceptions + '}';
    }
}

