/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.eventloop.Eventloop;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class TestUtils {
    public static <T> T await(Promise<T> promise) {
        try {
            return TestUtils.compute(promise);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }

    @SafeVarargs
    public static <T> Void await(Promise<T> ... promises) {
        return TestUtils.await(Promises.all(promises));
    }

    public static <T, E extends Throwable> E awaitException(Promise<T> promise) {
        try {
            TestUtils.compute(promise);
        }
        catch (ExecutionException e) {
            return (E)e.getCause();
        }
        catch (Throwable e) {
            return (E)e;
        }
        throw new AssertionError((Object)"Promise did not fail");
    }

    @SafeVarargs
    public static <T, E extends Throwable> E awaitException(Promise<T> ... promises) {
        return TestUtils.awaitException(Promises.all(promises));
    }

    private static <T> T compute(Promise<T> promise) throws ExecutionException {
        CompletableFuture<T> future = promise.toCompletableFuture();
        Eventloop.getCurrentEventloop().run();
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

