/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.common.Checks;
import io.activej.common.ref.RefInt;
import io.activej.common.ref.RefLong;
import io.activej.common.tuple.Tuple2;
import java.time.Duration;

public interface RetryPolicy<S> {
    public S createRetryState();

    public long nextRetryTimestamp(long var1, Throwable var3, S var4);

    public static RetryPolicy<Void> noRetry() {
        return new StatelessRetryPolicy(){

            @Override
            public long nextRetryTimestamp(long now, Throwable lastError, Void retryState) {
                return 0L;
            }
        };
    }

    public static RetryPolicy<Void> immediateRetry() {
        return new StatelessRetryPolicy(){

            @Override
            public long nextRetryTimestamp(long now, Throwable lastError, Void retryState) {
                return now;
            }
        };
    }

    public static RetryPolicy<Void> fixedDelay(Duration delay) {
        return RetryPolicy.fixedDelay(delay.toMillis());
    }

    public static RetryPolicy<Void> fixedDelay(final long delay) {
        return new StatelessRetryPolicy(){

            @Override
            public long nextRetryTimestamp(long now, Throwable lastError, Void retryState) {
                return now + delay;
            }
        };
    }

    public static RetryPolicy<?> exponentialBackoff(Duration initialDelay, Duration maxDelay, double exponent) {
        return RetryPolicy.exponentialBackoff(initialDelay.toMillis(), maxDelay.toMillis(), exponent);
    }

    public static RetryPolicy<?> exponentialBackoff(final long initialDelay, final long maxDelay, final double exponent) {
        Checks.checkArgument((maxDelay > initialDelay && exponent > 1.0 ? 1 : 0) != 0, (Object)"Max delay should be greater than initial delay and exponent should be greater than 1.0");
        final int maxRetryCount = (int)Math.ceil(Math.log((double)maxDelay / (double)initialDelay) / Math.log(exponent));
        return new SimpleRetryPolicy(){

            @Override
            public long nextRetryTimestamp(long now, Throwable lastError, int retryCount, long firstRetryTimestamp) {
                return now + (retryCount > maxRetryCount ? maxDelay : Math.min(maxDelay, (long)((double)initialDelay * Math.pow(exponent, retryCount))));
            }
        };
    }

    public static RetryPolicy<?> exponentialBackoff(Duration initialDelay, Duration maxDelay) {
        return RetryPolicy.exponentialBackoff(initialDelay.toMillis(), maxDelay.toMillis());
    }

    public static RetryPolicy<?> exponentialBackoff(long initialDelay, long maxDelay) {
        return RetryPolicy.exponentialBackoff(initialDelay, maxDelay, 2.0);
    }

    default public RetryPolicy<Tuple2<RefInt, S>> withMaxTotalRetryCount(final int maxRetryCount) {
        return new DelegatingRetryPolicy<RefInt, S>(this){

            @Override
            protected RefInt doCreateRetryState() {
                return new RefInt(0);
            }

            @Override
            public long nextRetryTimestamp(long now, Throwable lastError, RefInt retryState, S delegateRetryState) {
                if (retryState.value++ < maxRetryCount) {
                    return RetryPolicy.this.nextRetryTimestamp(now, lastError, delegateRetryState);
                }
                return 0L;
            }
        };
    }

    default public RetryPolicy<?> withMaxTotalRetryTimeout(Duration maxRetryTimeout) {
        final long maxRetryTimeoutMillis = maxRetryTimeout.toMillis();
        return new DelegatingRetryPolicy<RefLong, S>(this){

            @Override
            protected RefLong doCreateRetryState() {
                return new RefLong(0L);
            }

            @Override
            public long nextRetryTimestamp(long now, Throwable lastError, RefLong retryState, S delegateRetryState) {
                if (retryState.value == 0L) {
                    retryState.value = now;
                }
                if (now < retryState.value + maxRetryTimeoutMillis) {
                    return RetryPolicy.this.nextRetryTimestamp(now, lastError, delegateRetryState);
                }
                return 0L;
            }
        };
    }

    public static abstract class DelegatingRetryPolicy<S, DS>
    implements RetryPolicy<Tuple2<S, DS>> {
        private final RetryPolicy<DS> delegateRetryPolicy;

        protected DelegatingRetryPolicy(RetryPolicy<DS> policy) {
            this.delegateRetryPolicy = policy;
        }

        @Override
        public final Tuple2<S, DS> createRetryState() {
            DS delegateRetryState = this.delegateRetryPolicy.createRetryState();
            S retryState = this.doCreateRetryState();
            return new Tuple2(retryState, delegateRetryState);
        }

        protected abstract S doCreateRetryState();

        @Override
        public final long nextRetryTimestamp(long now, Throwable lastError, Tuple2<S, DS> retryState) {
            return this.nextRetryTimestamp(now, lastError, retryState.getValue1(), retryState.getValue2());
        }

        public abstract long nextRetryTimestamp(long var1, Throwable var3, S var4, DS var5);
    }

    public static abstract class SimpleRetryPolicy
    implements RetryPolicy<SimpleRetryState> {
        @Override
        public final SimpleRetryState createRetryState() {
            return new SimpleRetryState();
        }

        @Override
        public final long nextRetryTimestamp(long now, Throwable lastError, SimpleRetryState retryState) {
            retryState.lastError = lastError;
            ++retryState.retryCount;
            if (retryState.retryFirstTimestamp == 0L) {
                retryState.retryFirstTimestamp = now;
            }
            return this.nextRetryTimestamp(now, lastError, retryState.retryCount, retryState.retryFirstTimestamp);
        }

        public abstract long nextRetryTimestamp(long var1, Throwable var3, int var4, long var5);
    }

    public static class SimpleRetryState {
        protected Throwable lastError;
        protected int retryCount;
        protected long retryFirstTimestamp;
    }

    public static abstract class StatelessRetryPolicy
    implements RetryPolicy<Void> {
        @Override
        public final Void createRetryState() {
            return null;
        }
    }
}

