/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.AsyncComputation;
import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.common.collection.Try;
import io.activej.common.exception.UncheckedException;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.CompleteExceptionallyPromise;
import io.activej.promise.CompleteNullPromise;
import io.activej.promise.CompletePromise;
import io.activej.promise.CompleteResultPromise;
import io.activej.promise.Promisable;
import io.activej.promise.SettablePromise;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Promise<T>
extends Promisable<T>,
AsyncComputation<T> {
    @NotNull
    public static CompleteNullPromise<Void> complete() {
        return CompleteNullPromise.INSTANCE;
    }

    @NotNull
    public static <T> CompletePromise<T> of(@Nullable T value) {
        return value != null ? new CompleteResultPromise<T>(value) : CompleteNullPromise.instance();
    }

    @NotNull
    public static <T> CompleteExceptionallyPromise<T> ofException(@NotNull Throwable e) {
        return new CompleteExceptionallyPromise(e);
    }

    @NotNull
    public static <T> Promise<T> ofCallback(@NotNull @NotNull Consumer<@NotNull SettablePromise<T>> callbackConsumer) {
        SettablePromise cb = new SettablePromise();
        try {
            callbackConsumer.accept(cb);
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
        return cb;
    }

    @NotNull
    public static <T> Promise<T> ofOptional(@NotNull Optional<T> optional) {
        return Promise.ofOptional(optional, NoSuchElementException::new);
    }

    @NotNull
    public static <T> Promise<T> ofOptional(@NotNull Optional<T> optional, @NotNull Supplier<? extends Throwable> errorSupplier) {
        if (optional.isPresent()) {
            return Promise.of(optional.get());
        }
        return Promise.ofException(errorSupplier.get());
    }

    @NotNull
    public static <T> Promise<T> of(@Nullable T value, @Nullable Throwable e) {
        Checks.checkArgument((value == null || e == null ? 1 : 0) != 0, (Object)"Either value or exception should be 'null'");
        return e == null ? Promise.of(value) : Promise.ofException(e);
    }

    @NotNull
    public static <T> Promise<T> ofTry(@NotNull Try<T> t) {
        return (Promise)t.reduce(Promise::of, Promise::ofException);
    }

    @NotNull
    public static <T> Promise<T> ofFuture(@NotNull CompletableFuture<? extends T> future) {
        return Promise.ofCompletionStage(future);
    }

    @NotNull
    public static <T> Promise<T> ofCompletionStage(CompletionStage<? extends T> completionStage) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            completionStage.whenCompleteAsync((result, e) -> {
                eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.accept(result, (Throwable)e)));
                eventloop.completeExternalTask();
            });
        });
    }

    @NotNull
    public static <T> Promise<T> ofFuture(@NotNull Executor executor, @NotNull Future<? extends T> future) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        Object value = future.get();
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.set(value)));
                    }
                    catch (ExecutionException e) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(e.getCause())));
                    }
                    catch (InterruptedException e) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(e)));
                    }
                    catch (Throwable e) {
                        eventloop.execute(() -> eventloop.recordFatalError(e, (Object)future));
                    }
                    finally {
                        eventloop.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                eventloop.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    public static <T> Promise<T> ofBlockingCallable(@NotNull Executor executor, @NotNull BlockingCallable<? extends T> callable) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        Object result = callable.call();
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.set(result)));
                    }
                    catch (UncheckedException u) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(u.getCause())));
                    }
                    catch (RuntimeException e) {
                        eventloop.execute(() -> eventloop.recordFatalError((Throwable)e, (Object)callable));
                    }
                    catch (Exception e) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(e)));
                    }
                    catch (Throwable e) {
                        eventloop.execute(() -> eventloop.recordFatalError(e, (Object)callable));
                    }
                    finally {
                        eventloop.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                eventloop.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    @NotNull
    public static Promise<Void> ofBlockingRunnable(@NotNull Executor executor, @NotNull BlockingRunnable runnable) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        runnable.run();
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.set(null)));
                    }
                    catch (UncheckedException u) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(u.getCause())));
                    }
                    catch (RuntimeException e) {
                        eventloop.execute(() -> eventloop.recordFatalError((Throwable)e, (Object)runnable));
                    }
                    catch (Exception e) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(e)));
                    }
                    catch (Throwable e) {
                        eventloop.execute(() -> eventloop.recordFatalError(e, (Object)runnable));
                    }
                    finally {
                        eventloop.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                eventloop.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    @Override
    default public Promise<T> promise() {
        return this;
    }

    @Contract(pure=true)
    default public boolean isComplete() {
        return this.isResult() || this.isException();
    }

    @Contract(pure=true)
    public boolean isResult();

    @Contract(pure=true)
    public boolean isException();

    @Contract(pure=true)
    public T getResult();

    @Contract(pure=true)
    public Throwable getException();

    @Contract(pure=true)
    public Try<T> getTry();

    @Contract(pure=true)
    @NotNull
    public Promise<T> async();

    @Contract(pure=true)
    @NotNull
    default public Promise<T> post() {
        SettablePromise result = new SettablePromise();
        this.whenComplete(result::post);
        return result;
    }

    @Contract(value="_ -> param1")
    @NotNull
    public <U, P extends Callback<? super T> & Promise<U>> Promise<U> next(@NotNull P var1);

    @Contract(pure=true)
    @NotNull
    public <U> Promise<U> map(@NotNull Function<? super T, ? extends U> var1);

    @Contract(pure=true)
    @NotNull
    public <U> Promise<U> mapEx(@NotNull BiFunction<? super T, @Nullable Throwable, ? extends U> var1);

    @Contract(pure=true)
    @NotNull
    public <U> Promise<U> then(@NotNull Function<? super T, ? extends Promise<? extends U>> var1);

    @NotNull
    public <U> Promise<U> then(@NotNull Supplier<? extends Promise<? extends U>> var1);

    @Contract(pure=true)
    @NotNull
    public <U> Promise<U> thenEx(@NotNull BiFunction<? super T, @Nullable Throwable, ? extends Promise<? extends U>> var1);

    @Contract(value=" _ -> this")
    @NotNull
    public Promise<T> whenComplete(@Async.Schedule @NotNull Callback<? super T> var1);

    @Contract(value=" _ -> this")
    @NotNull
    public Promise<T> whenComplete(@NotNull Runnable var1);

    @Contract(value=" _ -> this")
    @NotNull
    public Promise<T> whenResult(Consumer<? super T> var1);

    public Promise<T> whenResult(@NotNull Runnable var1);

    @Contract(value="_ -> this")
    public Promise<T> whenException(@NotNull Consumer<Throwable> var1);

    public Promise<T> whenException(@NotNull Runnable var1);

    @Contract(pure=true)
    @NotNull
    public <U, V> Promise<V> combine(@NotNull Promise<? extends U> var1, @NotNull BiFunction<? super T, ? super U, ? extends V> var2);

    @Contract(pure=true)
    @NotNull
    public Promise<Void> both(@NotNull Promise<?> var1);

    @Contract(pure=true)
    @NotNull
    public Promise<T> either(@NotNull Promise<? extends T> var1);

    @Contract(pure=true)
    @NotNull
    public Promise<Try<T>> toTry();

    @Contract(pure=true)
    @NotNull
    public Promise<Void> toVoid();

    default public void run(@NotNull Callback<? super T> action) {
        this.whenComplete(action);
    }

    @Contract(pure=true)
    @NotNull
    public CompletableFuture<T> toCompletableFuture();

    @FunctionalInterface
    public static interface BlockingRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface BlockingCallable<V> {
        public V call() throws Exception;
    }
}

