/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.common.collection.Try;
import io.activej.common.exception.UncheckedException;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.AbstractPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class CompletePromise<T>
implements Promise<T> {
    @Override
    public final boolean isComplete() {
        return true;
    }

    @Override
    public final boolean isResult() {
        return true;
    }

    @Override
    public final boolean isException() {
        return false;
    }

    @Override
    public abstract T getResult();

    @Override
    public final Throwable getException() {
        return null;
    }

    @Override
    public Try<T> getTry() {
        return Try.of(this.getResult());
    }

    @Override
    @NotNull
    public final <U, S extends Callback<? super T> & Promise<U>> Promise<U> next(@NotNull S promise) {
        promise.accept(this.getResult(), null);
        return promise;
    }

    @Override
    @NotNull
    public final <U> Promise<U> map(@NotNull Function<? super T, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(this.getResult()));
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public final <U> Promise<U> mapEx(@NotNull BiFunction<? super T, Throwable, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(this.getResult(), null));
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public final <U> Promise<U> then(@NotNull Function<? super T, ? extends Promise<? extends U>> fn) {
        try {
            return fn.apply(this.getResult());
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull Supplier<? extends Promise<? extends U>> fn) {
        try {
            return fn.get();
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public final <U> Promise<U> thenEx(@NotNull BiFunction<? super T, Throwable, ? extends Promise<? extends U>> fn) {
        try {
            return fn.apply(this.getResult(), null);
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public final Promise<T> whenComplete(@NotNull Callback<? super T> action) {
        action.accept(this.getResult(), null);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull Runnable action) {
        action.run();
        return this;
    }

    @Override
    @NotNull
    public final Promise<T> whenResult(@NotNull Consumer<? super T> action) {
        action.accept(this.getResult());
        return this;
    }

    @Override
    public Promise<T> whenResult(@NotNull Runnable action) {
        action.run();
        return this;
    }

    @Override
    public final Promise<T> whenException(@NotNull Consumer<Throwable> action) {
        return this;
    }

    @Override
    public Promise<T> whenException(@NotNull Runnable action) {
        return this;
    }

    @Override
    @NotNull
    public final <U, V> Promise<V> combine(@NotNull Promise<? extends U> other, @NotNull BiFunction<? super T, ? super U, ? extends V> fn) {
        return other.map(otherResult -> fn.apply((T)this.getResult(), (Object)otherResult)).whenException(() -> Recyclers.recycle(this.getResult()));
    }

    @Override
    @NotNull
    public final Promise<Void> both(@NotNull Promise<?> other) {
        Recyclers.recycle(this.getResult());
        return other.map(AbstractPromise::recycleToVoid);
    }

    @Override
    @NotNull
    public final Promise<T> either(@NotNull Promise<? extends T> other) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    @NotNull
    public final Promise<T> async() {
        SettablePromise result = new SettablePromise();
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext(result, () -> result.set(this.getResult())));
        return result;
    }

    @Override
    @NotNull
    public final Promise<Try<T>> toTry() {
        return Promise.of(Try.of(this.getResult()));
    }

    @Override
    @NotNull
    public final Promise<Void> toVoid() {
        return Promise.complete();
    }

    @Override
    @NotNull
    public final CompletableFuture<T> toCompletableFuture() {
        return CompletableFuture.completedFuture(this.getResult());
    }

    static {
        Recyclers.register(CompletePromise.class, promise -> Recyclers.recycle(promise.getResult()));
    }
}

