/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.common.collection.Try;
import io.activej.common.exception.UncheckedException;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class CompleteExceptionallyPromise<T>
implements Promise<T> {
    @NotNull
    private final Throwable exception;

    public CompleteExceptionallyPromise(@NotNull Throwable e) {
        this.exception = e;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isResult() {
        return false;
    }

    @Override
    public boolean isException() {
        return true;
    }

    @Override
    public T getResult() {
        return null;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public Try<T> getTry() {
        return Try.ofException((Throwable)this.exception);
    }

    @Override
    @NotNull
    public <U, S extends Callback<? super T> & Promise<U>> Promise<U> next(@NotNull S promise) {
        promise.accept(null, this.exception);
        return promise;
    }

    @Override
    @NotNull
    public <U> Promise<U> map(@NotNull Function<? super T, ? extends U> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> mapEx(@NotNull BiFunction<? super T, Throwable, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(null, this.exception));
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull Function<? super T, ? extends Promise<? extends U>> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull Supplier<? extends Promise<? extends U>> fn) {
        return this;
    }

    @Override
    @NotNull
    public <U> Promise<U> thenEx(@NotNull BiFunction<? super T, Throwable, ? extends Promise<? extends U>> fn) {
        try {
            return fn.apply(null, this.exception);
        }
        catch (UncheckedException u) {
            return Promise.ofException(u.getCause());
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull Callback<? super T> action) {
        action.accept(null, this.exception);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull Runnable action) {
        action.run();
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull Consumer<? super T> action) {
        return this;
    }

    @Override
    public Promise<T> whenResult(@NotNull Runnable action) {
        return this;
    }

    @Override
    public Promise<T> whenException(@NotNull Consumer<Throwable> action) {
        action.accept(this.exception);
        return this;
    }

    @Override
    public Promise<T> whenException(@NotNull Runnable action) {
        action.run();
        return this;
    }

    @Override
    @NotNull
    public <U, V> Promise<V> combine(@NotNull Promise<? extends U> other, @NotNull BiFunction<? super T, ? super U, ? extends V> fn) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    @NotNull
    public Promise<Void> both(@NotNull Promise<?> other) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> either(@NotNull Promise<? extends T> other) {
        return other;
    }

    @Override
    @NotNull
    public Promise<T> async() {
        SettablePromise result = new SettablePromise();
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext(result, () -> result.setException(this.exception)));
        return result;
    }

    @Override
    @NotNull
    public Promise<Try<T>> toTry() {
        return Promise.of(Try.ofException((Throwable)this.exception));
    }

    @Override
    @NotNull
    public Promise<Void> toVoid() {
        return this;
    }

    @Override
    @NotNull
    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(this.exception);
        return future;
    }
}

