/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.collection.Try;
import io.activej.common.exception.UncheckedException;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.promise.SimpleCallback;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPromise<T>
implements Promise<T> {
    private static final boolean CHECK;
    private static final Object PROMISE_NOT_SET;
    private static final boolean RESET_CALLBACKS;
    protected T result = PROMISE_NOT_SET;
    @Nullable
    protected Throwable exception;
    @Nullable
    protected Callback<? super T> next;
    private static final Object NO_RESULT;
    private static final String INDENT = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PACKAGE_NAME_AND_LAMBDA_PART;

    AbstractPromise() {
    }

    public void reset() {
        this.result = PROMISE_NOT_SET;
        this.exception = null;
        this.next = null;
    }

    public void resetCallbacks() {
        this.next = null;
    }

    @Override
    public final boolean isComplete() {
        return this.result != PROMISE_NOT_SET;
    }

    @Override
    public final boolean isResult() {
        return this.result != PROMISE_NOT_SET && this.exception == null;
    }

    @Override
    public final boolean isException() {
        return this.exception != null;
    }

    @Override
    public T getResult() {
        return this.result != PROMISE_NOT_SET ? (T)this.result : null;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public Try<T> getTry() {
        if (this.isResult()) {
            return Try.of(this.result);
        }
        if (this.isException()) {
            return Try.ofException((Throwable)this.exception);
        }
        return null;
    }

    protected void complete(@Nullable T value, @Nullable Throwable e) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        if (e == null) {
            this.complete(value);
        } else {
            this.completeExceptionally(e);
        }
    }

    @Async.Execute
    protected void complete(@Nullable T value) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        this.result = value;
        if (this.next != null) {
            this.next.accept(value, null);
            if (RESET_CALLBACKS) {
                this.next = null;
            }
        }
    }

    @Async.Execute
    protected void completeExceptionally(@Nullable Throwable e) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        this.result = null;
        this.exception = e;
        if (this.next != null) {
            this.next.accept(null, e);
            if (RESET_CALLBACKS) {
                this.next = null;
            }
        }
    }

    protected boolean tryComplete(@Nullable T value, @Nullable Throwable e) {
        if (!this.isComplete()) {
            this.complete(value, e);
            return true;
        }
        return false;
    }

    protected boolean tryComplete(@Nullable T value) {
        if (!this.isComplete()) {
            this.complete(value);
            return true;
        }
        return false;
    }

    protected boolean tryCompleteExceptionally(@NotNull Throwable e) {
        if (!this.isComplete()) {
            this.completeExceptionally(e);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public <U, P extends Callback<? super T> & Promise<U>> Promise<U> next(@Async.Schedule @NotNull P promise) {
        if (this.isComplete()) {
            promise.accept(this.result, this.exception);
            return promise;
        }
        this.subscribe(promise);
        return promise;
    }

    @Async.Schedule
    protected void subscribe(@NotNull Callback<? super T> callback) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        if (this.next == null) {
            this.next = callback;
        } else if (this.next instanceof CallbackList) {
            ((CallbackList)this.next).add(callback);
        } else {
            this.next = new CallbackList<T>(this.next, callback);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> map(final @NotNull Function<? super T, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(fn.apply(this.result)) : this;
            }
            catch (UncheckedException u) {
                return Promise.ofException(u.getCause());
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = fn.apply(result);
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> mapEx(final @NotNull BiFunction<? super T, Throwable, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return Promise.of(fn.apply(this.result, this.exception));
            }
            catch (UncheckedException u) {
                return Promise.ofException(u.getCause());
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, Throwable e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = fn.apply(result, null);
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    this.complete(newResult);
                } else {
                    Object newResult;
                    try {
                        newResult = fn.apply(null, e);
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    this.complete(newResult);
                }
            }

            @Override
            public String describe() {
                return ".mapEx(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(final @NotNull Function<? super T, ? extends Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? fn.apply(this.result) : this;
            }
            catch (UncheckedException u) {
                return Promise.ofException(u.getCause());
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(result);
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    promise.whenComplete(this::complete);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(final @NotNull Supplier<? extends Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? fn.get() : this;
            }
            catch (UncheckedException u) {
                return Promise.ofException(u.getCause());
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.get();
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    promise.whenComplete(this::complete);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> thenEx(final @NotNull BiFunction<? super T, Throwable, ? extends Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return fn.apply(this.result, this.exception);
            }
            catch (UncheckedException u) {
                return Promise.ofException(u.getCause());
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(result, null);
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    promise.whenComplete(this::complete);
                } else {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(null, e);
                    }
                    catch (UncheckedException u) {
                        this.completeExceptionally(u.getCause());
                        return;
                    }
                    promise.whenComplete(this::complete);
                }
            }

            @Override
            public String describe() {
                return ".thenEx(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull Callback<? super T> action) {
        if (this.isComplete()) {
            action.accept(this.result, this.exception);
            return this;
        }
        this.subscribe(action);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(final @NotNull Runnable action) {
        if (this.isComplete()) {
            action.run();
            return this;
        }
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Throwable e) {
                action.run();
            }

            public String toString() {
                return ".whenComplete(" + AbstractPromise.formatToString(action) + ')';
            }
        });
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(final Consumer<? super T> action) {
        if (this.isComplete()) {
            if (this.isResult()) {
                action.accept(this.result);
            }
            return this;
        }
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    action.accept(result);
                }
            }

            public String toString() {
                return ".whenResult(" + AbstractPromise.formatToString(action) + ')';
            }
        });
        return this;
    }

    @Override
    public Promise<T> whenResult(final @NotNull Runnable action) {
        if (this.isComplete()) {
            if (this.isResult()) {
                action.run();
            }
            return this;
        }
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    action.run();
                }
            }

            public String toString() {
                return ".whenResult(" + AbstractPromise.formatToString(action) + ')';
            }
        });
        return this;
    }

    @Override
    public Promise<T> whenException(final @NotNull Consumer<Throwable> action) {
        if (this.isComplete()) {
            if (this.isException()) {
                action.accept(this.exception);
            }
            return this;
        }
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e != null) {
                    action.accept(e);
                }
            }

            public String toString() {
                return ".whenException(" + AbstractPromise.formatToString(action) + ')';
            }
        });
        return this;
    }

    @Override
    public Promise<T> whenException(final @NotNull Runnable action) {
        if (this.isComplete()) {
            if (this.isException()) {
                action.run();
            }
            return this;
        }
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e != null) {
                    action.run();
                }
            }

            public String toString() {
                return ".whenException(" + AbstractPromise.formatToString(action) + ')';
            }
        });
        return this;
    }

    @Override
    @NotNull
    public Promise<T> async() {
        if (this.isComplete()) {
            SettablePromise promise = new SettablePromise();
            Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext(promise, (Runnable)(this.exception == null ? () -> promise.set(this.result) : () -> promise.setException(this.exception))));
            return promise;
        }
        return this;
    }

    @Override
    @NotNull
    public <U, V> Promise<V> combine(@NotNull Promise<? extends U> other, @NotNull BiFunction<? super T, ? super U, ? extends V> fn) {
        if (this.isComplete()) {
            if (this.isResult()) {
                return other.map(otherResult -> fn.apply((T)this.getResult(), (Object)otherResult)).whenException(() -> Recyclers.recycle(this.getResult()));
            }
            other.whenResult(Recyclers::recycle);
            return this;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                return this.map(result -> fn.apply((Object)result, (Object)other.getResult())).whenException(() -> Recyclers.recycle(other.getResult()));
            }
            this.whenResult(Recyclers::recycle);
            return other;
        }
        PromiseCombine<? super T, ? extends V, ? super U> resultPromise = new PromiseCombine<T, V, U>(fn);
        other.whenComplete(resultPromise::acceptOther);
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<Void> both(@NotNull Promise<?> other) {
        if (this.isComplete()) {
            if (this.isResult()) {
                Recyclers.recycle(this.getResult());
                return other.map(AbstractPromise::recycleToVoid);
            }
            other.whenResult(Recyclers::recycle);
            return this;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                Recyclers.recycle(other.getResult());
                return this.map(AbstractPromise::recycleToVoid);
            }
            this.whenResult(Recyclers::recycle);
            return other;
        }
        PromiseBoth resultPromise = new PromiseBoth();
        other.whenComplete(resultPromise);
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Nullable
    protected static Void recycleToVoid(Object item) {
        Recyclers.recycle((Object)item);
        return null;
    }

    @Override
    @NotNull
    public Promise<T> either(@NotNull Promise<? extends T> other) {
        if (this.isComplete()) {
            if (this.isResult()) {
                other.whenResult(Recyclers::recycle);
                return this;
            }
            return other;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                this.whenResult(Recyclers::recycle);
                return other;
            }
            return this;
        }
        EitherPromise resultPromise = new EitherPromise();
        other.whenComplete(resultPromise);
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<Try<T>> toTry() {
        if (this.isComplete()) {
            return Promise.of(this.isResult() ? Try.of(this.result) : Try.ofException((Throwable)this.exception));
        }
        NextPromise resultPromise = new NextPromise<T, Try<T>>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    this.complete(Try.of(result));
                } else {
                    this.complete(Try.ofException((Throwable)e));
                }
            }

            @Override
            public String describe() {
                return ".toTry()";
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<Void> toVoid() {
        if (this.isComplete()) {
            return this.isResult() ? Promise.complete() : this;
        }
        NextPromise resultPromise = new NextPromise<T, Void>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    this.complete(null);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".toVoid()";
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public CompletableFuture<T> toCompletableFuture() {
        if (this.isComplete()) {
            if (this.isResult()) {
                return CompletableFuture.completedFuture(this.result);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(this.exception);
            return future;
        }
        final CompletableFuture future = new CompletableFuture();
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Throwable e) {
                if (e == null) {
                    future.complete(result);
                } else {
                    future.completeExceptionally(e);
                }
            }

            public String toString() {
                return ".toCompletableFuture()";
            }
        });
        return future;
    }

    private static <T> void appendChildren(StringBuilder sb, Callback<T> callback, String indent) {
        if (callback == null) {
            return;
        }
        if (callback instanceof CallbackList) {
            CallbackList callbackList = (CallbackList)callback;
            for (int i = 0; i < callbackList.index; ++i) {
                AbstractPromise.appendChildren(sb, callbackList.callbacks[i], indent);
            }
        } else {
            indent = indent + "\t";
            sb.append("\n");
            if (callback instanceof AbstractPromise) {
                sb.append(((AbstractPromise)callback).toString(indent));
            } else if (!(callback instanceof SimpleCallback)) {
                sb.append(indent).append(".whenComplete(").append(AbstractPromise.formatToString(callback)).append(')');
            } else {
                sb.append(indent).append(callback);
            }
        }
    }

    private static String formatToString(Object object) {
        return PACKAGE_NAME_AND_LAMBDA_PART.matcher(object.toString()).replaceAll("$1");
    }

    private String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append(this.describe());
        if (this.isComplete()) {
            sb.append('{');
            if (this.exception == null) {
                sb.append(this.result);
            } else {
                sb.append("exception=");
                sb.append(this.exception.getClass().getSimpleName());
            }
            sb.append('}');
        }
        AbstractPromise.appendChildren(sb, this.next, indent);
        return sb.toString();
    }

    protected String describe() {
        return "AbstractPromise";
    }

    public String toString() {
        return this.toString("");
    }

    static {
        Recyclers.register(AbstractPromise.class, promise -> promise.whenResult(Recyclers::recycle));
        CHECK = Checks.isEnabled(AbstractPromise.class);
        PROMISE_NOT_SET = new Object();
        RESET_CALLBACKS = ApplicationSettings.getBoolean(AbstractPromise.class, (String)"resetCallbacks", (boolean)false);
        NO_RESULT = new Object();
        PACKAGE_NAME_AND_LAMBDA_PART = Pattern.compile("^(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*?)\\$\\$Lambda\\$\\d+)/.*$");
    }

    private static class CallbackList<T>
    implements Callback<T> {
        private int index = 2;
        private Callback<? super T>[] callbacks = new Callback[4];

        public CallbackList(Callback<? super T> first, Callback<? super T> second) {
            this.callbacks[0] = first;
            this.callbacks[1] = second;
        }

        public void add(Callback<? super T> callback) {
            if (this.index == this.callbacks.length) {
                this.callbacks = Arrays.copyOf(this.callbacks, this.callbacks.length * 2);
            }
            this.callbacks[this.index++] = callback;
        }

        public void accept(T result, @Nullable Throwable e) {
            for (int i = 0; i < this.index; ++i) {
                this.callbacks[i].accept(result, e);
            }
        }
    }

    private static final class EitherPromise<T>
    extends NextPromise<T, T> {
        int errors = 2;

        private EitherPromise() {
        }

        public void accept(T result, @Nullable Throwable e) {
            if (e == null) {
                if (!this.tryComplete(result)) {
                    Recyclers.recycle(result);
                }
            } else if (--this.errors == 0) {
                this.completeExceptionally(new Exception("Both promises completed exceptionally"));
            }
        }

        @Override
        public String describe() {
            return ".either()";
        }
    }

    private static class PromiseBoth<T>
    extends NextPromise<T, Void> {
        int counter = 2;

        private PromiseBoth() {
        }

        public void accept(T result, @Nullable Throwable e) {
            if (e == null) {
                Recyclers.recycle(result);
                if (--this.counter == 0) {
                    this.complete(null);
                }
            } else {
                this.tryCompleteExceptionally(e);
            }
        }

        @Override
        public String describe() {
            return ".both()";
        }
    }

    private static class PromiseCombine<T, V, U>
    extends NextPromise<T, V> {
        final BiFunction<? super T, ? super U, ? extends V> fn;
        @Nullable
        T thisResult = AbstractPromise.access$100();
        @Nullable
        U otherResult = AbstractPromise.access$100();

        PromiseCombine(BiFunction<? super T, ? super U, ? extends V> fn) {
            this.fn = fn;
        }

        public void accept(T result, @Nullable Throwable e) {
            if (e == null) {
                if (this.otherResult != NO_RESULT) {
                    this.onBothResults(result, this.otherResult);
                } else {
                    this.thisResult = result;
                }
            } else {
                this.onAnyException(e);
            }
        }

        public void acceptOther(U result, @Nullable Throwable e) {
            if (e == null) {
                if (this.thisResult != NO_RESULT) {
                    this.onBothResults(this.thisResult, result);
                } else {
                    this.otherResult = result;
                }
            } else {
                this.onAnyException(e);
            }
        }

        void onBothResults(@Nullable T thisResult, @Nullable U otherResult) {
            this.tryComplete(this.fn.apply(thisResult, otherResult));
        }

        void onAnyException(@NotNull Throwable e) {
            if (this.tryCompleteExceptionally(e)) {
                if (this.thisResult != NO_RESULT) {
                    Recyclers.recycle(this.thisResult);
                }
                if (this.otherResult != NO_RESULT) {
                    Recyclers.recycle(this.otherResult);
                }
            }
        }

        @Override
        public String describe() {
            return ".combine(" + AbstractPromise.formatToString(this.fn) + ')';
        }
    }
}

