/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.service;

import io.activej.async.callback.Callback;
import io.activej.async.function.AsyncSupplier;
import io.activej.async.function.AsyncSuppliers;
import io.activej.async.service.EventloopService;
import io.activej.common.Utils;
import io.activej.common.initializer.WithInitializer;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBeanEx;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.promise.RetryPolicy;
import io.activej.promise.jmx.PromiseStats;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventloopTaskScheduler
implements EventloopService,
WithInitializer<EventloopTaskScheduler>,
EventloopJmxBeanEx {
    private static final Logger logger = LoggerFactory.getLogger(EventloopTaskScheduler.class);
    private final Eventloop eventloop;
    private final AsyncSupplier<Object> task;
    private final PromiseStats stats = PromiseStats.create(Duration.ofMinutes(5L));
    private long initialDelay;
    private Schedule schedule;
    private RetryPolicy<Object> retryPolicy;
    private boolean abortOnError = false;
    private long lastStartTime;
    private long lastCompleteTime;
    @Nullable
    private Throwable lastException;
    private int errorCount;
    @Nullable
    private Duration period;
    @Nullable
    private Duration interval;
    private boolean enabled = true;
    @Nullable
    private ScheduledRunnable scheduledTask;
    @Nullable
    private Promise<Void> currentPromise;
    private final AsyncSupplier<Void> doCall = AsyncSuppliers.reuse(this::doCall);

    private EventloopTaskScheduler(Eventloop eventloop, AsyncSupplier<?> task) {
        this.eventloop = eventloop;
        this.task = task;
    }

    public static <T> EventloopTaskScheduler create(Eventloop eventloop, AsyncSupplier<T> task) {
        return new EventloopTaskScheduler(eventloop, task);
    }

    public EventloopTaskScheduler withInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay.toMillis();
        return this;
    }

    public EventloopTaskScheduler withSchedule(Schedule schedule) {
        this.schedule = schedule;
        this.period = null;
        this.interval = null;
        return this;
    }

    public EventloopTaskScheduler withPeriod(Duration period) {
        this.setPeriod(period);
        return this;
    }

    public EventloopTaskScheduler withInterval(Duration interval) {
        this.setInterval(interval);
        return this;
    }

    public EventloopTaskScheduler withRetryPolicy(RetryPolicy<?> retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public EventloopTaskScheduler withAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
        return this;
    }

    public EventloopTaskScheduler withStatsHistogramLevels(int[] levels) {
        this.stats.setHistogram(levels);
        return this;
    }

    @Override
    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    private void scheduleTask() {
        if (this.schedule == null || this.scheduledTask != null && this.scheduledTask.isCancelled()) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        long now = this.eventloop.currentTimeMillis();
        long timestamp = this.lastStartTime == 0L ? now + this.initialDelay : this.schedule.nextTimestamp(now, this.lastStartTime, this.lastCompleteTime);
        this.scheduledTask = this.eventloop.scheduleBackground(timestamp, this.doCall::get);
    }

    private Promise<Void> doCall() {
        this.lastStartTime = this.eventloop.currentTimeMillis();
        this.currentPromise = (this.retryPolicy == null ? this.task.get() : Promises.retry(this.task, ($, e) -> e == null || !this.enabled, this.retryPolicy)).whenComplete(this.stats.recordStats()).whenComplete((Callback<Object>)((Callback)(result, e) -> {
            if (!this.enabled) {
                return;
            }
            this.lastCompleteTime = this.eventloop.currentTimeMillis();
            if (e == null) {
                this.lastException = null;
                this.errorCount = 0;
                this.scheduleTask();
            } else {
                this.lastException = e;
                ++this.errorCount;
                logger.error("Retry attempt " + this.errorCount, e);
                if (this.abortOnError) {
                    this.scheduledTask = (ScheduledRunnable)Utils.nullify((Object)this.scheduledTask, ScheduledRunnable::cancel);
                    throw new RuntimeException(e);
                }
                this.scheduleTask();
            }
        })).toVoid();
        return this.currentPromise;
    }

    @NotNull
    public Promise<Void> start() {
        this.scheduleTask();
        return Promise.complete();
    }

    @NotNull
    public Promise<Void> stop() {
        this.enabled = false;
        this.scheduledTask = (ScheduledRunnable)Utils.nullify((Object)this.scheduledTask, ScheduledRunnable::cancel);
        if (this.currentPromise == null) {
            return Promise.complete();
        }
        return this.currentPromise.mapEx(($, e) -> null);
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
        if (this.stats.getActivePromises() != 0L && this.scheduledTask != null && !this.scheduledTask.isCancelled()) {
            this.scheduledTask = (ScheduledRunnable)Utils.nullify((Object)this.scheduledTask, ScheduledRunnable::cancel);
            this.scheduleTask();
        }
    }

    public void setRetryPolicy(RetryPolicy<?> retryPolicy) {
        this.retryPolicy = retryPolicy;
        if (this.stats.getActivePromises() != 0L && this.scheduledTask != null && !this.scheduledTask.isCancelled() && this.lastException != null) {
            this.scheduledTask = (ScheduledRunnable)Utils.nullify((Object)this.scheduledTask, ScheduledRunnable::cancel);
            this.scheduleTask();
        }
    }

    @JmxAttribute
    public boolean isEnabled() {
        return this.enabled;
    }

    @JmxAttribute
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.stats.getActivePromises() == 0L) {
            if (enabled) {
                this.scheduleTask();
            } else {
                this.scheduledTask = (ScheduledRunnable)Utils.nullify((Object)this.scheduledTask, ScheduledRunnable::cancel);
            }
        }
    }

    @JmxAttribute(name="")
    public PromiseStats getStats() {
        return this.stats;
    }

    @JmxAttribute
    @Nullable
    public Throwable getLastException() {
        return this.lastException;
    }

    @JmxAttribute
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @JmxAttribute
    @Nullable
    public Duration getPeriod() {
        return this.period;
    }

    @JmxAttribute
    public void setPeriod(Duration period) {
        Schedule schedule = Schedule.ofPeriod(period);
        this.setSchedule(schedule);
        this.period = period;
        this.interval = null;
    }

    @JmxAttribute
    @Nullable
    public Duration getInterval() {
        return this.interval;
    }

    @JmxAttribute
    public void setInterval(Duration interval) {
        this.setSchedule(Schedule.ofInterval(interval));
        this.period = null;
        this.interval = interval;
    }

    @JmxOperation
    public void startNow() {
        this.doCall.get();
    }

    @FunctionalInterface
    public static interface Schedule {
        public long nextTimestamp(long var1, long var3, long var5);

        public static Schedule immediate() {
            return (now, lastStartTime, lastCompleteTime) -> now;
        }

        public static Schedule ofDelay(Duration delay) {
            return Schedule.ofDelay(delay.toMillis());
        }

        public static Schedule ofDelay(long delay) {
            return (now, lastStartTime, lastCompleteTime) -> now + delay;
        }

        public static Schedule ofInterval(Duration interval) {
            return Schedule.ofInterval(interval.toMillis());
        }

        public static Schedule ofInterval(long interval) {
            return (now, lastStartTime, lastCompleteTime) -> lastCompleteTime + interval;
        }

        public static Schedule ofPeriod(Duration period) {
            return Schedule.ofPeriod(period.toMillis());
        }

        public static Schedule ofPeriod(long period) {
            return (now, lastStartTime, lastCompleteTime) -> lastStartTime + period;
        }
    }
}

