/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.process;

import io.activej.async.process.AsyncCloseable;
import io.activej.common.Checks;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAsyncCloseable
implements AsyncCloseable {
    private static final boolean CHECK = Checks.isEnabled(AbstractAsyncCloseable.class);
    protected final Eventloop eventloop = Eventloop.getCurrentEventloop();
    @Nullable
    private AsyncCloseable closeable;
    private Throwable exception;

    public Throwable getException() {
        return this.exception;
    }

    public final void setCloseable(@Nullable AsyncCloseable closeable) {
        this.closeable = closeable;
    }

    protected void onClosed(@NotNull Throwable e) {
    }

    protected void onCleanup() {
    }

    @Override
    public final void closeEx(@NotNull Throwable e) {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        if (this.isClosed()) {
            return;
        }
        this.exception = e;
        this.eventloop.post(this::onCleanup);
        this.onClosed(e);
        if (this.closeable != null) {
            this.closeable.closeEx(e);
        }
    }

    public final boolean isClosed() {
        return this.exception != null;
    }

    @NotNull
    public final <T> Promise<T> sanitize(Promise<T> promise) {
        return promise.async().thenEx(this::sanitize);
    }

    @NotNull
    public final <T> Promise<T> sanitize(T value, @Nullable Throwable e) {
        if (this.exception != null) {
            Recyclers.recycle(value);
            if (value instanceof AsyncCloseable) {
                ((AsyncCloseable)value).closeEx(this.exception);
            }
            return Promise.ofException(this.exception);
        }
        if (e == null) {
            return Promise.of(value);
        }
        this.closeEx(e);
        return Promise.ofException(e);
    }
}

