/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.callback.Callback;
import io.activej.async.process.AsyncExecutor;
import io.activej.common.collection.Try;
import io.activej.promise.Promise;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface AsyncSupplier<T> {
    public Promise<T> get();

    public static <T> AsyncSupplier<T> of(@NotNull Supplier<Promise<T>> supplier) {
        return supplier::get;
    }

    public static <T> AsyncSupplier<T> ofValue(@Nullable T value) {
        return () -> Promise.of(value);
    }

    public static <T> AsyncSupplier<T> ofIterator(@NotNull Iterator<? extends T> iterator) {
        return () -> Promise.of(iterator.hasNext() ? (Object)iterator.next() : null);
    }

    public static <T> AsyncSupplier<T> ofStream(@NotNull Stream<? extends T> stream) {
        return AsyncSupplier.ofIterator(stream.iterator());
    }

    public static <T> AsyncSupplier<T> ofIterable(@NotNull Iterable<? extends T> iterable) {
        return AsyncSupplier.ofIterator(iterable.iterator());
    }

    public static <T> AsyncSupplier<T> ofPromise(@NotNull Promise<T> promise) {
        return () -> promise;
    }

    public static <T> AsyncSupplier<T> ofPromiseIterator(@NotNull Iterator<? extends Promise<T>> iterator) {
        return () -> iterator.hasNext() ? (Promise)iterator.next() : Promise.of(null);
    }

    public static <T> AsyncSupplier<T> ofPromiseIterable(@NotNull Iterable<? extends Promise<T>> iterable) {
        return AsyncSupplier.ofPromiseIterator(iterable.iterator());
    }

    public static <T> AsyncSupplier<T> ofPromiseStream(@NotNull Stream<? extends Promise<T>> stream) {
        return AsyncSupplier.ofPromiseIterator(stream.iterator());
    }

    public static <T> AsyncSupplier<T> ofAsyncSupplierIterator(@NotNull Iterator<? extends AsyncSupplier<T>> iterator) {
        return () -> iterator.hasNext() ? ((AsyncSupplier)iterator.next()).get() : Promise.of(null);
    }

    public static <T> AsyncSupplier<T> ofAsyncSupplierIterable(@NotNull Iterable<? extends AsyncSupplier<T>> iterable) {
        return AsyncSupplier.ofAsyncSupplierIterator(iterable.iterator());
    }

    public static <T> AsyncSupplier<T> ofAsyncSupplierStream(@NotNull Stream<? extends AsyncSupplier<T>> stream) {
        return AsyncSupplier.ofAsyncSupplierIterator(stream.iterator());
    }

    @Contract(pure=true)
    @NotNull
    default public <R> R transformWith(@NotNull Function<AsyncSupplier<T>, R> fn) {
        return fn.apply(this);
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncSupplier<T> async() {
        return () -> this.get().async();
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncSupplier<Void> toVoid() {
        return () -> this.get().toVoid();
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncSupplier<Try<T>> toTry() {
        return () -> this.get().toTry();
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncSupplier<T> withExecutor(@NotNull AsyncExecutor asyncExecutor) {
        return () -> asyncExecutor.execute(this);
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncSupplier<T> peek(@NotNull Consumer<? super T> action) {
        return () -> this.get().whenResult(action);
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncSupplier<T> peekEx(@NotNull Callback<T> action) {
        return () -> this.get().whenComplete(action);
    }

    @Contract(pure=true)
    @NotNull
    default public <V> AsyncSupplier<V> map(@NotNull Function<? super T, ? extends V> fn) {
        return () -> this.get().map(fn);
    }

    @Contract(pure=true)
    @NotNull
    default public <V> AsyncSupplier<V> mapAsync(@NotNull Function<? super T, ? extends Promise<V>> fn) {
        return () -> this.get().then(fn);
    }
}

