/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncPredicates;
import io.activej.promise.Promise;
import java.util.function.Predicate;

@FunctionalInterface
public interface AsyncPredicate<T> {
    public Promise<Boolean> test(T var1);

    public static <T> AsyncPredicate<T> cast(AsyncPredicate<T> predicate) {
        return predicate;
    }

    public static <T> AsyncPredicate<T> of(Predicate<T> predicate) {
        return new AsyncPredicates.AsyncPredicateWrapper<T>(predicate);
    }

    default public AsyncPredicate<T> negate() {
        return t -> this.test(t).map(b -> b == false);
    }

    default public AsyncPredicate<T> and(AsyncPredicate<? super T> other) {
        return t -> this.test(t).combine(other.test(t), (b1, b2) -> b1 != false && b2 != false);
    }

    default public AsyncPredicate<T> or(AsyncPredicate<? super T> other) {
        return t -> this.test(t).combine(other.test(t), (b1, b2) -> b1 != false || b2 != false);
    }

    public static <T> AsyncPredicate<T> alwaysTrue() {
        return t -> Promise.of(Boolean.TRUE);
    }

    public static <T> AsyncPredicate<T> alwaysFalse() {
        return t -> Promise.of(Boolean.FALSE);
    }
}

