/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.process.AsyncExecutor;
import io.activej.promise.Promise;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncConsumer<T> {
    @NotNull
    public Promise<Void> accept(T var1);

    @NotNull
    public static <T> AsyncConsumer<T> of(@NotNull Consumer<? super T> consumer) {
        return value -> {
            consumer.accept(value);
            return Promise.complete();
        };
    }

    @Contract(pure=true)
    @NotNull
    default public <R> R transformWith(@NotNull Function<AsyncConsumer<T>, R> fn) {
        return fn.apply(this);
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncConsumer<T> async() {
        return value -> this.accept(value).async();
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncConsumer<T> withExecutor(@NotNull AsyncExecutor asyncExecutor) {
        return value -> asyncExecutor.execute(() -> this.accept(value));
    }

    @Contract(pure=true)
    @NotNull
    default public AsyncConsumer<T> peek(@NotNull Consumer<T> action) {
        return value -> {
            action.accept(value);
            return this.accept(value);
        };
    }

    @Contract(pure=true)
    @NotNull
    default public <V> AsyncConsumer<V> map(@NotNull Function<? super V, ? extends T> fn) {
        return value -> this.accept(fn.apply((Object)value));
    }

    @Contract(pure=true)
    @NotNull
    default public <V> AsyncConsumer<V> mapAsync(@NotNull Function<? super V, ? extends Promise<T>> fn) {
        return value -> ((Promise)fn.apply((Object)value)).then(this::accept);
    }
}

