/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.file;

import io.activej.async.file.AsyncFileService;
import io.activej.promise.Promise;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public final class ExecutorAsyncFileService
implements AsyncFileService {
    private final Executor executor;

    public ExecutorAsyncFileService(@NotNull Executor executor) {
        this.executor = executor;
    }

    @Override
    public Promise<Integer> read(FileChannel channel, long position, byte[] array, int offset, int size) {
        return Promise.ofBlockingCallable(this.executor, () -> {
            int readBytes;
            ByteBuffer buffer = ByteBuffer.wrap(array, offset, size);
            long pos = position;
            while ((readBytes = channel.read(buffer, pos)) != -1) {
                pos += (long)readBytes;
                if (buffer.position() < buffer.limit()) continue;
            }
            return Math.toIntExact(pos - position);
        });
    }

    @Override
    public Promise<Integer> write(FileChannel channel, long position, byte[] array, int offset, int size) {
        return Promise.ofBlockingCallable(this.executor, () -> {
            ByteBuffer buffer = ByteBuffer.wrap(array, offset, size);
            long pos = position;
            do {
                pos += (long)channel.write(buffer, pos);
            } while (buffer.position() < buffer.limit());
            return Math.toIntExact(pos - position);
        });
    }
}

