/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async;

import io.activej.async.process.AsyncCloseable;
import io.activej.common.Checks;
import io.activej.common.exception.UncheckedException;
import io.activej.common.recycle.Recyclers;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncAccumulator<A>
implements AsyncCloseable {
    private final SettablePromise<A> resultPromise = new SettablePromise();
    private boolean started;
    private final A accumulator;
    private int activePromises;

    private AsyncAccumulator(@Nullable A accumulator) {
        this.accumulator = accumulator;
    }

    public static <A> AsyncAccumulator<A> create(@Nullable A accumulator) {
        return new AsyncAccumulator<A>(accumulator);
    }

    public <T> AsyncAccumulator<A> withPromise(@NotNull Promise<T> promise, @NotNull BiConsumer<A, T> accumulator) {
        this.addPromise(promise, accumulator);
        return this;
    }

    public Promise<A> run() {
        Checks.checkState((!this.started ? 1 : 0) != 0);
        this.started = true;
        if (this.resultPromise.isComplete()) {
            return this.resultPromise;
        }
        if (this.activePromises == 0) {
            this.resultPromise.set(this.accumulator);
        }
        return this.resultPromise;
    }

    public Promise<A> run(@NotNull Promise<Void> runtimePromise) {
        this.addPromise(runtimePromise, (result, v) -> {});
        return this.run();
    }

    public <T> void addPromise(@NotNull Promise<T> promise, @NotNull BiConsumer<A, T> consumer) {
        if (this.resultPromise.isComplete()) {
            promise.whenResult(Recyclers::recycle);
            return;
        }
        ++this.activePromises;
        promise.whenComplete((v, e) -> {
            --this.activePromises;
            if (this.resultPromise.isComplete()) {
                Recyclers.recycle((Object)v);
                return;
            }
            if (e == null) {
                try {
                    consumer.accept(this.accumulator, v);
                }
                catch (UncheckedException u) {
                    this.resultPromise.setException(u.getCause());
                    Recyclers.recycle(this.accumulator);
                    return;
                }
                if (this.activePromises == 0 && this.started) {
                    this.resultPromise.set(this.accumulator);
                }
            } else {
                this.resultPromise.setException(e);
                Recyclers.recycle(this.accumulator);
            }
        });
    }

    public <V> SettablePromise<V> newPromise(@NotNull BiConsumer<A, V> consumer) {
        SettablePromise resultPromise = new SettablePromise();
        this.addPromise(resultPromise, consumer);
        return resultPromise;
    }

    @NotNull
    public Promise<A> get() {
        return this.resultPromise;
    }

    public A getAccumulator() {
        return this.accumulator;
    }

    public int getActivePromises() {
        return this.activePromises;
    }

    public void complete() {
        this.resultPromise.trySet(this.accumulator);
    }

    public void complete(A result) {
        if (this.resultPromise.trySet(result) && result != this.accumulator) {
            Recyclers.recycle(this.accumulator);
        }
    }

    @Override
    public void closeEx(@NotNull Throwable e) {
        if (this.resultPromise.trySetException(e)) {
            Recyclers.recycle(this.accumulator);
        }
    }
}

