/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.queue;

import io.activej.async.process.AsyncCloseable;
import io.activej.csp.consumer.AbstractChannelConsumer;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.process.transformer.ChannelTransformer;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.promise.Promise;
import org.jetbrains.annotations.Nullable;

public interface ChannelQueue<T>
extends ChannelTransformer<T, T>,
AsyncCloseable {
    public Promise<Void> put(@Nullable T var1);

    public Promise<T> take();

    public boolean isSaturated();

    public boolean isExhausted();

    default public ChannelConsumer<T> getConsumer() {
        return new AbstractChannelConsumer<T>(this){

            @Override
            protected Promise<Void> doAccept(T value) {
                return ChannelQueue.this.put(value);
            }
        };
    }

    default public ChannelConsumer<T> getConsumer(final Promise<Void> acknowledgement) {
        return new AbstractChannelConsumer<T>(this){

            @Override
            protected Promise<Void> doAccept(T value) {
                if (value != null) {
                    return ChannelQueue.this.put(value);
                }
                return ChannelQueue.this.put(null).both(acknowledgement);
            }
        };
    }

    default public ChannelSupplier<T> getSupplier() {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelQueue.this.take();
            }
        };
    }

    @Override
    default public ChannelConsumer<T> transform(ChannelConsumer<T> consumer) {
        Promise<Void> stream = this.getSupplier().streamTo(consumer);
        return this.getConsumer().withAcknowledgement(ack -> ack.both(stream));
    }

    @Override
    default public ChannelSupplier<T> transform(ChannelSupplier<T> supplier) {
        Promise<Void> stream = supplier.streamTo(this.getConsumer());
        return this.getSupplier().withEndOfStream(eos -> eos.both(stream));
    }
}

