/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.queue;

import io.activej.common.Checks;
import io.activej.common.recycle.Recyclers;
import io.activej.csp.queue.ChannelQueue;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.ImplicitlyReactive;
import io.activej.reactor.Reactive;
import org.jetbrains.annotations.Nullable;

public final class ChannelBuffer<T>
extends ImplicitlyReactive
implements ChannelQueue<T> {
    private static final boolean CHECKS = Checks.isEnabled(ChannelBuffer.class);
    private Exception exception;
    private Object[] elements;
    private int tail;
    private int head;
    private final int bufferMinSize;
    private final int bufferMaxSize;
    @Nullable
    private SettablePromise<Void> put;
    @Nullable
    private SettablePromise<T> take;

    public ChannelBuffer(int bufferSize) {
        this(0, bufferSize);
    }

    public ChannelBuffer(int bufferMinSize, int bufferMaxSize) {
        this.bufferMinSize = bufferMinSize + 1;
        this.bufferMaxSize = bufferMaxSize;
        this.elements = new Object[1 << 32 - Integer.numberOfLeadingZeros(Math.max(16, this.bufferMinSize) - 1)];
    }

    @Override
    public boolean isSaturated() {
        return this.size() > this.bufferMaxSize;
    }

    public boolean willBeSaturated() {
        return this.size() >= this.bufferMaxSize;
    }

    @Override
    public boolean isExhausted() {
        return this.size() < this.bufferMinSize;
    }

    public boolean willBeExhausted() {
        return this.size() <= this.bufferMinSize;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int size() {
        return this.tail - this.head;
    }

    public void add(@Nullable T item) throws Exception {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (this.exception == null) {
            if (this.take != null) {
                assert (this.isEmpty());
                SettablePromise<T> take = this.take;
                this.take = null;
                take.set(item);
                if (this.exception != null) {
                    throw this.exception;
                }
                return;
            }
        } else {
            Recyclers.recycle(item);
            throw this.exception;
        }
        this.doAdd(item);
    }

    private void doAdd(@Nullable T value) {
        this.elements[this.tail++ & this.elements.length - 1] = value;
    }

    @Nullable
    public T poll() throws Exception {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.put != null && this.willBeExhausted()) {
            T item = this.doPoll();
            SettablePromise<Void> put = this.put;
            this.put = null;
            put.set(null);
            return item;
        }
        return !this.isEmpty() ? (T)this.doPoll() : null;
    }

    private T doPoll() {
        assert (this.head != this.tail);
        int pos = this.head++ & this.elements.length - 1;
        Object result = this.elements[pos];
        this.elements[pos] = null;
        return (T)result;
    }

    @Override
    public Promise<Void> put(@Nullable T item) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.put == null ? 1 : 0) != 0, (Object)"Previous put() has not finished yet");
        }
        if (this.exception == null) {
            if (this.take != null) {
                assert (this.isEmpty());
                SettablePromise<T> take = this.take;
                this.take = null;
                take.set(item);
                return Promise.complete();
            }
            this.doAdd(item);
            if (this.isSaturated()) {
                this.put = new SettablePromise();
                return this.put;
            }
            return Promise.complete();
        }
        Recyclers.recycle(item);
        return Promise.ofException((Exception)this.exception);
    }

    @Override
    public Promise<T> take() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
            Checks.checkState((this.take == null ? 1 : 0) != 0, (Object)"Previous take() has not finished yet");
        }
        if (this.exception == null) {
            if (this.put != null && this.willBeExhausted()) {
                assert (!this.isEmpty());
                T item = this.doPoll();
                SettablePromise<Void> put = this.put;
                this.put = null;
                put.set(null);
                return Promise.of(item);
            }
            if (!this.isEmpty()) {
                return Promise.of(this.doPoll());
            }
            this.take = new SettablePromise();
            return this.take;
        }
        return Promise.ofException((Exception)this.exception);
    }

    public void closeEx(Exception e) {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.exception != null) {
            return;
        }
        this.exception = e;
        if (this.put != null) {
            this.put.setException(e);
            this.put = null;
        }
        if (this.take != null) {
            this.take.setException(e);
            this.take = null;
        }
        int i = this.head;
        while (i != this.tail) {
            Recyclers.recycle((Object)this.elements[i]);
            i = i + 1 & this.elements.length - 1;
        }
        this.elements = null;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }
}

