/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frame.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.process.frame.BlockDecoder;
import io.activej.csp.process.frame.BlockEncoder;
import io.activej.csp.process.frame.FrameFormat;
import java.util.Arrays;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class LZ4Legacy
implements FrameFormat {
    static final byte[] MAGIC = new byte[]{76, 90, 52, 66, 108, 111, 99, 107};
    static final byte[] LAST_BYTES;
    static final byte[] MAGIC_AND_LAST_BYTES;
    static final int MAGIC_LENGTH;
    static final int COMPRESSION_LEVEL_BASE = 10;
    static final int COMPRESSION_METHOD_RAW = 16;
    static final int COMPRESSION_METHOD_LZ4 = 32;
    static final int HEADER_LENGTH;
    static final int DEFAULT_SEED = -1756908916;
    public LZ4Factory lz4Factory;
    public XXHashFactory hashFactory;
    public boolean legacyChecksum;
    public int compressionLevel;
    public boolean ignoreMissingEndOfStreamBlock;

    public LZ4Legacy(LZ4Factory factory, XXHashFactory hashFactory, boolean legacyChecksum, int compressionLevel, boolean ignoreMissingEndOfStreamBlock) {
        this.lz4Factory = factory;
        this.hashFactory = hashFactory;
        this.legacyChecksum = legacyChecksum;
        this.compressionLevel = compressionLevel;
        this.ignoreMissingEndOfStreamBlock = ignoreMissingEndOfStreamBlock;
    }

    public static LZ4Legacy create() {
        return (LZ4Legacy)LZ4Legacy.builder().build();
    }

    public static Builder builder() {
        return new LZ4Legacy(LZ4Factory.fastestInstance(), XXHashFactory.fastestInstance(), false, 0, false).new Builder();
    }

    @Override
    public BlockEncoder createEncoder() {
        LZ4Compressor compressor = this.compressionLevel == 0 ? this.lz4Factory.fastCompressor() : (this.compressionLevel == -1 ? this.lz4Factory.highCompressor() : this.lz4Factory.highCompressor(this.compressionLevel));
        StreamingXXHash32 hash = this.hashFactory.newStreamingHash32(-1756908916);
        Checksum checksum = this.legacyChecksum ? hash.asChecksum() : LZ4Legacy.toSimpleChecksum(hash);
        return new Encoder(compressor, checksum);
    }

    @Override
    public BlockDecoder createDecoder() {
        StreamingXXHash32 hash = this.hashFactory.newStreamingHash32(-1756908916);
        Checksum checksum = this.legacyChecksum ? hash.asChecksum() : LZ4Legacy.toSimpleChecksum(hash);
        return new Decoder(this.lz4Factory.fastDecompressor(), checksum, this.ignoreMissingEndOfStreamBlock);
    }

    private static Checksum toSimpleChecksum(final StreamingXXHash32 hash) {
        return new Checksum(){

            @Override
            public void update(int b) {
                hash.update(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void update(byte[] b, int off, int len) {
                hash.update(b, off, len);
            }

            @Override
            public long getValue() {
                return hash.getValue();
            }

            @Override
            public void reset() {
                hash.reset();
            }
        };
    }

    static {
        MAGIC_LENGTH = MAGIC.length;
        LAST_BYTES = new byte[13];
        LZ4Legacy.LAST_BYTES[0] = 16;
        MAGIC_AND_LAST_BYTES = new byte[MAGIC.length + LAST_BYTES.length];
        System.arraycopy(MAGIC, 0, MAGIC_AND_LAST_BYTES, 0, MAGIC.length);
        LZ4Legacy.MAGIC_AND_LAST_BYTES[LZ4Legacy.MAGIC.length] = 16;
        HEADER_LENGTH = MAGIC.length + 1 + 4 + 4 + 4;
    }

    public final class Builder
    extends AbstractBuilder<Builder, LZ4Legacy> {
        private Builder() {
        }

        public Builder withLZ4Factory(LZ4Factory factory) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4Legacy.this.lz4Factory = factory;
            return this;
        }

        public Builder withHashFactory(XXHashFactory factory) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4Legacy.this.hashFactory = factory;
            return this;
        }

        public Builder withHighCompression() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4Legacy.this.compressionLevel = -1;
            return this;
        }

        public Builder withCompressionLevel(int compressionLevel) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((compressionLevel >= -1 ? 1 : 0) != 0);
            LZ4Legacy.this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder withIgnoreMissingEndOfStream(boolean ignore) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4Legacy.this.ignoreMissingEndOfStreamBlock = ignore;
            return this;
        }

        @Deprecated
        public Builder withLegacyChecksum(boolean legacyChecksum) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4Legacy.this.legacyChecksum = legacyChecksum;
            return this;
        }

        protected LZ4Legacy doBuild() {
            return LZ4Legacy.this;
        }
    }

    @Deprecated
    public static final class Encoder
    implements BlockEncoder {
        private static final boolean CHECKS = Checks.isEnabled(Encoder.class);
        private static final int MIN_BLOCK_SIZE = 64;
        private static final int MAX_BLOCK_SIZE = 0x2000000;
        private final LZ4Compressor compressor;
        private final Checksum checksum;

        Encoder(LZ4Compressor compressor, Checksum checksum) {
            this.compressor = compressor;
            this.checksum = checksum;
        }

        @Override
        public void reset() {
        }

        @Override
        public ByteBuf encode(ByteBuf inputBuf) {
            int compressMethod;
            int len = inputBuf.readRemaining();
            if (CHECKS) {
                Checks.checkArgument((len != 0 ? 1 : 0) != 0);
            }
            int off = inputBuf.head();
            byte[] bytes = inputBuf.array();
            int compressionLevel = Encoder.compressionLevel(Math.min(Math.max(len, 64), 0x2000000));
            int outputBufMaxSize = HEADER_LENGTH + this.compressor.maxCompressedLength(len);
            ByteBuf outputBuf = ByteBufPool.allocate((int)outputBufMaxSize);
            outputBuf.put(MAGIC);
            byte[] outputBytes = outputBuf.array();
            this.checksum.reset();
            this.checksum.update(bytes, off, len);
            int check = (int)this.checksum.getValue();
            int compressedLength = this.compressor.compress(bytes, off, len, outputBytes, HEADER_LENGTH);
            if (compressedLength >= len) {
                compressMethod = 16;
                compressedLength = len;
                System.arraycopy(bytes, off, outputBytes, HEADER_LENGTH, len);
            } else {
                compressMethod = 32;
            }
            outputBytes[LZ4Legacy.MAGIC_LENGTH] = (byte)(compressMethod | compressionLevel);
            Encoder.writeIntLE(compressedLength, outputBytes, MAGIC_LENGTH + 1);
            Encoder.writeIntLE(len, outputBytes, MAGIC_LENGTH + 5);
            Encoder.writeIntLE(check, outputBytes, MAGIC_LENGTH + 9);
            outputBuf.tail(HEADER_LENGTH + compressedLength);
            return outputBuf;
        }

        @Override
        public ByteBuf encodeEndOfStreamBlock() {
            return ByteBuf.wrapForReading((byte[])MAGIC_AND_LAST_BYTES);
        }

        private static int compressionLevel(int blockSize) {
            int compressionLevel = 32 - Integer.numberOfLeadingZeros(blockSize - 1);
            if (CHECKS) {
                Checks.checkArgument((1 << compressionLevel >= blockSize ? 1 : 0) != 0);
                Checks.checkArgument((blockSize * 2 > 1 << compressionLevel ? 1 : 0) != 0);
            }
            compressionLevel = Math.max(0, compressionLevel - 10);
            if (CHECKS) {
                Checks.checkArgument((compressionLevel <= 15 ? 1 : 0) != 0);
            }
            return compressionLevel;
        }

        private static void writeIntLE(int i, byte[] buf, int off) {
            buf[off++] = (byte)i;
            buf[off++] = (byte)(i >>> 8);
            buf[off++] = (byte)(i >>> 16);
            buf[off] = (byte)(i >>> 24);
        }
    }

    @Deprecated
    public static final class Decoder
    implements BlockDecoder {
        private final LZ4FastDecompressor decompressor;
        private final Checksum checksum;
        private final boolean ignoreMissingEndOfStreamBlock;
        private int originalLen;
        private int compressedLen;
        private int compressionMethod;
        private int check;
        private boolean endOfStream;
        private boolean readingHeader = true;
        private final IntLeByteScanner intLEScanner = new IntLeByteScanner();

        Decoder(LZ4FastDecompressor decompressor, Checksum checksum, boolean ignoreMissingEndOfStreamBlock) {
            this.decompressor = decompressor;
            this.checksum = checksum;
            this.ignoreMissingEndOfStreamBlock = ignoreMissingEndOfStreamBlock;
        }

        @Override
        public void reset() {
            this.endOfStream = false;
        }

        @Override
        @Nullable
        public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
            if (this.readingHeader) {
                if (!this.readHeader(bufs)) {
                    return null;
                }
                this.readingHeader = false;
            }
            if (!bufs.hasRemainingBytes(this.compressedLen)) {
                return null;
            }
            this.readingHeader = true;
            if (this.endOfStream) {
                return END_OF_STREAM;
            }
            return this.decompressBody(bufs);
        }

        @Override
        public boolean ignoreMissingEndOfStreamBlock() {
            return this.ignoreMissingEndOfStreamBlock;
        }

        private boolean readHeader(ByteBufs bufs) throws MalformedDataException {
            bufs.scanBytes((index, value) -> {
                if (value != MAGIC[index]) {
                    throw new UnknownFormatException("Expected stream to start with bytes: " + Arrays.toString(MAGIC));
                }
                return index == MAGIC_LENGTH - 1;
            });
            if (!bufs.hasRemainingBytes(HEADER_LENGTH)) {
                return false;
            }
            bufs.skip(MAGIC_LENGTH);
            int token = bufs.getByte() & 0xFF;
            this.compressionMethod = token & 0xF0;
            int compressionLevel = 10 + (token & 0xF);
            if (this.compressionMethod != 16 && this.compressionMethod != 32) {
                throw new UnknownFormatException("Unknown compression method");
            }
            this.compressedLen = this.readInt(bufs);
            this.originalLen = this.readInt(bufs);
            this.check = this.readInt(bufs);
            if (this.originalLen > 1 << compressionLevel || this.originalLen < 0 || this.compressedLen < 0 || this.originalLen == 0 && this.compressedLen != 0 || this.originalLen != 0 && this.compressedLen == 0 || this.compressionMethod == 16 && this.originalLen != this.compressedLen) {
                throw new MalformedDataException("Malformed header");
            }
            if (this.originalLen == 0) {
                if (this.check != 0) {
                    throw new MalformedDataException("Checksum in last block is not allowed");
                }
                this.endOfStream = true;
            }
            return true;
        }

        private int readInt(ByteBufs bufs) throws MalformedDataException {
            bufs.consumeBytes((ByteBufs.ByteScanner)this.intLEScanner);
            return this.intLEScanner.value;
        }

        private ByteBuf decompressBody(ByteBufs bufs) throws MalformedDataException {
            ByteBuf inputBuf = bufs.takeExactSize(this.compressedLen);
            ByteBuf outputBuf = ByteBufPool.allocate((int)this.originalLen);
            try {
                byte[] bytes = inputBuf.array();
                int off = inputBuf.head();
                outputBuf.tail(this.originalLen);
                if (this.compressionMethod == 16) {
                    System.arraycopy(bytes, off, outputBuf.array(), 0, this.originalLen);
                } else {
                    assert (this.compressionMethod == 32);
                    try {
                        int compressedLen = this.decompressor.decompress(bytes, off, outputBuf.array(), 0, this.originalLen);
                        if (compressedLen != this.compressedLen) {
                            throw new InvalidSizeException("Actual size of decompressed data does not equal expected size of decompressed data");
                        }
                    }
                    catch (LZ4Exception e) {
                        throw new MalformedDataException("Failed to decompress data", (Throwable)e);
                    }
                }
                this.checksum.reset();
                this.checksum.update(outputBuf.array(), 0, this.originalLen);
                if (this.checksum.getValue() != (long)this.check) {
                    throw new MalformedDataException("Checksums do not match. Received: (" + this.check + "), actual: (" + this.checksum.getValue() + ")");
                }
                ByteBuf byteBuf = outputBuf;
                return byteBuf;
            }
            catch (Exception e) {
                outputBuf.recycle();
                throw e;
            }
            finally {
                inputBuf.recycle();
            }
        }

        public static final class IntLeByteScanner
        implements ByteBufs.ByteScanner {
            int value;

            public boolean consume(int index, byte b) {
                this.value = (index == 0 ? 0 : this.value >>> 8) | (b & 0xFF) << 24;
                return index == 3;
            }
        }
    }
}

