/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frame;

import io.activej.common.Checks;
import io.activej.csp.process.frame.FrameFormat;
import io.activej.csp.process.frame.impl.Compound;
import io.activej.csp.process.frame.impl.Identity;
import io.activej.csp.process.frame.impl.LZ4;
import io.activej.csp.process.frame.impl.LZ4Legacy;
import io.activej.csp.process.frame.impl.MagicNumberAdapter;
import io.activej.csp.process.frame.impl.SizePrefixed;
import java.util.ArrayList;
import java.util.List;

public class FrameFormats {
    public static FrameFormat lz4() {
        return LZ4.create();
    }

    @Deprecated
    public static FrameFormat lz4Legacy() {
        return LZ4Legacy.create();
    }

    public static FrameFormat compound(FrameFormat mainFormat, FrameFormat ... otherFormats) {
        ArrayList<FrameFormat> formats = new ArrayList<FrameFormat>();
        formats.add(mainFormat);
        formats.addAll(List.of(otherFormats));
        return new Compound(formats);
    }

    public static FrameFormat identity() {
        return new Identity();
    }

    public static FrameFormat sizePrefixed() {
        return new SizePrefixed();
    }

    public static FrameFormat withMagicNumber(FrameFormat frameFormat, byte[] magicNumber) {
        Checks.checkArgument((magicNumber.length != 0 ? 1 : 0) != 0, (Object)"Empty magic number");
        return new MagicNumberAdapter(frameFormat, magicNumber);
    }
}

