/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.net;

import io.activej.async.process.AbstractAsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.exception.TruncatedDataException;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.binary.codec.ByteBufsCodec;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.consumer.ChannelConsumers;
import io.activej.csp.net.IMessaging;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.csp.supplier.ChannelSuppliers;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.promise.Promise;
import io.activej.reactor.Reactive;

public final class Messaging<I, O>
extends AbstractAsyncCloseable
implements IMessaging<I, O> {
    private static final boolean CHECKS = Checks.isEnabled(Messaging.class);
    private final ITcpSocket socket;
    private final ByteBufsCodec<I, O> codec;
    private final ByteBufs bufs = new ByteBufs();
    private final BinaryChannelSupplier bufsSupplier;
    private boolean readDone;
    private boolean writeDone;

    private Messaging(ITcpSocket socket, ByteBufsCodec<I, O> codec) {
        this.socket = socket;
        this.codec = codec;
        this.bufsSupplier = BinaryChannelSupplier.ofProvidedBufs(this.bufs, () -> this.socket.read().whenResult(buf -> {
            if (buf == null) {
                throw new TruncatedDataException();
            }
            this.bufs.add(buf);
        }).toVoid().whenException(arg_0 -> ((Messaging)this).closeEx(arg_0)), Promise::complete, this);
    }

    public static <I, O> Messaging<I, O> create(ITcpSocket socket, ByteBufsCodec<I, O> serializer) {
        Messaging<I, O> messaging = new Messaging<I, O>(socket, serializer);
        messaging.prefetch();
        return messaging;
    }

    private void prefetch() {
        if (this.bufs.isEmpty()) {
            this.socket.read().whenResult(buf -> {
                if (buf != null) {
                    this.bufs.add(buf);
                } else {
                    this.readDone = true;
                    this.closeIfDone();
                }
            }).whenException(arg_0 -> ((Messaging)this).closeEx(arg_0));
        }
    }

    @Override
    public Promise<I> receive() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return this.bufsSupplier.decode(this.codec::tryDecode).whenResult(this::prefetch).whenException(arg_0 -> ((Messaging)this).closeEx(arg_0));
    }

    @Override
    public Promise<Void> send(O msg) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return this.socket.write(this.codec.encode(msg));
    }

    @Override
    public Promise<Void> sendEndOfStream() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return this.socket.write(null).whenResult(() -> {
            this.writeDone = true;
            this.closeIfDone();
        }).whenException(arg_0 -> ((Messaging)this).closeEx(arg_0));
    }

    @Override
    public ChannelConsumer<ByteBuf> sendBinaryStream() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return ChannelConsumers.ofSocket(this.socket).withAcknowledgement(ack -> ack.whenResult(() -> {
            this.writeDone = true;
            this.closeIfDone();
        }));
    }

    @Override
    public ChannelSupplier<ByteBuf> receiveBinaryStream() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return ChannelSuppliers.concat(ChannelSuppliers.ofIterator(this.bufs.asIterator()), ChannelSuppliers.ofSocket(this.socket)).withEndOfStream(eos -> eos.whenResult(() -> {
            this.readDone = true;
            this.closeIfDone();
        }));
    }

    protected void onClosed(Exception e) {
        this.socket.closeEx(e);
        this.bufs.recycle();
    }

    private void closeIfDone() {
        if (this.readDone && this.writeDone) {
            this.close();
        }
    }

    public String toString() {
        return "Messaging{socket=" + this.socket + "}";
    }
}

