/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.file;

import io.activej.async.exception.AsyncCloseException;
import io.activej.async.file.ExecutorFileService;
import io.activej.async.file.IFileService;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.builder.AbstractBuilder;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelFileReader
extends AbstractChannelSupplier<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFileReader.class);
    private static final OpenOption[] DEFAULT_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    public static final MemSize DEFAULT_BUFFER_SIZE = MemSize.kilobytes((long)8L);
    private final IFileService fileService;
    private final FileChannel channel;
    private int bufferSize = DEFAULT_BUFFER_SIZE.toInt();
    private long position = 0L;
    private long limit = Long.MAX_VALUE;

    private ChannelFileReader(IFileService fileService, FileChannel channel) {
        this.fileService = fileService;
        this.channel = channel;
    }

    public static ChannelFileReader create(Reactor reactor, Executor executor, FileChannel channel) {
        return (ChannelFileReader)ChannelFileReader.builder(reactor, executor, channel).build();
    }

    public static ChannelFileReader create(IFileService fileService, FileChannel channel) {
        return (ChannelFileReader)ChannelFileReader.builder(fileService, channel).build();
    }

    public static Promise<ChannelFileReader> open(Executor executor, Path path) {
        return ChannelFileReader.open(executor, path, DEFAULT_OPTIONS);
    }

    public static Promise<ChannelFileReader> open(Executor executor, Path path, OpenOption ... openOptions) {
        return ChannelFileReader.builderOpen(executor, path, openOptions).map(AbstractBuilder::build);
    }

    public static ChannelFileReader openBlocking(Reactor reactor, Executor executor, Path path) throws IOException {
        return ChannelFileReader.openBlocking(reactor, executor, path, DEFAULT_OPTIONS);
    }

    public static ChannelFileReader openBlocking(Reactor reactor, Executor executor, Path path, OpenOption ... openOptions) throws IOException {
        return (ChannelFileReader)ChannelFileReader.builderBlocking(reactor, executor, path, openOptions).build();
    }

    public static Builder builder(Reactor reactor, Executor executor, FileChannel channel) {
        return ChannelFileReader.builder((IFileService)new ExecutorFileService(reactor, executor), channel);
    }

    public static Builder builder(IFileService fileService, FileChannel channel) {
        return new ChannelFileReader(fileService, channel).new Builder();
    }

    public static Promise<Builder> builderOpen(Executor executor, Path path) {
        return ChannelFileReader.builderOpen(executor, path, DEFAULT_OPTIONS);
    }

    public static Promise<Builder> builderOpen(Executor executor, Path path, OpenOption ... openOptions) {
        Checks.checkArgument((boolean)List.of(openOptions).contains(StandardOpenOption.READ), (Object)"'READ' option is not present");
        return Promise.ofBlocking((Executor)executor, () -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new FileSystemException(path.toString(), null, "Is a directory");
            }
            return FileChannel.open(path, openOptions);
        }).map(channel -> ChannelFileReader.builder(Reactor.getCurrentReactor(), executor, channel));
    }

    public static Builder builderBlocking(Reactor reactor, Executor executor, Path path) throws IOException {
        return ChannelFileReader.builderBlocking(reactor, executor, path, DEFAULT_OPTIONS);
    }

    public static Builder builderBlocking(Reactor reactor, Executor executor, Path path, OpenOption ... openOptions) throws IOException {
        Checks.checkArgument((boolean)List.of(openOptions).contains(StandardOpenOption.READ), (Object)"'READ' option is not present");
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new FileSystemException(path.toString(), null, "Is a directory");
        }
        FileChannel channel = FileChannel.open(path, openOptions);
        return ChannelFileReader.builder(reactor, executor, channel);
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    protected Promise<ByteBuf> doGet() {
        if (this.limit == 0L) {
            this.close();
            return Promise.of(null);
        }
        ByteBuf buf = ByteBufPool.allocateExact((int)((int)Math.min((long)this.bufferSize, this.limit)));
        return this.fileService.read(this.channel, this.position, buf.array(), buf.head(), buf.writeRemaining()).then(bytesRead -> {
            if (bytesRead == 0) {
                buf.recycle();
                this.close();
                return Promise.of(null);
            }
            buf.moveTail(Math.toIntExact(bytesRead.intValue()));
            this.position += (long)bytesRead.intValue();
            if (this.limit != Long.MAX_VALUE) {
                this.limit -= (long)bytesRead.intValue();
            }
            return Promise.of((Object)buf);
        }, e -> {
            buf.recycle();
            this.closeEx((Exception)e);
            return Promise.ofException((Exception)this.getException());
        });
    }

    protected void onClosed(Exception e) {
        try {
            if (!this.channel.isOpen()) {
                throw new AsyncCloseException("File has been closed");
            }
            this.channel.close();
            logger.trace("{}: closed file", (Object)this);
        }
        catch (AsyncCloseException | IOException e1) {
            logger.error("{}: failed to close file", (Object)this, (Object)e1);
        }
    }

    public String toString() {
        return "ChannelFileReader{pos=" + this.position + (String)(this.limit == Long.MAX_VALUE ? "" : ", limit=" + this.limit) + "}";
    }

    public final class Builder
    extends AbstractBuilder<Builder, ChannelFileReader> {
        private Builder() {
        }

        public Builder withBufferSize(MemSize bufferSize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withBufferSize(bufferSize.toInt());
        }

        public Builder withBufferSize(int bufferSize) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Buffer size cannot be less than or equal to zero");
            ChannelFileReader.this.bufferSize = bufferSize;
            return this;
        }

        public Builder withOffset(long offset) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"Offset cannot be less than zero");
            ChannelFileReader.this.position = offset;
            return this;
        }

        public Builder withLimit(long limit) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"Limit cannot be less than zero");
            ChannelFileReader.this.limit = limit;
            return this;
        }

        protected ChannelFileReader doBuild() {
            return ChannelFileReader.this;
        }
    }
}

