/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.consumer.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.csp.consumer.AbstractChannelConsumer;
import io.activej.promise.Promise;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Nullable;

public final class OfOutputStream
extends AbstractChannelConsumer<ByteBuf> {
    public final Executor executor;
    public final OutputStream outputStream;

    public OfOutputStream(Executor executor, OutputStream outputStream) {
        this.executor = executor;
        this.outputStream = outputStream;
    }

    @Override
    protected Promise<Void> doAccept(@Nullable ByteBuf buf) {
        return Promise.ofBlocking((Executor)this.executor, () -> {
            if (buf != null) {
                try {
                    this.outputStream.write(buf.array(), buf.head(), buf.readRemaining());
                }
                finally {
                    buf.recycle();
                }
            } else {
                this.outputStream.flush();
                this.outputStream.close();
            }
        });
    }

    protected void onClosed(Exception e) {
        this.executor.execute(() -> {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

