/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.consumer;

import io.activej.async.process.AbstractAsyncCloseable;
import io.activej.async.process.AsyncCloseable;
import io.activej.common.Checks;
import io.activej.common.recycle.Recyclers;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.promise.Promise;
import io.activej.reactor.Reactive;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChannelConsumer<T>
extends AbstractAsyncCloseable
implements ChannelConsumer<T> {
    private static final boolean CHECKS = Checks.isEnabled(AbstractChannelConsumer.class);

    protected AbstractChannelConsumer() {
        this.setCloseable(null);
    }

    protected AbstractChannelConsumer(@Nullable AsyncCloseable closeable) {
        this.setCloseable(closeable);
    }

    protected abstract Promise<Void> doAccept(@Nullable T var1);

    @Override
    public final Promise<Void> accept(@Nullable T value) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (this.isClosed()) {
            Recyclers.recycle(value);
            return Promise.ofException((Exception)this.getException());
        }
        return this.doAccept(value);
    }
}

