/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.ser.std;

import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.core.type.WritableTypeId;
import datahub.shaded.jackson.databind.JavaType;
import datahub.shaded.jackson.databind.JsonMappingException;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.SerializerProvider;
import datahub.shaded.jackson.databind.annotation.JacksonStdImpl;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import datahub.shaded.jackson.databind.jsontype.TypeSerializer;
import datahub.shaded.jackson.databind.node.ObjectNode;
import datahub.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g2.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

