/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.jsontype.impl;

import datahub.shaded.jackson.annotation.JsonTypeInfo;
import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.core.util.JsonParserSequence;
import datahub.shaded.jackson.databind.BeanProperty;
import datahub.shaded.jackson.databind.DeserializationContext;
import datahub.shaded.jackson.databind.JavaType;
import datahub.shaded.jackson.databind.JsonDeserializer;
import datahub.shaded.jackson.databind.jsontype.TypeDeserializer;
import datahub.shaded.jackson.databind.jsontype.TypeIdResolver;
import datahub.shaded.jackson.databind.jsontype.impl.TypeDeserializerBase;
import datahub.shaded.jackson.databind.util.ClassUtil;
import datahub.shaded.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;

public class AsArrayTypeDeserializer
extends TypeDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    public AsArrayTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    public AsArrayTypeDeserializer(AsArrayTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsArrayTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserialize(jp, ctxt);
    }

    protected Object _deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (p.canReadTypeId() && (typeId = p.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(p, ctxt, typeId);
        }
        boolean hadStartArray = p.isExpectedStartArrayToken();
        String typeId2 = this._locateTypeId(p, ctxt);
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId2);
        if (this._typeIdVisible && !this._usesExternalId() && p.hasToken(JsonToken.START_OBJECT)) {
            TokenBuffer tb = ctxt.bufferForInputBuffering(p);
            tb.writeStartObject();
            tb.writeFieldName(this._typePropertyName);
            tb.writeString(typeId2);
            p.clearCurrentToken();
            p = JsonParserSequence.createFlattened(false, tb.asParser(p), p);
            p.nextToken();
        }
        if (hadStartArray && p.currentToken() == JsonToken.END_ARRAY) {
            return deser.getNullValue(ctxt);
        }
        Object value = deser.deserialize(p, ctxt);
        if (hadStartArray && p.nextToken() != JsonToken.END_ARRAY) {
            ctxt.reportWrongTokenException(this.baseType(), JsonToken.END_ARRAY, "expected closing `JsonToken.END_ARRAY` after type information and deserialized value", new Object[0]);
        }
        return value;
    }

    protected String _locateTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            if (this._defaultImpl != null) {
                String id = this._idResolver.idFromBaseType();
                if (id == null) {
                    ctxt.reportBadDefinition(this._idResolver.getClass(), "`idFromBaseType()` (of " + ClassUtil.classNameOf(this._idResolver) + ") returned `null`");
                }
                return id;
            }
            ctxt.reportWrongTokenException(this.baseType(), JsonToken.START_ARRAY, "need Array value to contain `As.WRAPPER_ARRAY` type information for class " + this.baseTypeName(), new Object[0]);
            return null;
        }
        JsonToken t2 = p.nextToken();
        if (t2 == JsonToken.VALUE_STRING || t2 != null && t2.isScalarValue()) {
            String result = p.getText();
            p.nextToken();
            return result;
        }
        ctxt.reportWrongTokenException(this.baseType(), JsonToken.VALUE_STRING, "need String, Number of Boolean value that contains type id (for subtype of %s)", this.baseTypeName());
        return null;
    }

    protected boolean _usesExternalId() {
        return false;
    }
}

