/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.deser.std;

import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.databind.DeserializationContext;
import datahub.shaded.jackson.databind.JsonMappingException;
import datahub.shaded.jackson.databind.deser.std.StdScalarDeserializer;
import datahub.shaded.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (t2 == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        Boolean b = this._parseBoolean(p, ctxt, AtomicBoolean.class);
        return b == null ? null : new AtomicBoolean(b);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicBoolean(false);
    }
}

