/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.timeseries;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.timeseries.TimeseriesIndexSizeResultArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimeseriesIndicesSizesResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.timeseries/**Encapsulates the response of the getIndexSizes API*/record TimeseriesIndicesSizesResult{/**Collection of index sizes for all indices in the result*/indexSizes:array[/**Encapsulates the response of the getIndexSizes API*/record TimeseriesIndexSizeResult{/**Name of the index*/indexName:string/**Name of the entity associated with the index*/entityName:string/**Name of the aspect associated with the index*/aspectName:string/**Size*/@deprecated=\"use sizeInMb instead\"sizeMb:float=0.0,sizeInMb:double=0.0}]}", SchemaFormatType.PDL);
    private TimeseriesIndexSizeResultArray _indexSizesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_IndexSizes = SCHEMA.getField("indexSizes");

    public TimeseriesIndicesSizesResult() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public TimeseriesIndicesSizesResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasIndexSizes() {
        if (this._indexSizesField != null) {
            return true;
        }
        return this._map.containsKey("indexSizes");
    }

    public void removeIndexSizes() {
        this._map.remove("indexSizes");
    }

    @Nullable
    public TimeseriesIndexSizeResultArray getIndexSizes(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getIndexSizes();
            }
            case DEFAULT: 
            case NULL: {
                if (this._indexSizesField != null) {
                    return this._indexSizesField;
                }
                Object __rawValue = this._map.get("indexSizes");
                this._indexSizesField = __rawValue == null ? null : new TimeseriesIndexSizeResultArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._indexSizesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TimeseriesIndexSizeResultArray getIndexSizes() {
        if (this._indexSizesField != null) {
            return this._indexSizesField;
        }
        Object __rawValue = this._map.get("indexSizes");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("indexSizes");
        }
        this._indexSizesField = __rawValue == null ? null : new TimeseriesIndexSizeResultArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._indexSizesField;
    }

    public TimeseriesIndicesSizesResult setIndexSizes(@Nullable TimeseriesIndexSizeResultArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIndexSizes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field indexSizes of com.linkedin.timeseries.TimeseriesIndicesSizesResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "indexSizes", value.data());
                this._indexSizesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIndexSizes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "indexSizes", value.data());
                this._indexSizesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "indexSizes", value.data());
                this._indexSizesField = value;
            }
        }
        return this;
    }

    public TimeseriesIndicesSizesResult setIndexSizes(@Nonnull TimeseriesIndexSizeResultArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field indexSizes of com.linkedin.timeseries.TimeseriesIndicesSizesResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "indexSizes", value.data());
        this._indexSizesField = value;
        return this;
    }

    @Override
    public TimeseriesIndicesSizesResult clone() throws CloneNotSupportedException {
        TimeseriesIndicesSizesResult __clone = (TimeseriesIndicesSizesResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TimeseriesIndicesSizesResult copy() throws CloneNotSupportedException {
        TimeseriesIndicesSizesResult __copy = (TimeseriesIndicesSizesResult)super.copy();
        __copy._indexSizesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TimeseriesIndicesSizesResult __objectRef;

        private ChangeListener(TimeseriesIndicesSizesResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "indexSizes": {
                    this.__objectRef._indexSizesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public TimeseriesIndexSizeResultArray.Fields indexSizes() {
            return new TimeseriesIndexSizeResultArray.Fields(this.getPathComponents(), "indexSizes");
        }

        public PathSpec indexSizes(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "indexSizes");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeseriesIndexSizeResultArray.ProjectionMask _indexSizesMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withIndexSizes(Function<TimeseriesIndexSizeResultArray.ProjectionMask, TimeseriesIndexSizeResultArray.ProjectionMask> nestedMask) {
            this._indexSizesMask = nestedMask.apply(this._indexSizesMask == null ? TimeseriesIndexSizeResultArray.createMask() : this._indexSizesMask);
            this.getDataMap().put("indexSizes", this._indexSizesMask.getDataMap());
            return this;
        }

        public ProjectionMask withIndexSizes() {
            this._indexSizesMask = null;
            this.getDataMap().put("indexSizes", 1);
            return this;
        }

        public ProjectionMask withIndexSizes(Function<TimeseriesIndexSizeResultArray.ProjectionMask, TimeseriesIndexSizeResultArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._indexSizesMask = nestedMask.apply(this._indexSizesMask == null ? TimeseriesIndexSizeResultArray.createMask() : this._indexSizesMask);
            this.getDataMap().put("indexSizes", this._indexSizesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("indexSizes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("indexSizes").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withIndexSizes(Integer start, Integer count) {
            this._indexSizesMask = null;
            this.getDataMap().put("indexSizes", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("indexSizes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("indexSizes").put("$count", count);
            }
            return this;
        }
    }
}

