/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.timeseries;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.timeseries.PartitionType;
import com.linkedin.timeseries.TimeWindow;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PartitionSpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.timeseries/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}", SchemaFormatType.PDL);
    private String _partitionField = null;
    private TimeWindow _timePartitionField = null;
    private PartitionType _typeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Partition = SCHEMA.getField("partition");
    private static final RecordDataSchema.Field FIELD_TimePartition = SCHEMA.getField("timePartition");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final PartitionType DEFAULT_Type = DataTemplateUtil.coerceEnumOutput(FIELD_Type.getDefault(), PartitionType.class, PartitionType.$UNKNOWN);

    public PartitionSpec() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public PartitionSpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPartition() {
        if (this._partitionField != null) {
            return true;
        }
        return this._map.containsKey("partition");
    }

    public void removePartition() {
        this._map.remove("partition");
    }

    @Nullable
    public String getPartition(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPartition();
            }
            case DEFAULT: 
            case NULL: {
                if (this._partitionField != null) {
                    return this._partitionField;
                }
                Object __rawValue = this._map.get("partition");
                this._partitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._partitionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPartition() {
        if (this._partitionField != null) {
            return this._partitionField;
        }
        Object __rawValue = this._map.get("partition");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("partition");
        }
        this._partitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._partitionField;
    }

    public PartitionSpec setPartition(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field partition of com.linkedin.timeseries.PartitionSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "partition", value);
                this._partitionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partition", value);
                this._partitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partition", value);
                this._partitionField = value;
            }
        }
        return this;
    }

    public PartitionSpec setPartition(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partition of com.linkedin.timeseries.PartitionSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partition", value);
        this._partitionField = value;
        return this;
    }

    public boolean hasTimePartition() {
        if (this._timePartitionField != null) {
            return true;
        }
        return this._map.containsKey("timePartition");
    }

    public void removeTimePartition() {
        this._map.remove("timePartition");
    }

    @Nullable
    public TimeWindow getTimePartition(GetMode mode) {
        return this.getTimePartition();
    }

    @Nullable
    public TimeWindow getTimePartition() {
        if (this._timePartitionField != null) {
            return this._timePartitionField;
        }
        Object __rawValue = this._map.get("timePartition");
        this._timePartitionField = __rawValue == null ? null : new TimeWindow(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._timePartitionField;
    }

    public PartitionSpec setTimePartition(@Nullable TimeWindow value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimePartition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimePartition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timePartition", value.data());
                this._timePartitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timePartition", value.data());
                this._timePartitionField = value;
            }
        }
        return this;
    }

    public PartitionSpec setTimePartition(@Nonnull TimeWindow value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timePartition of com.linkedin.timeseries.PartitionSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timePartition", value.data());
        this._timePartitionField = value;
        return this;
    }

    @Deprecated
    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    @Deprecated
    public void removeType() {
        this._map.remove("type");
    }

    @Deprecated
    @Nullable
    public PartitionType getType(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getType();
            }
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PartitionType.class, PartitionType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public PartitionType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            return DEFAULT_Type;
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PartitionType.class, PartitionType.$UNKNOWN);
        return this._typeField;
    }

    @Deprecated
    public PartitionSpec setType(@Nullable PartitionType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.timeseries.PartitionSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    @Deprecated
    public PartitionSpec setType(@Nonnull PartitionType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.timeseries.PartitionSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    @Override
    public PartitionSpec clone() throws CloneNotSupportedException {
        PartitionSpec __clone = (PartitionSpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PartitionSpec copy() throws CloneNotSupportedException {
        PartitionSpec __copy = (PartitionSpec)super.copy();
        __copy._partitionField = null;
        __copy._typeField = null;
        __copy._timePartitionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PartitionSpec __objectRef;

        private ChangeListener(PartitionSpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "partition": {
                    this.__objectRef._partitionField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "timePartition": {
                    this.__objectRef._timePartitionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec partition() {
            return new PathSpec(this.getPathComponents(), "partition");
        }

        public TimeWindow.Fields timePartition() {
            return new TimeWindow.Fields(this.getPathComponents(), "timePartition");
        }

        @Deprecated
        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindow.ProjectionMask _timePartitionMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withPartition() {
            this.getDataMap().put("partition", 1);
            return this;
        }

        public ProjectionMask withTimePartition(Function<TimeWindow.ProjectionMask, TimeWindow.ProjectionMask> nestedMask) {
            this._timePartitionMask = nestedMask.apply(this._timePartitionMask == null ? TimeWindow.createMask() : this._timePartitionMask);
            this.getDataMap().put("timePartition", this._timePartitionMask.getDataMap());
            return this;
        }

        public ProjectionMask withTimePartition() {
            this._timePartitionMask = null;
            this.getDataMap().put("timePartition", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }
    }
}

