/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.schema.BinaryJsonSchema;
import com.linkedin.schema.EspressoSchema;
import com.linkedin.schema.ForeignKeyConstraintArray;
import com.linkedin.schema.ForeignKeySpecMap;
import com.linkedin.schema.KafkaSchema;
import com.linkedin.schema.KeyValueSchema;
import com.linkedin.schema.MySqlDDL;
import com.linkedin.schema.OracleDDL;
import com.linkedin.schema.OrcSchema;
import com.linkedin.schema.OtherSchema;
import com.linkedin.schema.PrestoDDL;
import com.linkedin.schema.SchemaFieldArray;
import com.linkedin.schema.Schemaless;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SchemaMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**SchemaMetadata to describe metadata related to store schema*/@Aspect.name=\"schemaMetadata\"record SchemaMetadata includes/**Key to retrieve schema metadata.*/record SchemaMetadataKey{/**Schema name e.g. PageViewEvent, identity.Profile, ams.account_management_tracking*/@validate.strlen={\"max\":500,\"min\":1}schemaName:string/**Standardized platform urn where schema is defined. The data platform Urn (urn:li:platform:{platform_name})*/platform:{namespace com.linkedin.common/**Standardized data platforms available*/@java.class=\"com.linkedin.common.urn.DataPlatformUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data platforms available\",\"entityType\":\"dataPlatform\",\"fields\":[{\"doc\":\"data platform name i.e. hdfs, oracle, espresso\",\"maxLength\":25,\"name\":\"platformName\",\"type\":\"string\"}],\"maxLength\":45,\"name\":\"DataPlatform\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:wherehows\"}typeref DataPlatformUrn=string}/**Every change to SchemaMetadata in the resource results in a new version. Version is server assigned. This version is differ from platform native schema version.*/version:long}{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}{/**Dataset this schema metadata is associated with.*/dataset:optional{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**The cluster this schema metadata resides from*/cluster:optional string/**the SHA1 hash of the schema content*/hash:string/**The native schema in the dataset's platform.*/platformSchema:union[/**Schema text of an espresso table schema.*/record EspressoSchema{/**The native espresso document schema.*/documentSchema:string/**The espresso table schema definition.*/tableSchema:string}/**Schema holder for oracle data definition language that describes an oracle table.*/record OracleDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}/**Schema holder for MySql data definition language that describes an MySql table.*/record MySqlDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}/**Schema holder for presto data definition language that describes a presto view.*/record PrestoDDL{/**The raw schema in the dataset's platform. This includes the DDL and the columns extracted from DDL.*/rawSchema:string}/**Schema holder for kafka schema.*/record KafkaSchema{/**The native kafka document schema. This is a human readable avro document schema.*/documentSchema:string/**The native kafka document schema type. This can be AVRO/PROTOBUF/JSON.*/documentSchemaType:optional string/**The native kafka key schema as retrieved from Schema Registry*/keySchema:optional string/**The native kafka key schema type. This can be AVRO/PROTOBUF/JSON.*/keySchemaType:optional string}/**Schema text of binary JSON schema.*/record BinaryJsonSchema{/**The native schema text for binary JSON file format.*/schema:string}/**Schema text of an ORC schema.*/record OrcSchema{/**The native schema for ORC file format.*/schema:string}/**The dataset has no specific schema associated with it*/record Schemaless{}/**Schema text of a key-value store schema.*/record KeyValueSchema{/**The raw schema for the key in the key-value store.*/keySchema:string/**The raw schema for the value in the key-value store.*/valueSchema:string}/**Schema holder for undefined schema types.*/record OtherSchema{/**The native schema in the dataset's platform.*/rawSchema:string}]/**Client provided a list of fields from document schema.*/fields:array[/**SchemaField to describe metadata related to dataset schema.*/record SchemaField{/**Flattened name of the field. Field is computed from jsonPath field.*/@Searchable={\"boostScore\":1.0,\"fieldName\":\"fieldPaths\",\"fieldType\":\"TEXT\",\"queryByDefault\":\"true\"}fieldPath:{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}/**Flattened name of a field in JSON Path notation.*/@Deprecated,jsonPath:optional string/**Indicates if this field is optional or nullable*/nullable:boolean=false/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"fieldDescriptions\",\"fieldType\":\"TEXT\"}description:optional string/**Label of the field. Provides a more human-readable name for the field than field path. Some sources will\nprovide this metadata but not all sources have the concept of a label. If just one string is associated with\na field in a source, that is most likely a description.\n\nNote that this field is deprecated and is not surfaced in the UI.*/@Deprecated@Searchable={\"boostScore\":0.2,\"fieldName\":\"fieldLabels\",\"fieldType\":\"TEXT\"}label:optional string/**An AuditStamp corresponding to the creation of this schema field.*/created:optional com.linkedin.common.AuditStamp/**An AuditStamp corresponding to the last modification of this schema field.*/lastModified:optional com.linkedin.common.AuditStamp/**Platform independent field type of the field.*/type:/**Schema field data types*/record SchemaFieldDataType{/**Data platform specific types*/type:union[/**Boolean field type.*/record BooleanType{}/**Fixed field type.*/record FixedType{}/**String field type.*/record StringType{}/**Bytes field type.*/record BytesType{}/**Number data type: long, integer, short, etc..*/record NumberType{}/**Date field type.*/record DateType{}/**Time field type. This should also be used for datetimes.*/record TimeType{}/**Enum field type.*/record EnumType{}/**Null field type.*/record NullType{}/**Map field type.*/record MapType{/**Key type in a map*/keyType:optional string/**Type of the value in a map*/valueType:optional string}/**Array field type.*/record ArrayType{/**List of types this array holds.*/nestedType:optional array[string]}/**Union field type.*/record UnionType{/**List of types in union type.*/nestedTypes:optional array[string]}/**Record field type.*/record RecordType{}]}/**The native type of the field in the dataset's platform as declared by platform schema.*/nativeDataType:string/**There are use cases when a field in type B references type A. A field in A references field of type B. In such cases, we will mark the first field as recursive.*/recursive:boolean=false/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"SchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"fieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"fieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"fieldTagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"fieldTags\",\"fieldType\":\"URN\"}}globalTags:optional{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tagged With\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true,\"searchTier\":2}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"SchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"fieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"fieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"fieldTermAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"fieldGlossaryTerms\",\"fieldType\":\"URN\"}}glossaryTerms:optional{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:AuditStamp}}/**For schema fields that are part of complex keys, set this field to true\nWe do this to easily distinguish between value and key fields*/isPartOfKey:boolean=false/**For Datasets which are partitioned, this determines the partitioning key.\nNote that multiple columns can be part of a partitioning key, but currently we do not support\nrendering the ordered partitioning key.*/isPartitioningKey:optional boolean/**For schema fields that have other properties that are not modeled explicitly,\nuse this field to serialize those properties into a JSON string*/jsonProps:optional string}]/**Client provided list of fields that define primary keys to access record. Field order defines hierarchical espresso keys. Empty lists indicates absence of primary key access patter. Value is a SchemaField@fieldPath.*/primaryKeys:optional array[com.linkedin.dataset.SchemaFieldPath]/**Map captures all the references schema makes to external datasets. Map key is ForeignKeySpecName typeref.*/@deprecated=\"Use foreignKeys instead.\"foreignKeysSpecs:optional map[string/**Description of a foreign key in a schema.*/record ForeignKeySpec{/**Foreign key definition in metadata schema.*/foreignKey:union[/**For non-urn based foregin keys.*/record DatasetFieldForeignKey{/**dataset that stores the resource.*/parentDataset:com.linkedin.common.DatasetUrn/**List of fields in hosting(current) SchemaMetadata that conform a foreign key. List can contain a single entry or multiple entries if several entries in hosting schema conform a foreign key in a single parent dataset.*/currentFieldPaths:array[com.linkedin.dataset.SchemaFieldPath]/**SchemaField@fieldPath that uniquely identify field in parent dataset that this field references.*/parentField:com.linkedin.dataset.SchemaFieldPath}/**If SchemaMetadata fields make any external references and references are of type com.linkedin.common.Urn or any children, this models can be used to mark it.*/record UrnForeignKey{/**Field in hosting(current) SchemaMetadata.*/currentFieldPath:com.linkedin.dataset.SchemaFieldPath}]}]/**List of foreign key constraints for the schema*/foreignKeys:optional array[/**Description of a foreign key constraint in a schema.*/record ForeignKeyConstraint{/**Name of the constraint, likely provided from the source*/name:string/**Fields the constraint maps to on the foreign dataset*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"ForeignKeyTo\"}foreignFields:array[com.linkedin.common.Urn]/**Fields the constraint maps to on the source dataset*/sourceFields:array[com.linkedin.common.Urn]/**Reference to the foreign dataset for ease of lookup*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ForeignKeyToDataset\"}foreignDataset:com.linkedin.common.Urn}]}", SchemaFormatType.PDL);
    private String _schemaNameField = null;
    private DataPlatformUrn _platformField = null;
    private Long _versionField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private AuditStamp _deletedField = null;
    private DatasetUrn _datasetField = null;
    private String _clusterField = null;
    private String _hashField = null;
    private PlatformSchema _platformSchemaField = null;
    private SchemaFieldArray _fieldsField = null;
    private StringArray _primaryKeysField = null;
    private ForeignKeySpecMap _foreignKeysSpecsField = null;
    private ForeignKeyConstraintArray _foreignKeysField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SchemaName = SCHEMA.getField("schemaName");
    private static final RecordDataSchema.Field FIELD_Platform = SCHEMA.getField("platform");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final AuditStamp DEFAULT_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final AuditStamp DEFAULT_LastModified;
    private static final RecordDataSchema.Field FIELD_Deleted;
    private static final RecordDataSchema.Field FIELD_Dataset;
    private static final RecordDataSchema.Field FIELD_Cluster;
    private static final RecordDataSchema.Field FIELD_Hash;
    private static final RecordDataSchema.Field FIELD_PlatformSchema;
    private static final RecordDataSchema.Field FIELD_Fields;
    private static final RecordDataSchema.Field FIELD_PrimaryKeys;
    private static final RecordDataSchema.Field FIELD_ForeignKeysSpecs;
    private static final RecordDataSchema.Field FIELD_ForeignKeys;

    public SchemaMetadata() {
        super(new DataMap(), SCHEMA, 11);
        this.addChangeListener(this.__changeListener);
    }

    public SchemaMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSchemaName() {
        if (this._schemaNameField != null) {
            return true;
        }
        return this._map.containsKey("schemaName");
    }

    public void removeSchemaName() {
        this._map.remove("schemaName");
    }

    @Nullable
    public String getSchemaName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSchemaName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._schemaNameField != null) {
                    return this._schemaNameField;
                }
                Object __rawValue = this._map.get("schemaName");
                this._schemaNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._schemaNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSchemaName() {
        if (this._schemaNameField != null) {
            return this._schemaNameField;
        }
        Object __rawValue = this._map.get("schemaName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("schemaName");
        }
        this._schemaNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._schemaNameField;
    }

    public SchemaMetadata setSchemaName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchemaName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field schemaName of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
                this._schemaNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchemaName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
                this._schemaNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
                this._schemaNameField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setSchemaName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schemaName of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
        this._schemaNameField = value;
        return this;
    }

    public boolean hasPlatform() {
        if (this._platformField != null) {
            return true;
        }
        return this._map.containsKey("platform");
    }

    public void removePlatform() {
        this._map.remove("platform");
    }

    @Nullable
    public DataPlatformUrn getPlatform(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPlatform();
            }
            case DEFAULT: 
            case NULL: {
                if (this._platformField != null) {
                    return this._platformField;
                }
                Object __rawValue = this._map.get("platform");
                this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataPlatformUrn.class);
                return this._platformField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataPlatformUrn getPlatform() {
        if (this._platformField != null) {
            return this._platformField;
        }
        Object __rawValue = this._map.get("platform");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("platform");
        }
        this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataPlatformUrn.class);
        return this._platformField;
    }

    public SchemaMetadata setPlatform(@Nullable DataPlatformUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatform(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field platform of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._platformField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatform();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._platformField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._platformField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setPlatform(@Nonnull DataPlatformUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platform of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
        this._platformField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public Long getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._versionField;
    }

    public SchemaMetadata setVersion(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setVersion(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public SchemaMetadata setVersion(long value) {
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCreated();
            }
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            return DEFAULT_Created;
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public SchemaMetadata setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getLastModified();
            }
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            return DEFAULT_LastModified;
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public SchemaMetadata setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasDeleted() {
        if (this._deletedField != null) {
            return true;
        }
        return this._map.containsKey("deleted");
    }

    public void removeDeleted() {
        this._map.remove("deleted");
    }

    @Nullable
    public AuditStamp getDeleted(GetMode mode) {
        return this.getDeleted();
    }

    @Nullable
    public AuditStamp getDeleted() {
        if (this._deletedField != null) {
            return this._deletedField;
        }
        Object __rawValue = this._map.get("deleted");
        this._deletedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._deletedField;
    }

    public SchemaMetadata setDeleted(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDeleted(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDeleted();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
                this._deletedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
                this._deletedField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setDeleted(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field deleted of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "deleted", value.data());
        this._deletedField = value;
        return this;
    }

    public boolean hasDataset() {
        if (this._datasetField != null) {
            return true;
        }
        return this._map.containsKey("dataset");
    }

    public void removeDataset() {
        this._map.remove("dataset");
    }

    @Nullable
    public DatasetUrn getDataset(GetMode mode) {
        return this.getDataset();
    }

    @Nullable
    public DatasetUrn getDataset() {
        if (this._datasetField != null) {
            return this._datasetField;
        }
        Object __rawValue = this._map.get("dataset");
        this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
        return this._datasetField;
    }

    public SchemaMetadata setDataset(@Nullable DatasetUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setDataset(@Nonnull DatasetUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataset of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
        this._datasetField = value;
        return this;
    }

    public boolean hasCluster() {
        if (this._clusterField != null) {
            return true;
        }
        return this._map.containsKey("cluster");
    }

    public void removeCluster() {
        this._map.remove("cluster");
    }

    @Nullable
    public String getCluster(GetMode mode) {
        return this.getCluster();
    }

    @Nullable
    public String getCluster() {
        if (this._clusterField != null) {
            return this._clusterField;
        }
        Object __rawValue = this._map.get("cluster");
        this._clusterField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._clusterField;
    }

    public SchemaMetadata setCluster(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCluster(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCluster();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cluster", value);
                this._clusterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cluster", value);
                this._clusterField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setCluster(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cluster of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cluster", value);
        this._clusterField = value;
        return this;
    }

    public boolean hasHash() {
        if (this._hashField != null) {
            return true;
        }
        return this._map.containsKey("hash");
    }

    public void removeHash() {
        this._map.remove("hash");
    }

    @Nullable
    public String getHash(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getHash();
            }
            case DEFAULT: 
            case NULL: {
                if (this._hashField != null) {
                    return this._hashField;
                }
                Object __rawValue = this._map.get("hash");
                this._hashField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._hashField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getHash() {
        if (this._hashField != null) {
            return this._hashField;
        }
        Object __rawValue = this._map.get("hash");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("hash");
        }
        this._hashField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._hashField;
    }

    public SchemaMetadata setHash(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHash(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field hash of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "hash", value);
                this._hashField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHash();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hash", value);
                this._hashField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hash", value);
                this._hashField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setHash(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hash of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hash", value);
        this._hashField = value;
        return this;
    }

    public boolean hasPlatformSchema() {
        if (this._platformSchemaField != null) {
            return true;
        }
        return this._map.containsKey("platformSchema");
    }

    public void removePlatformSchema() {
        this._map.remove("platformSchema");
    }

    @Nullable
    public PlatformSchema getPlatformSchema(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPlatformSchema();
            }
            case DEFAULT: 
            case NULL: {
                if (this._platformSchemaField != null) {
                    return this._platformSchemaField;
                }
                Object __rawValue = this._map.get("platformSchema");
                this._platformSchemaField = __rawValue == null ? null : new PlatformSchema(__rawValue);
                return this._platformSchemaField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PlatformSchema getPlatformSchema() {
        if (this._platformSchemaField != null) {
            return this._platformSchemaField;
        }
        Object __rawValue = this._map.get("platformSchema");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("platformSchema");
        }
        this._platformSchemaField = __rawValue == null ? null : new PlatformSchema(__rawValue);
        return this._platformSchemaField;
    }

    public SchemaMetadata setPlatformSchema(@Nullable PlatformSchema value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatformSchema(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field platformSchema of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "platformSchema", value.data());
                this._platformSchemaField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatformSchema();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platformSchema", value.data());
                this._platformSchemaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platformSchema", value.data());
                this._platformSchemaField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setPlatformSchema(@Nonnull PlatformSchema value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platformSchema of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platformSchema", value.data());
        this._platformSchemaField = value;
        return this;
    }

    public boolean hasFields() {
        if (this._fieldsField != null) {
            return true;
        }
        return this._map.containsKey("fields");
    }

    public void removeFields() {
        this._map.remove("fields");
    }

    @Nullable
    public SchemaFieldArray getFields(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFields();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldsField != null) {
                    return this._fieldsField;
                }
                Object __rawValue = this._map.get("fields");
                this._fieldsField = __rawValue == null ? null : new SchemaFieldArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._fieldsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SchemaFieldArray getFields() {
        if (this._fieldsField != null) {
            return this._fieldsField;
        }
        Object __rawValue = this._map.get("fields");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("fields");
        }
        this._fieldsField = __rawValue == null ? null : new SchemaFieldArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fieldsField;
    }

    public SchemaMetadata setFields(@Nullable SchemaFieldArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field fields of com.linkedin.schema.SchemaMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setFields(@Nonnull SchemaFieldArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fields of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
        this._fieldsField = value;
        return this;
    }

    public boolean hasPrimaryKeys() {
        if (this._primaryKeysField != null) {
            return true;
        }
        return this._map.containsKey("primaryKeys");
    }

    public void removePrimaryKeys() {
        this._map.remove("primaryKeys");
    }

    @Nullable
    public StringArray getPrimaryKeys(GetMode mode) {
        return this.getPrimaryKeys();
    }

    @Nullable
    public StringArray getPrimaryKeys() {
        if (this._primaryKeysField != null) {
            return this._primaryKeysField;
        }
        Object __rawValue = this._map.get("primaryKeys");
        this._primaryKeysField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._primaryKeysField;
    }

    public SchemaMetadata setPrimaryKeys(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrimaryKeys(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrimaryKeys();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "primaryKeys", value.data());
                this._primaryKeysField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "primaryKeys", value.data());
                this._primaryKeysField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setPrimaryKeys(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field primaryKeys of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "primaryKeys", value.data());
        this._primaryKeysField = value;
        return this;
    }

    @Deprecated
    public boolean hasForeignKeysSpecs() {
        if (this._foreignKeysSpecsField != null) {
            return true;
        }
        return this._map.containsKey("foreignKeysSpecs");
    }

    @Deprecated
    public void removeForeignKeysSpecs() {
        this._map.remove("foreignKeysSpecs");
    }

    @Deprecated
    @Nullable
    public ForeignKeySpecMap getForeignKeysSpecs(GetMode mode) {
        return this.getForeignKeysSpecs();
    }

    @Deprecated
    @Nullable
    public ForeignKeySpecMap getForeignKeysSpecs() {
        if (this._foreignKeysSpecsField != null) {
            return this._foreignKeysSpecsField;
        }
        Object __rawValue = this._map.get("foreignKeysSpecs");
        this._foreignKeysSpecsField = __rawValue == null ? null : new ForeignKeySpecMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._foreignKeysSpecsField;
    }

    @Deprecated
    public SchemaMetadata setForeignKeysSpecs(@Nullable ForeignKeySpecMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setForeignKeysSpecs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeForeignKeysSpecs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignKeysSpecs", value.data());
                this._foreignKeysSpecsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "foreignKeysSpecs", value.data());
                this._foreignKeysSpecsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public SchemaMetadata setForeignKeysSpecs(@Nonnull ForeignKeySpecMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field foreignKeysSpecs of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "foreignKeysSpecs", value.data());
        this._foreignKeysSpecsField = value;
        return this;
    }

    public boolean hasForeignKeys() {
        if (this._foreignKeysField != null) {
            return true;
        }
        return this._map.containsKey("foreignKeys");
    }

    public void removeForeignKeys() {
        this._map.remove("foreignKeys");
    }

    @Nullable
    public ForeignKeyConstraintArray getForeignKeys(GetMode mode) {
        return this.getForeignKeys();
    }

    @Nullable
    public ForeignKeyConstraintArray getForeignKeys() {
        if (this._foreignKeysField != null) {
            return this._foreignKeysField;
        }
        Object __rawValue = this._map.get("foreignKeys");
        this._foreignKeysField = __rawValue == null ? null : new ForeignKeyConstraintArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._foreignKeysField;
    }

    public SchemaMetadata setForeignKeys(@Nullable ForeignKeyConstraintArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setForeignKeys(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeForeignKeys();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignKeys", value.data());
                this._foreignKeysField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "foreignKeys", value.data());
                this._foreignKeysField = value;
            }
        }
        return this;
    }

    public SchemaMetadata setForeignKeys(@Nonnull ForeignKeyConstraintArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field foreignKeys of com.linkedin.schema.SchemaMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "foreignKeys", value.data());
        this._foreignKeysField = value;
        return this;
    }

    @Override
    public SchemaMetadata clone() throws CloneNotSupportedException {
        SchemaMetadata __clone = (SchemaMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SchemaMetadata copy() throws CloneNotSupportedException {
        SchemaMetadata __copy = (SchemaMetadata)super.copy();
        __copy._clusterField = null;
        __copy._foreignKeysField = null;
        __copy._createdField = null;
        __copy._schemaNameField = null;
        __copy._versionField = null;
        __copy._platformField = null;
        __copy._foreignKeysSpecsField = null;
        __copy._deletedField = null;
        __copy._primaryKeysField = null;
        __copy._platformSchemaField = null;
        __copy._lastModifiedField = null;
        __copy._fieldsField = null;
        __copy._datasetField = null;
        __copy._hashField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Deleted = SCHEMA.getField("deleted");
        FIELD_Dataset = SCHEMA.getField("dataset");
        FIELD_Cluster = SCHEMA.getField("cluster");
        FIELD_Hash = SCHEMA.getField("hash");
        FIELD_PlatformSchema = SCHEMA.getField("platformSchema");
        FIELD_Fields = SCHEMA.getField("fields");
        FIELD_PrimaryKeys = SCHEMA.getField("primaryKeys");
        FIELD_ForeignKeysSpecs = SCHEMA.getField("foreignKeysSpecs");
        FIELD_ForeignKeys = SCHEMA.getField("foreignKeys");
        Custom.initializeCustomClass(DataPlatformUrn.class);
        Custom.initializeCustomClass(DatasetUrn.class);
        DEFAULT_Created = FIELD_Created.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_Created.getDefault(), DataMap.class));
        DEFAULT_LastModified = FIELD_LastModified.getDefault() == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(FIELD_LastModified.getDefault(), DataMap.class));
    }

    public static class PlatformSchema
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.schema/**Schema text of an espresso table schema.*/record EspressoSchema{/**The native espresso document schema.*/documentSchema:string/**The espresso table schema definition.*/tableSchema:string}}{namespace com.linkedin.schema/**Schema holder for oracle data definition language that describes an oracle table.*/record OracleDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}}{namespace com.linkedin.schema/**Schema holder for MySql data definition language that describes an MySql table.*/record MySqlDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}}{namespace com.linkedin.schema/**Schema holder for presto data definition language that describes a presto view.*/record PrestoDDL{/**The raw schema in the dataset's platform. This includes the DDL and the columns extracted from DDL.*/rawSchema:string}}{namespace com.linkedin.schema/**Schema holder for kafka schema.*/record KafkaSchema{/**The native kafka document schema. This is a human readable avro document schema.*/documentSchema:string/**The native kafka document schema type. This can be AVRO/PROTOBUF/JSON.*/documentSchemaType:optional string/**The native kafka key schema as retrieved from Schema Registry*/keySchema:optional string/**The native kafka key schema type. This can be AVRO/PROTOBUF/JSON.*/keySchemaType:optional string}}{namespace com.linkedin.schema/**Schema text of binary JSON schema.*/record BinaryJsonSchema{/**The native schema text for binary JSON file format.*/schema:string}}{namespace com.linkedin.schema/**Schema text of an ORC schema.*/record OrcSchema{/**The native schema for ORC file format.*/schema:string}}{namespace com.linkedin.schema/**The dataset has no specific schema associated with it*/record Schemaless{}}{namespace com.linkedin.schema/**Schema text of a key-value store schema.*/record KeyValueSchema{/**The raw schema for the key in the key-value store.*/keySchema:string/**The raw schema for the value in the key-value store.*/valueSchema:string}}{namespace com.linkedin.schema/**Schema holder for undefined schema types.*/record OtherSchema{/**The native schema in the dataset's platform.*/rawSchema:string}}]", SchemaFormatType.PDL);
        private EspressoSchema _espressoSchemaMember = null;
        private OracleDDL _oracleDDLMember = null;
        private MySqlDDL _mySqlDDLMember = null;
        private PrestoDDL _prestoDDLMember = null;
        private KafkaSchema _kafkaSchemaMember = null;
        private BinaryJsonSchema _binaryJsonSchemaMember = null;
        private OrcSchema _orcSchemaMember = null;
        private Schemaless _schemalessMember = null;
        private KeyValueSchema _keyValueSchemaMember = null;
        private OtherSchema _otherSchemaMember = null;
        private ChangeListener __changeListener = new ChangeListener(this);
        private static final DataSchema MEMBER_EspressoSchema = SCHEMA.getTypeByMemberKey("com.linkedin.schema.EspressoSchema");
        public static final String MEMBERKEY_EspressoSchema = "com.linkedin.schema.EspressoSchema";
        private static final DataSchema MEMBER_OracleDDL = SCHEMA.getTypeByMemberKey("com.linkedin.schema.OracleDDL");
        public static final String MEMBERKEY_OracleDDL = "com.linkedin.schema.OracleDDL";
        private static final DataSchema MEMBER_MySqlDDL = SCHEMA.getTypeByMemberKey("com.linkedin.schema.MySqlDDL");
        public static final String MEMBERKEY_MySqlDDL = "com.linkedin.schema.MySqlDDL";
        private static final DataSchema MEMBER_PrestoDDL = SCHEMA.getTypeByMemberKey("com.linkedin.schema.PrestoDDL");
        public static final String MEMBERKEY_PrestoDDL = "com.linkedin.schema.PrestoDDL";
        private static final DataSchema MEMBER_KafkaSchema = SCHEMA.getTypeByMemberKey("com.linkedin.schema.KafkaSchema");
        public static final String MEMBERKEY_KafkaSchema = "com.linkedin.schema.KafkaSchema";
        private static final DataSchema MEMBER_BinaryJsonSchema = SCHEMA.getTypeByMemberKey("com.linkedin.schema.BinaryJsonSchema");
        public static final String MEMBERKEY_BinaryJsonSchema = "com.linkedin.schema.BinaryJsonSchema";
        private static final DataSchema MEMBER_OrcSchema = SCHEMA.getTypeByMemberKey("com.linkedin.schema.OrcSchema");
        public static final String MEMBERKEY_OrcSchema = "com.linkedin.schema.OrcSchema";
        private static final DataSchema MEMBER_Schemaless = SCHEMA.getTypeByMemberKey("com.linkedin.schema.Schemaless");
        public static final String MEMBERKEY_Schemaless = "com.linkedin.schema.Schemaless";
        private static final DataSchema MEMBER_KeyValueSchema = SCHEMA.getTypeByMemberKey("com.linkedin.schema.KeyValueSchema");
        public static final String MEMBERKEY_KeyValueSchema = "com.linkedin.schema.KeyValueSchema";
        private static final DataSchema MEMBER_OtherSchema = SCHEMA.getTypeByMemberKey("com.linkedin.schema.OtherSchema");
        public static final String MEMBERKEY_OtherSchema = "com.linkedin.schema.OtherSchema";

        public PlatformSchema() {
            super(new DataMap(2, 0.75f), SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public PlatformSchema(Object data) {
            super(data, SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public static UnionDataSchema dataSchema() {
            return SCHEMA;
        }

        public static PlatformSchema create(EspressoSchema value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setEspressoSchema(value);
            return newUnion;
        }

        public boolean isEspressoSchema() {
            return this.memberIs(MEMBERKEY_EspressoSchema);
        }

        public EspressoSchema getEspressoSchema() {
            this.checkNotNull();
            if (this._espressoSchemaMember != null) {
                return this._espressoSchemaMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_EspressoSchema);
            this._espressoSchemaMember = __rawValue == null ? null : new EspressoSchema(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._espressoSchemaMember;
        }

        public void setEspressoSchema(EspressoSchema value) {
            this.checkNotNull();
            this._map.clear();
            this._espressoSchemaMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_EspressoSchema, value.data());
        }

        public static PlatformSchema create(OracleDDL value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setOracleDDL(value);
            return newUnion;
        }

        public boolean isOracleDDL() {
            return this.memberIs(MEMBERKEY_OracleDDL);
        }

        public OracleDDL getOracleDDL() {
            this.checkNotNull();
            if (this._oracleDDLMember != null) {
                return this._oracleDDLMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_OracleDDL);
            this._oracleDDLMember = __rawValue == null ? null : new OracleDDL(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._oracleDDLMember;
        }

        public void setOracleDDL(OracleDDL value) {
            this.checkNotNull();
            this._map.clear();
            this._oracleDDLMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_OracleDDL, value.data());
        }

        public static PlatformSchema create(MySqlDDL value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setMySqlDDL(value);
            return newUnion;
        }

        public boolean isMySqlDDL() {
            return this.memberIs(MEMBERKEY_MySqlDDL);
        }

        public MySqlDDL getMySqlDDL() {
            this.checkNotNull();
            if (this._mySqlDDLMember != null) {
                return this._mySqlDDLMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_MySqlDDL);
            this._mySqlDDLMember = __rawValue == null ? null : new MySqlDDL(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._mySqlDDLMember;
        }

        public void setMySqlDDL(MySqlDDL value) {
            this.checkNotNull();
            this._map.clear();
            this._mySqlDDLMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_MySqlDDL, value.data());
        }

        public static PlatformSchema create(PrestoDDL value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setPrestoDDL(value);
            return newUnion;
        }

        public boolean isPrestoDDL() {
            return this.memberIs(MEMBERKEY_PrestoDDL);
        }

        public PrestoDDL getPrestoDDL() {
            this.checkNotNull();
            if (this._prestoDDLMember != null) {
                return this._prestoDDLMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_PrestoDDL);
            this._prestoDDLMember = __rawValue == null ? null : new PrestoDDL(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._prestoDDLMember;
        }

        public void setPrestoDDL(PrestoDDL value) {
            this.checkNotNull();
            this._map.clear();
            this._prestoDDLMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_PrestoDDL, value.data());
        }

        public static PlatformSchema create(KafkaSchema value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setKafkaSchema(value);
            return newUnion;
        }

        public boolean isKafkaSchema() {
            return this.memberIs(MEMBERKEY_KafkaSchema);
        }

        public KafkaSchema getKafkaSchema() {
            this.checkNotNull();
            if (this._kafkaSchemaMember != null) {
                return this._kafkaSchemaMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_KafkaSchema);
            this._kafkaSchemaMember = __rawValue == null ? null : new KafkaSchema(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._kafkaSchemaMember;
        }

        public void setKafkaSchema(KafkaSchema value) {
            this.checkNotNull();
            this._map.clear();
            this._kafkaSchemaMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_KafkaSchema, value.data());
        }

        public static PlatformSchema create(BinaryJsonSchema value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setBinaryJsonSchema(value);
            return newUnion;
        }

        public boolean isBinaryJsonSchema() {
            return this.memberIs(MEMBERKEY_BinaryJsonSchema);
        }

        public BinaryJsonSchema getBinaryJsonSchema() {
            this.checkNotNull();
            if (this._binaryJsonSchemaMember != null) {
                return this._binaryJsonSchemaMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_BinaryJsonSchema);
            this._binaryJsonSchemaMember = __rawValue == null ? null : new BinaryJsonSchema(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._binaryJsonSchemaMember;
        }

        public void setBinaryJsonSchema(BinaryJsonSchema value) {
            this.checkNotNull();
            this._map.clear();
            this._binaryJsonSchemaMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_BinaryJsonSchema, value.data());
        }

        public static PlatformSchema create(OrcSchema value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setOrcSchema(value);
            return newUnion;
        }

        public boolean isOrcSchema() {
            return this.memberIs(MEMBERKEY_OrcSchema);
        }

        public OrcSchema getOrcSchema() {
            this.checkNotNull();
            if (this._orcSchemaMember != null) {
                return this._orcSchemaMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_OrcSchema);
            this._orcSchemaMember = __rawValue == null ? null : new OrcSchema(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._orcSchemaMember;
        }

        public void setOrcSchema(OrcSchema value) {
            this.checkNotNull();
            this._map.clear();
            this._orcSchemaMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_OrcSchema, value.data());
        }

        public static PlatformSchema create(Schemaless value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setSchemaless(value);
            return newUnion;
        }

        public boolean isSchemaless() {
            return this.memberIs(MEMBERKEY_Schemaless);
        }

        public Schemaless getSchemaless() {
            this.checkNotNull();
            if (this._schemalessMember != null) {
                return this._schemalessMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_Schemaless);
            this._schemalessMember = __rawValue == null ? null : new Schemaless(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._schemalessMember;
        }

        public void setSchemaless(Schemaless value) {
            this.checkNotNull();
            this._map.clear();
            this._schemalessMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Schemaless, value.data());
        }

        public static PlatformSchema create(KeyValueSchema value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setKeyValueSchema(value);
            return newUnion;
        }

        public boolean isKeyValueSchema() {
            return this.memberIs(MEMBERKEY_KeyValueSchema);
        }

        public KeyValueSchema getKeyValueSchema() {
            this.checkNotNull();
            if (this._keyValueSchemaMember != null) {
                return this._keyValueSchemaMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_KeyValueSchema);
            this._keyValueSchemaMember = __rawValue == null ? null : new KeyValueSchema(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._keyValueSchemaMember;
        }

        public void setKeyValueSchema(KeyValueSchema value) {
            this.checkNotNull();
            this._map.clear();
            this._keyValueSchemaMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_KeyValueSchema, value.data());
        }

        public static PlatformSchema create(OtherSchema value) {
            PlatformSchema newUnion = new PlatformSchema();
            newUnion.setOtherSchema(value);
            return newUnion;
        }

        public boolean isOtherSchema() {
            return this.memberIs(MEMBERKEY_OtherSchema);
        }

        public OtherSchema getOtherSchema() {
            this.checkNotNull();
            if (this._otherSchemaMember != null) {
                return this._otherSchemaMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_OtherSchema);
            this._otherSchemaMember = __rawValue == null ? null : new OtherSchema(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._otherSchemaMember;
        }

        public void setOtherSchema(OtherSchema value) {
            this.checkNotNull();
            this._map.clear();
            this._otherSchemaMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_OtherSchema, value.data());
        }

        public static ProjectionMask createMask() {
            return new ProjectionMask();
        }

        @Override
        public PlatformSchema clone() throws CloneNotSupportedException {
            PlatformSchema __clone = (PlatformSchema)super.clone();
            __clone.__changeListener = new ChangeListener(__clone);
            __clone.addChangeListener(__clone.__changeListener);
            return __clone;
        }

        @Override
        public PlatformSchema copy() throws CloneNotSupportedException {
            PlatformSchema __copy = (PlatformSchema)super.copy();
            __copy._oracleDDLMember = null;
            __copy._kafkaSchemaMember = null;
            __copy._binaryJsonSchemaMember = null;
            __copy._orcSchemaMember = null;
            __copy._mySqlDDLMember = null;
            __copy._prestoDDLMember = null;
            __copy._espressoSchemaMember = null;
            __copy._otherSchemaMember = null;
            __copy._schemalessMember = null;
            __copy._keyValueSchemaMember = null;
            __copy.__changeListener = new ChangeListener(__copy);
            __copy.addChangeListener(__copy.__changeListener);
            return __copy;
        }

        private static class ChangeListener
        implements CheckedMap.ChangeListener<String, Object> {
            private final PlatformSchema __objectRef;

            private ChangeListener(PlatformSchema reference) {
                this.__objectRef = reference;
            }

            @Override
            public void onUnderlyingMapChanged(String key, Object value) {
                switch (key) {
                    case "com.linkedin.schema.OracleDDL": {
                        this.__objectRef._oracleDDLMember = null;
                        break;
                    }
                    case "com.linkedin.schema.KafkaSchema": {
                        this.__objectRef._kafkaSchemaMember = null;
                        break;
                    }
                    case "com.linkedin.schema.BinaryJsonSchema": {
                        this.__objectRef._binaryJsonSchemaMember = null;
                        break;
                    }
                    case "com.linkedin.schema.OrcSchema": {
                        this.__objectRef._orcSchemaMember = null;
                        break;
                    }
                    case "com.linkedin.schema.MySqlDDL": {
                        this.__objectRef._mySqlDDLMember = null;
                        break;
                    }
                    case "com.linkedin.schema.PrestoDDL": {
                        this.__objectRef._prestoDDLMember = null;
                        break;
                    }
                    case "com.linkedin.schema.EspressoSchema": {
                        this.__objectRef._espressoSchemaMember = null;
                        break;
                    }
                    case "com.linkedin.schema.OtherSchema": {
                        this.__objectRef._otherSchemaMember = null;
                        break;
                    }
                    case "com.linkedin.schema.Schemaless": {
                        this.__objectRef._schemalessMember = null;
                        break;
                    }
                    case "com.linkedin.schema.KeyValueSchema": {
                        this.__objectRef._keyValueSchemaMember = null;
                    }
                }
            }
        }

        public static class ProjectionMask
        extends MaskMap {
            private EspressoSchema.ProjectionMask _EspressoSchemaMask;
            private OracleDDL.ProjectionMask _OracleDDLMask;
            private MySqlDDL.ProjectionMask _MySqlDDLMask;
            private PrestoDDL.ProjectionMask _PrestoDDLMask;
            private KafkaSchema.ProjectionMask _KafkaSchemaMask;
            private BinaryJsonSchema.ProjectionMask _BinaryJsonSchemaMask;
            private OrcSchema.ProjectionMask _OrcSchemaMask;
            private Schemaless.ProjectionMask _SchemalessMask;
            private KeyValueSchema.ProjectionMask _KeyValueSchemaMask;
            private OtherSchema.ProjectionMask _OtherSchemaMask;

            ProjectionMask() {
                super(14);
            }

            public ProjectionMask withEspressoSchema(Function<EspressoSchema.ProjectionMask, EspressoSchema.ProjectionMask> nestedMask) {
                this._EspressoSchemaMask = nestedMask.apply(this._EspressoSchemaMask == null ? EspressoSchema.createMask() : this._EspressoSchemaMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_EspressoSchema, this._EspressoSchemaMask.getDataMap());
                return this;
            }

            public ProjectionMask withOracleDDL(Function<OracleDDL.ProjectionMask, OracleDDL.ProjectionMask> nestedMask) {
                this._OracleDDLMask = nestedMask.apply(this._OracleDDLMask == null ? OracleDDL.createMask() : this._OracleDDLMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_OracleDDL, this._OracleDDLMask.getDataMap());
                return this;
            }

            public ProjectionMask withMySqlDDL(Function<MySqlDDL.ProjectionMask, MySqlDDL.ProjectionMask> nestedMask) {
                this._MySqlDDLMask = nestedMask.apply(this._MySqlDDLMask == null ? MySqlDDL.createMask() : this._MySqlDDLMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_MySqlDDL, this._MySqlDDLMask.getDataMap());
                return this;
            }

            public ProjectionMask withPrestoDDL(Function<PrestoDDL.ProjectionMask, PrestoDDL.ProjectionMask> nestedMask) {
                this._PrestoDDLMask = nestedMask.apply(this._PrestoDDLMask == null ? PrestoDDL.createMask() : this._PrestoDDLMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_PrestoDDL, this._PrestoDDLMask.getDataMap());
                return this;
            }

            public ProjectionMask withKafkaSchema(Function<KafkaSchema.ProjectionMask, KafkaSchema.ProjectionMask> nestedMask) {
                this._KafkaSchemaMask = nestedMask.apply(this._KafkaSchemaMask == null ? KafkaSchema.createMask() : this._KafkaSchemaMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_KafkaSchema, this._KafkaSchemaMask.getDataMap());
                return this;
            }

            public ProjectionMask withBinaryJsonSchema(Function<BinaryJsonSchema.ProjectionMask, BinaryJsonSchema.ProjectionMask> nestedMask) {
                this._BinaryJsonSchemaMask = nestedMask.apply(this._BinaryJsonSchemaMask == null ? BinaryJsonSchema.createMask() : this._BinaryJsonSchemaMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_BinaryJsonSchema, this._BinaryJsonSchemaMask.getDataMap());
                return this;
            }

            public ProjectionMask withOrcSchema(Function<OrcSchema.ProjectionMask, OrcSchema.ProjectionMask> nestedMask) {
                this._OrcSchemaMask = nestedMask.apply(this._OrcSchemaMask == null ? OrcSchema.createMask() : this._OrcSchemaMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_OrcSchema, this._OrcSchemaMask.getDataMap());
                return this;
            }

            public ProjectionMask withSchemaless(Function<Schemaless.ProjectionMask, Schemaless.ProjectionMask> nestedMask) {
                this._SchemalessMask = nestedMask.apply(this._SchemalessMask == null ? Schemaless.createMask() : this._SchemalessMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_Schemaless, this._SchemalessMask.getDataMap());
                return this;
            }

            public ProjectionMask withKeyValueSchema(Function<KeyValueSchema.ProjectionMask, KeyValueSchema.ProjectionMask> nestedMask) {
                this._KeyValueSchemaMask = nestedMask.apply(this._KeyValueSchemaMask == null ? KeyValueSchema.createMask() : this._KeyValueSchemaMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_KeyValueSchema, this._KeyValueSchemaMask.getDataMap());
                return this;
            }

            public ProjectionMask withOtherSchema(Function<OtherSchema.ProjectionMask, OtherSchema.ProjectionMask> nestedMask) {
                this._OtherSchemaMask = nestedMask.apply(this._OtherSchemaMask == null ? OtherSchema.createMask() : this._OtherSchemaMask);
                this.getDataMap().put(PlatformSchema.MEMBERKEY_OtherSchema, this._OtherSchemaMask.getDataMap());
                return this;
            }
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public EspressoSchema.Fields EspressoSchema() {
                return new EspressoSchema.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_EspressoSchema);
            }

            public OracleDDL.Fields OracleDDL() {
                return new OracleDDL.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_OracleDDL);
            }

            public MySqlDDL.Fields MySqlDDL() {
                return new MySqlDDL.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_MySqlDDL);
            }

            public PrestoDDL.Fields PrestoDDL() {
                return new PrestoDDL.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_PrestoDDL);
            }

            public KafkaSchema.Fields KafkaSchema() {
                return new KafkaSchema.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_KafkaSchema);
            }

            public BinaryJsonSchema.Fields BinaryJsonSchema() {
                return new BinaryJsonSchema.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_BinaryJsonSchema);
            }

            public OrcSchema.Fields OrcSchema() {
                return new OrcSchema.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_OrcSchema);
            }

            public Schemaless.Fields Schemaless() {
                return new Schemaless.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_Schemaless);
            }

            public KeyValueSchema.Fields KeyValueSchema() {
                return new KeyValueSchema.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_KeyValueSchema);
            }

            public OtherSchema.Fields OtherSchema() {
                return new OtherSchema.Fields(this.getPathComponents(), PlatformSchema.MEMBERKEY_OtherSchema);
            }
        }
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SchemaMetadata __objectRef;

        private ChangeListener(SchemaMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "cluster": {
                    this.__objectRef._clusterField = null;
                    break;
                }
                case "foreignKeys": {
                    this.__objectRef._foreignKeysField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "schemaName": {
                    this.__objectRef._schemaNameField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "platform": {
                    this.__objectRef._platformField = null;
                    break;
                }
                case "foreignKeysSpecs": {
                    this.__objectRef._foreignKeysSpecsField = null;
                    break;
                }
                case "deleted": {
                    this.__objectRef._deletedField = null;
                    break;
                }
                case "primaryKeys": {
                    this.__objectRef._primaryKeysField = null;
                    break;
                }
                case "platformSchema": {
                    this.__objectRef._platformSchemaField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "fields": {
                    this.__objectRef._fieldsField = null;
                    break;
                }
                case "dataset": {
                    this.__objectRef._datasetField = null;
                    break;
                }
                case "hash": {
                    this.__objectRef._hashField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec schemaName() {
            return new PathSpec(this.getPathComponents(), "schemaName");
        }

        public PathSpec platform() {
            return new PathSpec(this.getPathComponents(), "platform");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public AuditStamp.Fields deleted() {
            return new AuditStamp.Fields(this.getPathComponents(), "deleted");
        }

        public PathSpec dataset() {
            return new PathSpec(this.getPathComponents(), "dataset");
        }

        public PathSpec cluster() {
            return new PathSpec(this.getPathComponents(), "cluster");
        }

        public PathSpec hash() {
            return new PathSpec(this.getPathComponents(), "hash");
        }

        public PlatformSchema.Fields platformSchema() {
            return new PlatformSchema.Fields(this.getPathComponents(), "platformSchema");
        }

        public SchemaFieldArray.Fields fields() {
            return new SchemaFieldArray.Fields(this.getPathComponents(), "fields");
        }

        public PathSpec fields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec primaryKeys() {
            return new PathSpec(this.getPathComponents(), "primaryKeys");
        }

        public PathSpec primaryKeys(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "primaryKeys");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public ForeignKeySpecMap.Fields foreignKeysSpecs() {
            return new ForeignKeySpecMap.Fields(this.getPathComponents(), "foreignKeysSpecs");
        }

        public ForeignKeyConstraintArray.Fields foreignKeys() {
            return new ForeignKeyConstraintArray.Fields(this.getPathComponents(), "foreignKeys");
        }

        public PathSpec foreignKeys(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "foreignKeys");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;
        private AuditStamp.ProjectionMask _deletedMask;
        private PlatformSchema.ProjectionMask _platformSchemaMask;
        private SchemaFieldArray.ProjectionMask _fieldsMask;
        private ForeignKeySpecMap.ProjectionMask _foreignKeysSpecsMask;
        private ForeignKeyConstraintArray.ProjectionMask _foreignKeysMask;

        ProjectionMask() {
        }

        public ProjectionMask withSchemaName() {
            this.getDataMap().put("schemaName", 1);
            return this;
        }

        public ProjectionMask withPlatform() {
            this.getDataMap().put("platform", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withDeleted(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._deletedMask = nestedMask.apply(this._deletedMask == null ? AuditStamp.createMask() : this._deletedMask);
            this.getDataMap().put("deleted", this._deletedMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeleted(MaskMap nestedMask) {
            this.getDataMap().put("deleted", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withDeleted() {
            this._deletedMask = null;
            this.getDataMap().put("deleted", 1);
            return this;
        }

        public ProjectionMask withDataset() {
            this.getDataMap().put("dataset", 1);
            return this;
        }

        public ProjectionMask withCluster() {
            this.getDataMap().put("cluster", 1);
            return this;
        }

        public ProjectionMask withHash() {
            this.getDataMap().put("hash", 1);
            return this;
        }

        public ProjectionMask withPlatformSchema(Function<PlatformSchema.ProjectionMask, PlatformSchema.ProjectionMask> nestedMask) {
            this._platformSchemaMask = nestedMask.apply(this._platformSchemaMask == null ? PlatformSchema.createMask() : this._platformSchemaMask);
            this.getDataMap().put("platformSchema", this._platformSchemaMask.getDataMap());
            return this;
        }

        public ProjectionMask withPlatformSchema() {
            this._platformSchemaMask = null;
            this.getDataMap().put("platformSchema", 1);
            return this;
        }

        public ProjectionMask withFields(Function<SchemaFieldArray.ProjectionMask, SchemaFieldArray.ProjectionMask> nestedMask) {
            this._fieldsMask = nestedMask.apply(this._fieldsMask == null ? SchemaFieldArray.createMask() : this._fieldsMask);
            this.getDataMap().put("fields", this._fieldsMask.getDataMap());
            return this;
        }

        public ProjectionMask withFields() {
            this._fieldsMask = null;
            this.getDataMap().put("fields", 1);
            return this;
        }

        public ProjectionMask withFields(Function<SchemaFieldArray.ProjectionMask, SchemaFieldArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._fieldsMask = nestedMask.apply(this._fieldsMask == null ? SchemaFieldArray.createMask() : this._fieldsMask);
            this.getDataMap().put("fields", this._fieldsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("fields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFields(Integer start, Integer count) {
            this._fieldsMask = null;
            this.getDataMap().put("fields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPrimaryKeys() {
            this.getDataMap().put("primaryKeys", 1);
            return this;
        }

        public ProjectionMask withPrimaryKeys(Integer start, Integer count) {
            this.getDataMap().put("primaryKeys", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("primaryKeys").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("primaryKeys").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withForeignKeysSpecs(Function<ForeignKeySpecMap.ProjectionMask, ForeignKeySpecMap.ProjectionMask> nestedMask) {
            this._foreignKeysSpecsMask = nestedMask.apply(this._foreignKeysSpecsMask == null ? ForeignKeySpecMap.createMask() : this._foreignKeysSpecsMask);
            this.getDataMap().put("foreignKeysSpecs", this._foreignKeysSpecsMask.getDataMap());
            return this;
        }

        @Deprecated
        public ProjectionMask withForeignKeysSpecs() {
            this._foreignKeysSpecsMask = null;
            this.getDataMap().put("foreignKeysSpecs", 1);
            return this;
        }

        public ProjectionMask withForeignKeys(Function<ForeignKeyConstraintArray.ProjectionMask, ForeignKeyConstraintArray.ProjectionMask> nestedMask) {
            this._foreignKeysMask = nestedMask.apply(this._foreignKeysMask == null ? ForeignKeyConstraintArray.createMask() : this._foreignKeysMask);
            this.getDataMap().put("foreignKeys", this._foreignKeysMask.getDataMap());
            return this;
        }

        public ProjectionMask withForeignKeys() {
            this._foreignKeysMask = null;
            this.getDataMap().put("foreignKeys", 1);
            return this;
        }

        public ProjectionMask withForeignKeys(Function<ForeignKeyConstraintArray.ProjectionMask, ForeignKeyConstraintArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._foreignKeysMask = nestedMask.apply(this._foreignKeysMask == null ? ForeignKeyConstraintArray.createMask() : this._foreignKeysMask);
            this.getDataMap().put("foreignKeys", this._foreignKeysMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("foreignKeys").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("foreignKeys").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withForeignKeys(Integer start, Integer count) {
            this._foreignKeysMask = null;
            this.getDataMap().put("foreignKeys", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("foreignKeys").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("foreignKeys").put("$count", count);
            }
            return this;
        }
    }
}

