/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseData
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**BaseData record*/record BaseData{/**What dataset were used in the MLModel?*/dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**Why was this dataset chosen?*/motivation:optional string/**How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?*/preProcessing:optional array[string]}", SchemaFormatType.PDL);
    private DatasetUrn _datasetField = null;
    private String _motivationField = null;
    private StringArray _preProcessingField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Dataset = SCHEMA.getField("dataset");
    private static final RecordDataSchema.Field FIELD_Motivation = SCHEMA.getField("motivation");
    private static final RecordDataSchema.Field FIELD_PreProcessing = SCHEMA.getField("preProcessing");

    public BaseData() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public BaseData(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDataset() {
        if (this._datasetField != null) {
            return true;
        }
        return this._map.containsKey("dataset");
    }

    public void removeDataset() {
        this._map.remove("dataset");
    }

    @Nullable
    public DatasetUrn getDataset(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDataset();
            }
            case DEFAULT: 
            case NULL: {
                if (this._datasetField != null) {
                    return this._datasetField;
                }
                Object __rawValue = this._map.get("dataset");
                this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
                return this._datasetField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DatasetUrn getDataset() {
        if (this._datasetField != null) {
            return this._datasetField;
        }
        Object __rawValue = this._map.get("dataset");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dataset");
        }
        this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
        return this._datasetField;
    }

    public BaseData setDataset(@Nullable DatasetUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dataset of com.linkedin.ml.metadata.BaseData");
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._datasetField = value;
            }
        }
        return this;
    }

    public BaseData setDataset(@Nonnull DatasetUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataset of com.linkedin.ml.metadata.BaseData to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
        this._datasetField = value;
        return this;
    }

    public boolean hasMotivation() {
        if (this._motivationField != null) {
            return true;
        }
        return this._map.containsKey("motivation");
    }

    public void removeMotivation() {
        this._map.remove("motivation");
    }

    @Nullable
    public String getMotivation(GetMode mode) {
        return this.getMotivation();
    }

    @Nullable
    public String getMotivation() {
        if (this._motivationField != null) {
            return this._motivationField;
        }
        Object __rawValue = this._map.get("motivation");
        this._motivationField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._motivationField;
    }

    public BaseData setMotivation(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMotivation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMotivation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "motivation", value);
                this._motivationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "motivation", value);
                this._motivationField = value;
            }
        }
        return this;
    }

    public BaseData setMotivation(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field motivation of com.linkedin.ml.metadata.BaseData to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "motivation", value);
        this._motivationField = value;
        return this;
    }

    public boolean hasPreProcessing() {
        if (this._preProcessingField != null) {
            return true;
        }
        return this._map.containsKey("preProcessing");
    }

    public void removePreProcessing() {
        this._map.remove("preProcessing");
    }

    @Nullable
    public StringArray getPreProcessing(GetMode mode) {
        return this.getPreProcessing();
    }

    @Nullable
    public StringArray getPreProcessing() {
        if (this._preProcessingField != null) {
            return this._preProcessingField;
        }
        Object __rawValue = this._map.get("preProcessing");
        this._preProcessingField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._preProcessingField;
    }

    public BaseData setPreProcessing(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPreProcessing(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePreProcessing();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "preProcessing", value.data());
                this._preProcessingField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "preProcessing", value.data());
                this._preProcessingField = value;
            }
        }
        return this;
    }

    public BaseData setPreProcessing(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field preProcessing of com.linkedin.ml.metadata.BaseData to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "preProcessing", value.data());
        this._preProcessingField = value;
        return this;
    }

    @Override
    public BaseData clone() throws CloneNotSupportedException {
        BaseData __clone = (BaseData)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BaseData copy() throws CloneNotSupportedException {
        BaseData __copy = (BaseData)super.copy();
        __copy._preProcessingField = null;
        __copy._motivationField = null;
        __copy._datasetField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(DatasetUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BaseData __objectRef;

        private ChangeListener(BaseData reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "preProcessing": {
                    this.__objectRef._preProcessingField = null;
                    break;
                }
                case "motivation": {
                    this.__objectRef._motivationField = null;
                    break;
                }
                case "dataset": {
                    this.__objectRef._datasetField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec dataset() {
            return new PathSpec(this.getPathComponents(), "dataset");
        }

        public PathSpec motivation() {
            return new PathSpec(this.getPathComponents(), "motivation");
        }

        public PathSpec preProcessing() {
            return new PathSpec(this.getPathComponents(), "preProcessing");
        }

        public PathSpec preProcessing(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "preProcessing");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withDataset() {
            this.getDataMap().put("dataset", 1);
            return this;
        }

        public ProjectionMask withMotivation() {
            this.getDataMap().put("motivation", 1);
            return this;
        }

        public ProjectionMask withPreProcessing() {
            this.getDataMap().put("preProcessing", 1);
            return this;
        }

        public ProjectionMask withPreProcessing(Integer start, Integer count) {
            this.getDataMap().put("preProcessing", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("preProcessing").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("preProcessing").put("$count", count);
            }
            return this;
        }
    }
}

