/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.google.common.collect.ImmutableSet;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import com.linkedin.metadata.models.annotation.SearchableAnnotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;

public final class SearchableRefAnnotation {
    public static final String FIELD_NAME_ALIASES = "fieldNameAliases";
    public static final String ANNOTATION_NAME = "SearchableRef";
    private static final Set<SearchableAnnotation.FieldType> DEFAULT_QUERY_FIELD_TYPES = ImmutableSet.of(SearchableAnnotation.FieldType.TEXT, SearchableAnnotation.FieldType.OBJECT, SearchableAnnotation.FieldType.TEXT_PARTIAL, SearchableAnnotation.FieldType.WORD_GRAM, SearchableAnnotation.FieldType.URN, SearchableAnnotation.FieldType.URN_PARTIAL, new SearchableAnnotation.FieldType[0]);
    private final String fieldName;
    private final SearchableAnnotation.FieldType fieldType;
    private final boolean queryByDefault;
    private final double boostScore;
    private final int depth;
    private final String refType;
    private final List<String> fieldNameAliases;

    @Nonnull
    public static SearchableRefAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull DataSchema.Type schemaDataType, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> fieldName = AnnotationUtils.getField(map, "fieldName", String.class);
        Optional<String> fieldType = AnnotationUtils.getField(map, "fieldType", String.class);
        if (fieldType.isPresent() && !EnumUtils.isValidEnum(SearchableAnnotation.FieldType.class, fieldType.get())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field 'fieldType'. Invalid fieldType provided. Valid types are %s", ANNOTATION_NAME, context, Arrays.toString((Object[])SearchableAnnotation.FieldType.values())));
        }
        Optional<String> refType = AnnotationUtils.getField(map, "refType", String.class);
        if (!refType.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Mandatory input field refType defining the Entity Type is not provided", ANNOTATION_NAME, context));
        }
        Optional<Boolean> queryByDefault = AnnotationUtils.getField(map, "queryByDefault", Boolean.class);
        Optional<Integer> depth = AnnotationUtils.getField(map, "depth", Integer.class);
        Optional<Double> boostScore = AnnotationUtils.getField(map, "boostScore", Double.class);
        List<String> fieldNameAliases = SearchableRefAnnotation.getFieldNameAliases(map);
        SearchableAnnotation.FieldType resolvedFieldType = SearchableRefAnnotation.getFieldType(fieldType, schemaDataType);
        return new SearchableRefAnnotation(fieldName.orElse(schemaFieldName), resolvedFieldType, SearchableRefAnnotation.getQueryByDefault(queryByDefault, resolvedFieldType), boostScore.orElse(1.0), depth.orElse(2), refType.get(), fieldNameAliases);
    }

    private static Boolean getQueryByDefault(Optional<Boolean> maybeQueryByDefault, SearchableAnnotation.FieldType fieldType) {
        if (!maybeQueryByDefault.isPresent()) {
            if (DEFAULT_QUERY_FIELD_TYPES.contains((Object)fieldType)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return maybeQueryByDefault.get();
    }

    private static SearchableAnnotation.FieldType getFieldType(Optional<String> maybeFieldType, DataSchema.Type schemaDataType) {
        if (!maybeFieldType.isPresent()) {
            return SearchableRefAnnotation.getDefaultFieldType(schemaDataType);
        }
        return SearchableAnnotation.FieldType.valueOf(maybeFieldType.get());
    }

    private static SearchableAnnotation.FieldType getDefaultFieldType(DataSchema.Type schemaDataType) {
        switch (schemaDataType) {
            case INT: {
                return SearchableAnnotation.FieldType.COUNT;
            }
            case MAP: {
                return SearchableAnnotation.FieldType.KEYWORD;
            }
            case FLOAT: 
            case DOUBLE: {
                return SearchableAnnotation.FieldType.DOUBLE;
            }
        }
        return SearchableAnnotation.FieldType.TEXT;
    }

    private static List<String> getFieldNameAliases(Map map) {
        ArrayList<String> aliases = new ArrayList<String>();
        Optional<List> fieldNameAliases = AnnotationUtils.getField(map, FIELD_NAME_ALIASES, List.class);
        if (fieldNameAliases.isPresent()) {
            for (Object alias : fieldNameAliases.get()) {
                aliases.add((String)alias);
            }
        }
        return aliases;
    }

    @Generated
    public SearchableRefAnnotation(String fieldName, SearchableAnnotation.FieldType fieldType, boolean queryByDefault, double boostScore, int depth, String refType, List<String> fieldNameAliases) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.queryByDefault = queryByDefault;
        this.boostScore = boostScore;
        this.depth = depth;
        this.refType = refType;
        this.fieldNameAliases = fieldNameAliases;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public SearchableAnnotation.FieldType getFieldType() {
        return this.fieldType;
    }

    @Generated
    public boolean isQueryByDefault() {
        return this.queryByDefault;
    }

    @Generated
    public double getBoostScore() {
        return this.boostScore;
    }

    @Generated
    public int getDepth() {
        return this.depth;
    }

    @Generated
    public String getRefType() {
        return this.refType;
    }

    @Generated
    public List<String> getFieldNameAliases() {
        return this.fieldNameAliases;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchableRefAnnotation)) {
            return false;
        }
        SearchableRefAnnotation other = (SearchableRefAnnotation)o;
        if (this.isQueryByDefault() != other.isQueryByDefault()) {
            return false;
        }
        if (Double.compare(this.getBoostScore(), other.getBoostScore()) != 0) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        SearchableAnnotation.FieldType this$fieldType = this.getFieldType();
        SearchableAnnotation.FieldType other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType)) {
            return false;
        }
        String this$refType = this.getRefType();
        String other$refType = other.getRefType();
        if (this$refType == null ? other$refType != null : !this$refType.equals(other$refType)) {
            return false;
        }
        List<String> this$fieldNameAliases = this.getFieldNameAliases();
        List<String> other$fieldNameAliases = other.getFieldNameAliases();
        return !(this$fieldNameAliases == null ? other$fieldNameAliases != null : !((Object)this$fieldNameAliases).equals(other$fieldNameAliases));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isQueryByDefault() ? 79 : 97);
        long $boostScore = Double.doubleToLongBits(this.getBoostScore());
        result = result * 59 + (int)($boostScore >>> 32 ^ $boostScore);
        result = result * 59 + this.getDepth();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        SearchableAnnotation.FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        String $refType = this.getRefType();
        result = result * 59 + ($refType == null ? 43 : $refType.hashCode());
        List<String> $fieldNameAliases = this.getFieldNameAliases();
        result = result * 59 + ($fieldNameAliases == null ? 43 : ((Object)$fieldNameAliases).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchableRefAnnotation(fieldName=" + this.getFieldName() + ", fieldType=" + String.valueOf((Object)this.getFieldType()) + ", queryByDefault=" + this.isQueryByDefault() + ", boostScore=" + this.getBoostScore() + ", depth=" + this.getDepth() + ", refType=" + this.getRefType() + ", fieldNameAliases=" + String.valueOf(this.getFieldNameAliases()) + ")";
    }
}

