/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.google.common.collect.ImmutableSet;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.SearchableAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class SearchableAnnotationValidator {
    private static final Set<SearchableAnnotation.FieldType> TEXT_COMPATIBLE_TYPES = ImmutableSet.of(SearchableAnnotation.FieldType.KEYWORD, SearchableAnnotation.FieldType.TEXT, SearchableAnnotation.FieldType.TEXT_PARTIAL, SearchableAnnotation.FieldType.WORD_GRAM, SearchableAnnotation.FieldType.BROWSE_PATH, SearchableAnnotation.FieldType.URN, new SearchableAnnotation.FieldType[]{SearchableAnnotation.FieldType.URN_PARTIAL});
    private static final Set<SearchableAnnotation.FieldType> EXACT_MATCH_TYPES = ImmutableSet.of(SearchableAnnotation.FieldType.BOOLEAN, SearchableAnnotation.FieldType.COUNT, SearchableAnnotation.FieldType.DATETIME, SearchableAnnotation.FieldType.DOUBLE);

    public static void validateCrossAnnotationCompatibility(@Nonnull List<AnnotatedField> annotatedFields) {
        HashMap<String, List> searchLabelGroups = new HashMap<String, List>();
        for (AnnotatedField annotatedField : annotatedFields) {
            SearchableAnnotation annotation = annotatedField.getAnnotation();
            if (!annotation.getSearchLabel().isPresent()) continue;
            String searchLabel = annotation.getSearchLabel().get();
            searchLabelGroups.computeIfAbsent(searchLabel, k -> new ArrayList()).add(annotatedField);
        }
        for (Map.Entry entry : searchLabelGroups.entrySet()) {
            SearchableAnnotationValidator.validateFieldGroup((String)entry.getKey(), (List)entry.getValue(), "searchLabel");
        }
    }

    private static void validateFieldGroup(String labelValue, List<AnnotatedField> fields, String labelType) {
        if (fields.size() <= 1) {
            return;
        }
        AnnotatedField firstField = fields.get(0);
        DataSchema.Type firstSchemaType = firstField.getSchemaType();
        SearchableAnnotation.FieldType firstFieldType = firstField.getAnnotation().getFieldType();
        for (int i = 1; i < fields.size(); ++i) {
            AnnotatedField currentField = fields.get(i);
            DataSchema.Type currentSchemaType = currentField.getSchemaType();
            SearchableAnnotation.FieldType currentFieldType = currentField.getAnnotation().getFieldType();
            if (!firstSchemaType.equals((Object)currentSchemaType)) {
                throw new ModelValidationException(String.format("Failed to validate @%s annotations: fields with the same %s '%s' must have the same PDL type. Field at %s has type %s, but field at %s has type %s", new Object[]{"Searchable", labelType, labelValue, firstField.getContext(), firstSchemaType, currentField.getContext(), currentSchemaType}));
            }
            if (SearchableAnnotationValidator.areFieldTypesCompatible(firstFieldType, currentFieldType)) continue;
            throw new ModelValidationException(String.format("Failed to validate @%s annotations: fields with the same %s '%s' must have compatible fieldTypes. Field at %s has fieldType %s, but field at %s has fieldType %s", new Object[]{"Searchable", labelType, labelValue, firstField.getContext(), firstFieldType, currentField.getContext(), currentFieldType}));
        }
    }

    private static boolean areFieldTypesCompatible(SearchableAnnotation.FieldType type1, SearchableAnnotation.FieldType type2) {
        if (type1.equals((Object)type2)) {
            return true;
        }
        if (TEXT_COMPATIBLE_TYPES.contains((Object)type1) && TEXT_COMPATIBLE_TYPES.contains((Object)type2)) {
            return true;
        }
        if (EXACT_MATCH_TYPES.contains((Object)type1) || EXACT_MATCH_TYPES.contains((Object)type2)) {
            return false;
        }
        if (type1 == SearchableAnnotation.FieldType.OBJECT || type2 == SearchableAnnotation.FieldType.OBJECT) {
            return false;
        }
        return false;
    }

    public static class AnnotatedField {
        private final SearchableAnnotation annotation;
        private final DataSchema.Type schemaType;
        private final String context;

        public AnnotatedField(SearchableAnnotation annotation, DataSchema.Type schemaType, String context) {
            this.annotation = annotation;
            this.schemaType = schemaType;
            this.context = context;
        }

        public SearchableAnnotation getAnnotation() {
            return this.annotation;
        }

        public DataSchema.Type getSchemaType() {
            return this.schemaType;
        }

        public String getContext() {
            return this.context;
        }
    }
}

