/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;

public final class SearchScoreAnnotation {
    public static final String ANNOTATION_NAME = "SearchScore";
    private final String fieldName;
    private final double weight;
    private final double defaultValue;
    private final Optional<Modifier> modifier;

    @Nonnull
    public static SearchScoreAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> fieldName = AnnotationUtils.getField(map, "fieldName", String.class);
        Optional<Double> weight = AnnotationUtils.getField(map, "weight", Double.class);
        Optional<Double> defaultValue = AnnotationUtils.getField(map, "defaultValue", Double.class);
        Optional<String> modifierStr = AnnotationUtils.getField(map, "modifier", String.class);
        if (modifierStr.isPresent() && !EnumUtils.isValidEnum(Modifier.class, modifierStr.get())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field 'modifier'. Invalid modifier provided. Valid modifiers are %s", ANNOTATION_NAME, context, Arrays.toString((Object[])Modifier.values())));
        }
        Optional<Modifier> modifier = modifierStr.map(Modifier::valueOf);
        return new SearchScoreAnnotation(fieldName.orElse(schemaFieldName), weight.orElse(1.0), defaultValue.orElse(0.0), modifier);
    }

    @Generated
    public SearchScoreAnnotation(String fieldName, double weight, double defaultValue, Optional<Modifier> modifier) {
        this.fieldName = fieldName;
        this.weight = weight;
        this.defaultValue = defaultValue;
        this.modifier = modifier;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Generated
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Optional<Modifier> getModifier() {
        return this.modifier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchScoreAnnotation)) {
            return false;
        }
        SearchScoreAnnotation other = (SearchScoreAnnotation)o;
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getDefaultValue(), other.getDefaultValue()) != 0) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Optional<Modifier> this$modifier = this.getModifier();
        Optional<Modifier> other$modifier = other.getModifier();
        return !(this$modifier == null ? other$modifier != null : !((Object)this$modifier).equals(other$modifier));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        long $defaultValue = Double.doubleToLongBits(this.getDefaultValue());
        result = result * 59 + (int)($defaultValue >>> 32 ^ $defaultValue);
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Optional<Modifier> $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : ((Object)$modifier).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchScoreAnnotation(fieldName=" + this.getFieldName() + ", weight=" + this.getWeight() + ", defaultValue=" + this.getDefaultValue() + ", modifier=" + String.valueOf(this.getModifier()) + ")";
    }

    public static enum Modifier {
        LOG,
        LN,
        SQRT,
        SQUARE,
        RECIPROCAL;

    }
}

