/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.metadata.models.FieldSpecUtils;
import com.linkedin.metadata.models.UrnValidationFieldSpec;
import com.linkedin.metadata.models.annotation.UrnValidationAnnotation;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class UrnValidationFieldSpecExtractor
implements SchemaVisitor {
    private final List<UrnValidationFieldSpec> urnValidationFieldSpecs = new ArrayList<UrnValidationFieldSpec>();

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (context.getEnclosingField() == null) {
            return;
        }
        if (DataSchemaTraverse.Order.PRE_ORDER.equals((Object)order)) {
            DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
            PathSpec path = new PathSpec(context.getSchemaPathSpec());
            Object urnValidationAnnotationObj = context.getEnclosingField().getProperties().get("UrnValidation");
            if (urnValidationAnnotationObj != null) {
                this.addUrnValidationFieldSpec(currentSchema, path, urnValidationAnnotationObj);
            }
        }
    }

    private void addUrnValidationFieldSpec(DataSchema currentSchema, PathSpec path, Object annotationObj) {
        UrnValidationAnnotation annotation = UrnValidationAnnotation.fromPegasusAnnotationObject(annotationObj, FieldSpecUtils.getSchemaFieldName(path), path.toString());
        this.urnValidationFieldSpecs.add(new UrnValidationFieldSpec(path, annotation, currentSchema));
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return null;
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return new SchemaVisitorTraversalResult();
    }

    @Generated
    public List<UrnValidationFieldSpec> getUrnValidationFieldSpecs() {
        return this.urnValidationFieldSpecs;
    }
}

