/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.metadata.models.FieldSpecUtils;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.SearchableRefFieldSpec;
import com.linkedin.metadata.models.annotation.SearchableRefAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchableRefFieldSpecExtractor
implements SchemaVisitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchableRefFieldSpecExtractor.class);
    private final List<SearchableRefFieldSpec> _specs = new ArrayList<SearchableRefFieldSpec>();
    private final Map<String, String> _searchRefFieldNamesToPatch = new HashMap<String, String>();

    public List<SearchableRefFieldSpec> getSpecs() {
        return this._specs;
    }

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (context.getEnclosingField() == null) {
            return;
        }
        if (DataSchemaTraverse.Order.PRE_ORDER.equals((Object)order)) {
            DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
            Object annotationObj = this.getAnnotationObj(context);
            if (annotationObj != null) {
                if (currentSchema.getDereferencedDataSchema().isComplex()) {
                    ComplexDataSchema complexSchema = (ComplexDataSchema)currentSchema;
                    if (this.isValidComplexType(complexSchema).booleanValue()) {
                        this.extractSearchableRefAnnotation(annotationObj, currentSchema, context);
                    }
                } else if (this.isValidPrimitiveType((PrimitiveDataSchema)currentSchema).booleanValue()) {
                    this.extractSearchableRefAnnotation(annotationObj, currentSchema, context);
                } else {
                    throw new ModelValidationException(String.format("Invalid @SearchableRef Annotation at %s", context.getSchemaPathSpec().toString()));
                }
            }
        }
    }

    private Object getAnnotationObj(TraverserContext context) {
        DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
        Map<String, Object> properties = context.getEnclosingField().getProperties();
        Object primaryAnnotationObj = properties.get("SearchableRef");
        if (primaryAnnotationObj != null) {
            this.validatePropertiesAnnotation(currentSchema, primaryAnnotationObj, context.getTraversePath().toString());
            if (currentSchema.getDereferencedType() == DataSchema.Type.MAP && primaryAnnotationObj instanceof Map && !((Map)primaryAnnotationObj).isEmpty()) {
                return ((Map.Entry)((Map)primaryAnnotationObj).entrySet().stream().findFirst().get()).getValue();
            }
        }
        Map<String, Object> resolvedProperties = FieldSpecUtils.getResolvedProperties(currentSchema, properties);
        Object resolvedAnnotationObj = resolvedProperties.get("SearchableRef");
        return resolvedAnnotationObj;
    }

    private void extractSearchableRefAnnotation(Object annotationObj, DataSchema currentSchema, TraverserContext context) {
        PathSpec path = new PathSpec(context.getSchemaPathSpec());
        Optional<PathSpec> fullPath = FieldSpecUtils.getPathSpecWithAspectName(context);
        SearchableRefAnnotation annotation = SearchableRefAnnotation.fromPegasusAnnotationObject(annotationObj, FieldSpecUtils.getSchemaFieldName(path), currentSchema.getDereferencedType(), path.toString());
        String schemaPathSpec = context.getSchemaPathSpec().toString();
        if (this._searchRefFieldNamesToPatch.containsKey(annotation.getFieldName()) && !this._searchRefFieldNamesToPatch.get(annotation.getFieldName()).equals(schemaPathSpec)) {
            String pathName = path.toString().replace('/', '_').replace("*", "");
            if (pathName.startsWith("_")) {
                pathName = pathName.replaceFirst("_", "");
            }
            if (this._searchRefFieldNamesToPatch.containsKey(pathName) && !this._searchRefFieldNamesToPatch.get(pathName).equals(schemaPathSpec)) {
                throw new ModelValidationException(String.format("Entity has multiple searchableRef fields with the same field name %s, path: %s", annotation.getFieldName(), fullPath.orElse(path)));
            }
            annotation = new SearchableRefAnnotation(pathName, annotation.getFieldType(), annotation.isQueryByDefault(), annotation.getBoostScore(), annotation.getDepth(), annotation.getRefType(), annotation.getFieldNameAliases());
        }
        log.debug("SearchableRef annotation for field: {} : {}", (Object)schemaPathSpec, (Object)annotation);
        SearchableRefFieldSpec fieldSpec = new SearchableRefFieldSpec(path, annotation, currentSchema);
        this._specs.add(fieldSpec);
        this._searchRefFieldNamesToPatch.put(annotation.getFieldName(), context.getSchemaPathSpec().toString());
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return null;
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return new SchemaVisitorTraversalResult();
    }

    private void validatePropertiesAnnotation(DataSchema currentSchema, Object annotationObj, String pathStr) {
        if (currentSchema.isPrimitive() || currentSchema.getDereferencedType().equals((Object)DataSchema.Type.ENUM) || currentSchema.getDereferencedType().equals((Object)DataSchema.Type.MAP)) {
            return;
        }
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared inside %s: Invalid value type provided (Expected Map)", "SearchableRef", pathStr));
        }
        Map annotationMap = (Map)annotationObj;
        if (annotationMap.size() == 0) {
            throw new ModelValidationException(String.format("Invalid @SearchableRef Annotation at %s. Annotation placed on invalid field of type %s. Must be placed on primitive field.", new Object[]{pathStr, currentSchema.getType()}));
        }
        for (String key : annotationMap.keySet()) {
            if (key.startsWith(Character.toString('/'))) continue;
            throw new ModelValidationException(String.format("Invalid @SearchableRef Annotation at %s. Annotation placed on invalid field of type %s. Must be placed on primitive field.", new Object[]{pathStr, currentSchema.getType()}));
        }
    }

    private Boolean isValidComplexType(ComplexDataSchema schema) {
        return DataSchema.Type.ENUM.equals((Object)schema.getDereferencedDataSchema().getDereferencedType()) || DataSchema.Type.MAP.equals((Object)schema.getDereferencedDataSchema().getDereferencedType());
    }

    private Boolean isValidPrimitiveType(PrimitiveDataSchema schema) {
        return true;
    }
}

