/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template.chart;

import com.linkedin.chart.ChartDataSourceTypeArray;
import com.linkedin.chart.ChartInfo;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.ChangeAuditStamps;
import com.linkedin.common.EdgeArray;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.ArrayMergingTemplate;
import datahub.shaded.jackson.databind.JsonNode;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ChartInfoTemplate
implements ArrayMergingTemplate<ChartInfo> {
    private static final String INPUT_EDGES_FIELD_NAME = "inputEdges";
    private static final String INPUTS_FIELD_NAME = "inputs";
    private static final String DESTINATION_URN_FIELD_NAME = "destinationUrn";

    @Override
    public ChartInfo getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (recordTemplate instanceof ChartInfo) {
            return (ChartInfo)recordTemplate;
        }
        throw new ClassCastException("Unable to cast RecordTemplate to DataJobInputOutput");
    }

    @Override
    public Class<ChartInfo> getTemplateType() {
        return ChartInfo.class;
    }

    @Override
    @Nonnull
    public ChartInfo getDefault() {
        ChartInfo chartInfo = new ChartInfo();
        chartInfo.setDescription("");
        chartInfo.setTitle("");
        ChangeAuditStamps changeAuditStamps = new ChangeAuditStamps();
        AuditStamp auditStamp = new AuditStamp().setActor(UrnUtils.getUrn("urn:li:corpuser:__datahub_system")).setTime(System.currentTimeMillis());
        changeAuditStamps.setCreated(auditStamp).setLastModified(auditStamp);
        chartInfo.setLastModified(changeAuditStamps);
        chartInfo.setInputEdges(new EdgeArray());
        chartInfo.setInputs(new ChartDataSourceTypeArray());
        return chartInfo;
    }

    @Override
    @Nonnull
    public JsonNode transformFields(JsonNode baseNode) {
        JsonNode transformedNode = this.arrayFieldToMap(baseNode, INPUT_EDGES_FIELD_NAME, Collections.singletonList(DESTINATION_URN_FIELD_NAME));
        transformedNode = this.arrayFieldToMap(transformedNode, INPUTS_FIELD_NAME, Collections.emptyList());
        return transformedNode;
    }

    @Override
    @Nonnull
    public JsonNode rebaseFields(JsonNode patched) {
        JsonNode rebasedNode = this.transformedMapToArray(patched, INPUT_EDGES_FIELD_NAME, Collections.singletonList(DESTINATION_URN_FIELD_NAME));
        rebasedNode = this.transformedMapToArray(rebasedNode, INPUTS_FIELD_NAME, Collections.emptyList());
        return rebasedNode;
    }
}

