/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template;

import com.google.common.collect.Streams;
import com.linkedin.common.urn.Urn;
import com.linkedin.common.urn.UrnUtils;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.ArrayNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.StringUtils;

public class FineGrainedLineageTemplateHelper {
    private static final String FINE_GRAINED_UPSTREAM_TYPE = "upstreamType";
    private static final String FINE_GRAINED_UPSTREAMS = "upstreams";
    private static final String FINE_GRAINED_DOWNSTREAM_TYPE = "downstreamType";
    private static final String FINE_GRAINED_DOWNSTREAMS = "downstreams";
    private static final String FINE_GRAINED_TRANSFORMATION_OPERATION = "transformOperation";
    private static final String FINE_GRAINED_CONFIDENCE_SCORE = "confidenceScore";
    private static final String FINE_GRAINED_QUERY_ID = "query";
    private static final String NONE_TRANSFORMATION_TYPE = "NONE";
    private static final Float DEFAULT_CONFIDENCE_SCORE = Float.valueOf(1.0f);
    private static final String DEFAULT_QUERY_ID = "NONE";

    public static JsonNode combineAndTransformFineGrainedLineages(@Nullable JsonNode fineGrainedLineages) {
        ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
        if (!(fineGrainedLineages instanceof ArrayNode) || fineGrainedLineages.isEmpty()) {
            return mapNode;
        }
        Object lineageCopy = fineGrainedLineages.deepCopy();
        ((JsonNode)lineageCopy).elements().forEachRemaining(node -> {
            ObjectNode downstreamRootNode;
            String downstreamRoot;
            String queryId;
            ArrayNode downstreams;
            String transformationOperation;
            Object nodeClone = node.deepCopy();
            String string = transformationOperation = ((JsonNode)nodeClone).has(FINE_GRAINED_TRANSFORMATION_OPERATION) ? ((JsonNode)nodeClone).get(FINE_GRAINED_TRANSFORMATION_OPERATION).asText() : "NONE";
            if (!mapNode.has(transformationOperation)) {
                mapNode.set(transformationOperation, JsonNodeFactory.instance.objectNode());
            }
            ObjectNode transformationOperationNode = (ObjectNode)mapNode.get(transformationOperation);
            ArrayNode arrayNode = downstreams = ((JsonNode)nodeClone).has(FINE_GRAINED_DOWNSTREAMS) ? (ArrayNode)((JsonNode)nodeClone).get(FINE_GRAINED_DOWNSTREAMS) : null;
            if (downstreams == null || downstreams.size() != 1) {
                throw new UnsupportedOperationException("Patching not supported on fine grained lineages with not exactly one downstream. Current fine grained lineage implementation is downstream derived and patches are keyed on the root of this derivation.");
            }
            Float confidenceScore = Float.valueOf(((JsonNode)nodeClone).has(FINE_GRAINED_CONFIDENCE_SCORE) ? ((JsonNode)nodeClone).get(FINE_GRAINED_CONFIDENCE_SCORE).floatValue() : DEFAULT_CONFIDENCE_SCORE.floatValue());
            String upstreamType = ((JsonNode)nodeClone).has(FINE_GRAINED_UPSTREAM_TYPE) ? ((JsonNode)nodeClone).get(FINE_GRAINED_UPSTREAM_TYPE).asText() : null;
            String downstreamType = ((JsonNode)nodeClone).has(FINE_GRAINED_DOWNSTREAM_TYPE) ? ((JsonNode)nodeClone).get(FINE_GRAINED_DOWNSTREAM_TYPE).asText() : null;
            ArrayNode upstreams = ((JsonNode)nodeClone).has(FINE_GRAINED_UPSTREAMS) ? (ArrayNode)((JsonNode)nodeClone).get(FINE_GRAINED_UPSTREAMS) : null;
            String string2 = queryId = ((JsonNode)nodeClone).has(FINE_GRAINED_QUERY_ID) ? ((JsonNode)nodeClone).get(FINE_GRAINED_QUERY_ID).asText() : "NONE";
            if (upstreamType == null) {
                Urn upstreamUrn = upstreams != null ? UrnUtils.getUrn(upstreams.get(0).asText()) : null;
                upstreamType = upstreamUrn != null && "dataset".equals(upstreamUrn.getEntityType()) ? "DATASET" : "FIELD_SET";
            }
            if (downstreamType == null) {
                downstreamType = "FIELD";
            }
            if (!transformationOperationNode.has(downstreamRoot = downstreams.get(0).asText())) {
                transformationOperationNode.set(downstreamRoot, JsonNodeFactory.instance.objectNode());
            }
            if (!(downstreamRootNode = (ObjectNode)transformationOperationNode.get(downstreamRoot)).has(queryId)) {
                downstreamRootNode.set(queryId, JsonNodeFactory.instance.objectNode());
            }
            ObjectNode queryNode = (ObjectNode)downstreamRootNode.get(queryId);
            if (upstreams != null) {
                FineGrainedLineageTemplateHelper.addUrnsToParent(queryNode, upstreams, confidenceScore, upstreamType, downstreamType);
            }
        });
        return mapNode;
    }

    private static void addUrnsToParent(JsonNode parentNode, ArrayNode urnsList, Float confidenceScore, String upstreamType, String downstreamType) {
        ((ObjectNode)parentNode).setAll(Streams.stream(urnsList.elements()).map(JsonNode::asText).distinct().collect(Collectors.toMap(urn -> urn, urn -> FineGrainedLineageTemplateHelper.mapToLineageValueNode(confidenceScore, upstreamType, downstreamType))));
    }

    private static JsonNode mapToLineageValueNode(Float confidenceScore, String upstreamType, String downstreamType) {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.set(FINE_GRAINED_CONFIDENCE_SCORE, JsonNodeFactory.instance.numberNode(confidenceScore));
        objectNode.set(FINE_GRAINED_UPSTREAM_TYPE, JsonNodeFactory.instance.textNode(upstreamType));
        objectNode.set(FINE_GRAINED_DOWNSTREAM_TYPE, JsonNodeFactory.instance.textNode(downstreamType));
        return objectNode;
    }

    public static ArrayNode reconstructFineGrainedLineages(JsonNode transformedFineGrainedLineages) {
        if (transformedFineGrainedLineages instanceof ArrayNode) {
            return (ArrayNode)transformedFineGrainedLineages;
        }
        ObjectNode mapNode = (ObjectNode)transformedFineGrainedLineages;
        ArrayNode fineGrainedLineages = JsonNodeFactory.instance.arrayNode();
        mapNode.fieldNames().forEachRemaining(transformationOperation -> {
            ObjectNode transformationOperationNode = (ObjectNode)mapNode.get((String)transformationOperation);
            transformationOperationNode.fieldNames().forEachRemaining(downstreamName -> {
                ObjectNode downstreamNode = (ObjectNode)transformationOperationNode.get((String)downstreamName);
                downstreamNode.fieldNames().forEachRemaining(queryId -> FineGrainedLineageTemplateHelper.buildFineGrainedLineage(downstreamName, downstreamNode, queryId, transformationOperation, fineGrainedLineages));
            });
        });
        return fineGrainedLineages;
    }

    private static void buildFineGrainedLineage(String downstreamName, ObjectNode downstreamNode, String queryId, String transformationOperation, ArrayNode fineGrainedLineages) {
        ObjectNode fineGrainedLineage = JsonNodeFactory.instance.objectNode();
        ObjectNode queryNode = (ObjectNode)downstreamNode.get(queryId);
        if (queryNode.isEmpty()) {
            return;
        }
        ArrayNode downstream = JsonNodeFactory.instance.arrayNode();
        downstream.add(JsonNodeFactory.instance.textNode(downstreamName));
        AtomicReference<Float> minimumConfidenceScore = new AtomicReference<Float>(DEFAULT_CONFIDENCE_SCORE);
        AtomicReference<String> upstreamType = new AtomicReference<String>("FIELD_SET");
        AtomicReference<String> downstreamType = new AtomicReference<String>("FIELD");
        ArrayNode upstreams = JsonNodeFactory.instance.arrayNode();
        queryNode.fieldNames().forEachRemaining(upstream -> FineGrainedLineageTemplateHelper.processUpstream(queryNode, upstream, minimumConfidenceScore, upstreamType, downstreamType, upstreams));
        fineGrainedLineage.set(FINE_GRAINED_DOWNSTREAMS, downstream);
        fineGrainedLineage.set(FINE_GRAINED_UPSTREAMS, upstreams);
        if (StringUtils.isNotBlank(queryId) && !"NONE".equals(queryId)) {
            fineGrainedLineage.set(FINE_GRAINED_QUERY_ID, JsonNodeFactory.instance.textNode(queryId));
        }
        fineGrainedLineage.set(FINE_GRAINED_UPSTREAM_TYPE, JsonNodeFactory.instance.textNode(upstreamType.get()));
        fineGrainedLineage.set(FINE_GRAINED_DOWNSTREAM_TYPE, JsonNodeFactory.instance.textNode(downstreamType.get()));
        fineGrainedLineage.set(FINE_GRAINED_CONFIDENCE_SCORE, JsonNodeFactory.instance.numberNode(minimumConfidenceScore.get()));
        fineGrainedLineage.set(FINE_GRAINED_TRANSFORMATION_OPERATION, JsonNodeFactory.instance.textNode(transformationOperation));
        fineGrainedLineages.add(fineGrainedLineage);
    }

    private static void processUpstream(ObjectNode queryNode, String upstream, AtomicReference<Float> minimumConfidenceScore, AtomicReference<String> upstreamType, AtomicReference<String> downstreamType, ArrayNode upstreams) {
        Float scoreValue;
        ObjectNode upstreamNode = (ObjectNode)queryNode.get(upstream);
        if (upstreamNode.has(FINE_GRAINED_CONFIDENCE_SCORE) && (scoreValue = Float.valueOf(upstreamNode.get(FINE_GRAINED_CONFIDENCE_SCORE).floatValue())).floatValue() <= minimumConfidenceScore.get().floatValue()) {
            minimumConfidenceScore.set(scoreValue);
        }
        if (upstreamNode.has(FINE_GRAINED_UPSTREAM_TYPE)) {
            upstreamType.set(upstreamNode.get(FINE_GRAINED_UPSTREAM_TYPE).asText());
        }
        if (upstreamNode.has(FINE_GRAINED_DOWNSTREAM_TYPE)) {
            downstreamType.set(upstreamNode.get(FINE_GRAINED_DOWNSTREAM_TYPE).asText());
        }
        upstreams.add(JsonNodeFactory.instance.textNode(upstream));
    }
}

