/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.Template;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.ArrayNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import datahub.shaded.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;

public interface ArrayMergingTemplate<T extends RecordTemplate>
extends Template<T> {
    public static final String UNIT_SEPARATOR_DELIMITER = "\u241f";

    default public JsonNode arrayFieldToMap(JsonNode baseNode, String arrayFieldName, List<String> keyFields) {
        Object transformedNode = baseNode.deepCopy();
        JsonNode arrayNode = baseNode.get(arrayFieldName);
        ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
        if (arrayNode instanceof ArrayNode) {
            ((ArrayNode)arrayNode).elements().forEachRemaining(node -> {
                ObjectNode keyValue = mapNode;
                Object nodeClone = node.deepCopy();
                if (!keyFields.isEmpty()) {
                    for (String keyField : keyFields) {
                        String key = "";
                        if (keyField.contains(UNIT_SEPARATOR_DELIMITER)) {
                            String[] keyParts = keyField.split(UNIT_SEPARATOR_DELIMITER);
                            JsonNode keyObject = node;
                            try {
                                for (int i = 0; i < keyParts.length - 1; ++i) {
                                    keyObject = keyObject.get(keyParts[i]);
                                }
                                JsonNode finalKeyNode = keyObject.get(keyParts[keyParts.length - 1]);
                                key = finalKeyNode != null ? finalKeyNode.asText() : "";
                            }
                            catch (IllegalArgumentException | NullPointerException e) {
                                key = "";
                            }
                        } else {
                            JsonNode keyNode = node.get(keyField);
                            key = keyNode != null ? keyNode.asText() : "";
                        }
                        keyValue = keyValue.get(key) == null ? (ObjectNode)((JsonNode)keyValue.set(key, JsonNodeFactory.instance.objectNode())).get(key) : (ObjectNode)keyValue.get(key);
                    }
                } else {
                    nodeClone = JsonNodeFactory.instance.objectNode().set(node instanceof TextNode ? ((TextNode)node).asText() : "", (JsonNode)node);
                }
                keyValue.setAll((ObjectNode)nodeClone);
            });
        }
        return ((ObjectNode)transformedNode).set(arrayFieldName, mapNode);
    }

    default public JsonNode transformedMapToArray(JsonNode transformedNode, String arrayFieldName, List<String> keyFields) {
        ArrayNode arrayNode;
        JsonNode fieldNode = transformedNode.get(arrayFieldName);
        if (fieldNode instanceof ArrayNode) {
            return transformedNode;
        }
        ObjectNode rebasedNode = (ObjectNode)transformedNode.deepCopy();
        ObjectNode mapNode = (ObjectNode)fieldNode;
        if (!keyFields.isEmpty()) {
            arrayNode = this.mergeToArray(mapNode, keyFields);
        } else {
            arrayNode = JsonNodeFactory.instance.arrayNode();
            mapNode.fields().forEachRemaining(entry -> arrayNode.add((JsonNode)entry.getValue()));
        }
        return rebasedNode.set(arrayFieldName, arrayNode);
    }

    default public ArrayNode mergeToArray(JsonNode mapNode, List<String> keyFields) {
        if (keyFields.isEmpty()) {
            return JsonNodeFactory.instance.arrayNode().add(mapNode);
        }
        ArrayNode mergingArray = JsonNodeFactory.instance.arrayNode();
        mapNode.elements().forEachRemaining(node -> mergingArray.addAll(this.mergeToArray((JsonNode)node, (List<String>)(keyFields.size() > 1 ? keyFields.subList(1, keyFields.size()) : Collections.emptyList()))));
        return mergingArray;
    }
}

