/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.batch;

import com.google.common.collect.ImmutableSet;
import com.linkedin.common.urn.Urn;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.mxe.SystemMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MCPItem
extends BatchItem {
    public static final Set<ChangeType> CHANGE_TYPES = ImmutableSet.of(ChangeType.UPSERT, ChangeType.UPDATE, ChangeType.CREATE, ChangeType.CREATE_ENTITY);

    @Nullable
    public MetadataChangeProposal getMetadataChangeProposal();

    default public void setSystemMetadata(@Nonnull SystemMetadata systemMetadata) {
        this.getMetadataChangeProposal().setSystemMetadata(systemMetadata);
    }

    @Nonnull
    default public Map<String, String> getHeaders() {
        if (this.getMetadataChangeProposal() != null && this.getMetadataChangeProposal().getHeaders() != null) {
            return this.getMetadataChangeProposal().getHeaders();
        }
        return Collections.emptyMap();
    }

    default public boolean hasHeader(@Nonnull String headerName) {
        return this.getHeaders().keySet().stream().anyMatch(hdr -> hdr.equalsIgnoreCase(headerName));
    }

    default public Optional<String> getHeader(@Nonnull String headerName) {
        return this.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(headerName)).map(Map.Entry::getValue).findAny();
    }

    public static boolean isValidChangeType(ChangeType changeType, AspectSpec aspectSpec) {
        if (aspectSpec.isTimeseries()) {
            return ChangeType.UPSERT.equals((Object)changeType);
        }
        if (ChangeType.PATCH.equals((Object)changeType)) {
            return MCPItem.supportsPatch(aspectSpec);
        }
        return CHANGE_TYPES.contains((Object)changeType);
    }

    public static boolean supportsPatch(AspectSpec aspectSpec) {
        return true;
    }

    default public void validate(Urn urn, String aspectName, EntityRegistry entityRegistry) {
    }
}

