/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NativeGroupMembership
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Carries information about the native CorpGroups a user is in.*/@Aspect.name=\"nativeGroupMembership\"record NativeGroupMembership{@Relationship.`/*`={\"entityTypes\":[\"corpGroup\"],\"name\":\"IsMemberOfNativeGroup\"}nativeGroups:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]}", SchemaFormatType.PDL);
    private UrnArray _nativeGroupsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_NativeGroups = SCHEMA.getField("nativeGroups");

    public NativeGroupMembership() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public NativeGroupMembership(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasNativeGroups() {
        if (this._nativeGroupsField != null) {
            return true;
        }
        return this._map.containsKey("nativeGroups");
    }

    public void removeNativeGroups() {
        this._map.remove("nativeGroups");
    }

    @Nullable
    public UrnArray getNativeGroups(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNativeGroups();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nativeGroupsField != null) {
                    return this._nativeGroupsField;
                }
                Object __rawValue = this._map.get("nativeGroups");
                this._nativeGroupsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._nativeGroupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getNativeGroups() {
        if (this._nativeGroupsField != null) {
            return this._nativeGroupsField;
        }
        Object __rawValue = this._map.get("nativeGroups");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("nativeGroups");
        }
        this._nativeGroupsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._nativeGroupsField;
    }

    public NativeGroupMembership setNativeGroups(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNativeGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field nativeGroups of com.linkedin.identity.NativeGroupMembership");
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeGroups", value.data());
                this._nativeGroupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNativeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeGroups", value.data());
                this._nativeGroupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nativeGroups", value.data());
                this._nativeGroupsField = value;
            }
        }
        return this;
    }

    public NativeGroupMembership setNativeGroups(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nativeGroups of com.linkedin.identity.NativeGroupMembership to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nativeGroups", value.data());
        this._nativeGroupsField = value;
        return this;
    }

    @Override
    public NativeGroupMembership clone() throws CloneNotSupportedException {
        NativeGroupMembership __clone = (NativeGroupMembership)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public NativeGroupMembership copy() throws CloneNotSupportedException {
        NativeGroupMembership __copy = (NativeGroupMembership)super.copy();
        __copy._nativeGroupsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final NativeGroupMembership __objectRef;

        private ChangeListener(NativeGroupMembership reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "nativeGroups": {
                    this.__objectRef._nativeGroupsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec nativeGroups() {
            return new PathSpec(this.getPathComponents(), "nativeGroups");
        }

        public PathSpec nativeGroups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "nativeGroups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withNativeGroups() {
            this.getDataMap().put("nativeGroups", 1);
            return this;
        }

        public ProjectionMask withNativeGroups(Integer start, Integer count) {
            this.getDataMap().put("nativeGroups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("nativeGroups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("nativeGroups").put("$count", count);
            }
            return this;
        }
    }
}

