/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataplatform.slack;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SlackConversation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataplatform.slack/**Information about a Slack conversation.*/record SlackConversation{/**The unique ID of the Slack conversation.*/id:string/**The display name of the Slack conversation.*/displayName:string/**If this is a channel.*/isChannel:boolean/**If this is a channel.*/isGroup:boolean/**If this is a private conversation.*/isPrivate:boolean/**If this conversation is archived.*/isArchived:boolean/**If this is a shared channel.*/isShared:boolean/**If this is an externally shared channel.*/isExtShared:boolean/**If this is a general channel.*/isGeneral:boolean/**The team this conversation lives within.*/contextTeamID:optional string/**The purpose of this Slack channel, if set.*/purpose:optional string/**The topic of this Slack channel, if set.*/topic:optional string}", SchemaFormatType.PDL);
    private String _idField = null;
    private String _displayNameField = null;
    private Boolean _isChannelField = null;
    private Boolean _isGroupField = null;
    private Boolean _isPrivateField = null;
    private Boolean _isArchivedField = null;
    private Boolean _isSharedField = null;
    private Boolean _isExtSharedField = null;
    private Boolean _isGeneralField = null;
    private String _contextTeamIDField = null;
    private String _purposeField = null;
    private String _topicField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Id = SCHEMA.getField("id");
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_IsChannel = SCHEMA.getField("isChannel");
    private static final RecordDataSchema.Field FIELD_IsGroup = SCHEMA.getField("isGroup");
    private static final RecordDataSchema.Field FIELD_IsPrivate = SCHEMA.getField("isPrivate");
    private static final RecordDataSchema.Field FIELD_IsArchived = SCHEMA.getField("isArchived");
    private static final RecordDataSchema.Field FIELD_IsShared = SCHEMA.getField("isShared");
    private static final RecordDataSchema.Field FIELD_IsExtShared = SCHEMA.getField("isExtShared");
    private static final RecordDataSchema.Field FIELD_IsGeneral = SCHEMA.getField("isGeneral");
    private static final RecordDataSchema.Field FIELD_ContextTeamID = SCHEMA.getField("contextTeamID");
    private static final RecordDataSchema.Field FIELD_Purpose = SCHEMA.getField("purpose");
    private static final RecordDataSchema.Field FIELD_Topic = SCHEMA.getField("topic");

    public SlackConversation() {
        super(new DataMap(), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SlackConversation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._idField != null) {
                    return this._idField;
                }
                Object __rawValue = this._map.get("id");
                this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._idField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("id");
        }
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public SlackConversation setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field id of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public SlackConversation setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDisplayName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._displayNameField != null) {
                    return this._displayNameField;
                }
                Object __rawValue = this._map.get("displayName");
                this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._displayNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("displayName");
        }
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public SlackConversation setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field displayName of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public SlackConversation setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasIsChannel() {
        if (this._isChannelField != null) {
            return true;
        }
        return this._map.containsKey("isChannel");
    }

    public void removeIsChannel() {
        this._map.remove("isChannel");
    }

    @Nullable
    public Boolean isIsChannel(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsChannel();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isChannelField != null) {
                    return this._isChannelField;
                }
                Object __rawValue = this._map.get("isChannel");
                this._isChannelField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isChannelField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsChannel() {
        if (this._isChannelField != null) {
            return this._isChannelField;
        }
        Object __rawValue = this._map.get("isChannel");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isChannel");
        }
        this._isChannelField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isChannelField;
    }

    public SlackConversation setIsChannel(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsChannel(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isChannel of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isChannel", value);
                this._isChannelField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsChannel();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isChannel", value);
                this._isChannelField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isChannel", value);
                this._isChannelField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsChannel(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isChannel of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isChannel", value);
        this._isChannelField = value;
        return this;
    }

    public SlackConversation setIsChannel(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isChannel", value);
        this._isChannelField = value;
        return this;
    }

    public boolean hasIsGroup() {
        if (this._isGroupField != null) {
            return true;
        }
        return this._map.containsKey("isGroup");
    }

    public void removeIsGroup() {
        this._map.remove("isGroup");
    }

    @Nullable
    public Boolean isIsGroup(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsGroup();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isGroupField != null) {
                    return this._isGroupField;
                }
                Object __rawValue = this._map.get("isGroup");
                this._isGroupField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isGroupField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsGroup() {
        if (this._isGroupField != null) {
            return this._isGroupField;
        }
        Object __rawValue = this._map.get("isGroup");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isGroup");
        }
        this._isGroupField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isGroupField;
    }

    public SlackConversation setIsGroup(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsGroup(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isGroup of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isGroup", value);
                this._isGroupField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsGroup();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isGroup", value);
                this._isGroupField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isGroup", value);
                this._isGroupField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsGroup(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isGroup of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isGroup", value);
        this._isGroupField = value;
        return this;
    }

    public SlackConversation setIsGroup(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isGroup", value);
        this._isGroupField = value;
        return this;
    }

    public boolean hasIsPrivate() {
        if (this._isPrivateField != null) {
            return true;
        }
        return this._map.containsKey("isPrivate");
    }

    public void removeIsPrivate() {
        this._map.remove("isPrivate");
    }

    @Nullable
    public Boolean isIsPrivate(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsPrivate();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isPrivateField != null) {
                    return this._isPrivateField;
                }
                Object __rawValue = this._map.get("isPrivate");
                this._isPrivateField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isPrivateField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsPrivate() {
        if (this._isPrivateField != null) {
            return this._isPrivateField;
        }
        Object __rawValue = this._map.get("isPrivate");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isPrivate");
        }
        this._isPrivateField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isPrivateField;
    }

    public SlackConversation setIsPrivate(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsPrivate(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isPrivate of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isPrivate", value);
                this._isPrivateField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsPrivate();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isPrivate", value);
                this._isPrivateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isPrivate", value);
                this._isPrivateField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsPrivate(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isPrivate of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isPrivate", value);
        this._isPrivateField = value;
        return this;
    }

    public SlackConversation setIsPrivate(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isPrivate", value);
        this._isPrivateField = value;
        return this;
    }

    public boolean hasIsArchived() {
        if (this._isArchivedField != null) {
            return true;
        }
        return this._map.containsKey("isArchived");
    }

    public void removeIsArchived() {
        this._map.remove("isArchived");
    }

    @Nullable
    public Boolean isIsArchived(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsArchived();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isArchivedField != null) {
                    return this._isArchivedField;
                }
                Object __rawValue = this._map.get("isArchived");
                this._isArchivedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isArchivedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsArchived() {
        if (this._isArchivedField != null) {
            return this._isArchivedField;
        }
        Object __rawValue = this._map.get("isArchived");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isArchived");
        }
        this._isArchivedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isArchivedField;
    }

    public SlackConversation setIsArchived(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsArchived(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isArchived of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isArchived", value);
                this._isArchivedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsArchived();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isArchived", value);
                this._isArchivedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isArchived", value);
                this._isArchivedField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsArchived(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isArchived of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isArchived", value);
        this._isArchivedField = value;
        return this;
    }

    public SlackConversation setIsArchived(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isArchived", value);
        this._isArchivedField = value;
        return this;
    }

    public boolean hasIsShared() {
        if (this._isSharedField != null) {
            return true;
        }
        return this._map.containsKey("isShared");
    }

    public void removeIsShared() {
        this._map.remove("isShared");
    }

    @Nullable
    public Boolean isIsShared(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsShared();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isSharedField != null) {
                    return this._isSharedField;
                }
                Object __rawValue = this._map.get("isShared");
                this._isSharedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isSharedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsShared() {
        if (this._isSharedField != null) {
            return this._isSharedField;
        }
        Object __rawValue = this._map.get("isShared");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isShared");
        }
        this._isSharedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isSharedField;
    }

    public SlackConversation setIsShared(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsShared(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isShared of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isShared", value);
                this._isSharedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsShared();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isShared", value);
                this._isSharedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isShared", value);
                this._isSharedField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsShared(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isShared of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isShared", value);
        this._isSharedField = value;
        return this;
    }

    public SlackConversation setIsShared(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isShared", value);
        this._isSharedField = value;
        return this;
    }

    public boolean hasIsExtShared() {
        if (this._isExtSharedField != null) {
            return true;
        }
        return this._map.containsKey("isExtShared");
    }

    public void removeIsExtShared() {
        this._map.remove("isExtShared");
    }

    @Nullable
    public Boolean isIsExtShared(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsExtShared();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isExtSharedField != null) {
                    return this._isExtSharedField;
                }
                Object __rawValue = this._map.get("isExtShared");
                this._isExtSharedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isExtSharedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsExtShared() {
        if (this._isExtSharedField != null) {
            return this._isExtSharedField;
        }
        Object __rawValue = this._map.get("isExtShared");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isExtShared");
        }
        this._isExtSharedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isExtSharedField;
    }

    public SlackConversation setIsExtShared(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsExtShared(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isExtShared of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isExtShared", value);
                this._isExtSharedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsExtShared();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isExtShared", value);
                this._isExtSharedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isExtShared", value);
                this._isExtSharedField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsExtShared(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isExtShared of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isExtShared", value);
        this._isExtSharedField = value;
        return this;
    }

    public SlackConversation setIsExtShared(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isExtShared", value);
        this._isExtSharedField = value;
        return this;
    }

    public boolean hasIsGeneral() {
        if (this._isGeneralField != null) {
            return true;
        }
        return this._map.containsKey("isGeneral");
    }

    public void removeIsGeneral() {
        this._map.remove("isGeneral");
    }

    @Nullable
    public Boolean isIsGeneral(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isIsGeneral();
            }
            case DEFAULT: 
            case NULL: {
                if (this._isGeneralField != null) {
                    return this._isGeneralField;
                }
                Object __rawValue = this._map.get("isGeneral");
                this._isGeneralField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isGeneralField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsGeneral() {
        if (this._isGeneralField != null) {
            return this._isGeneralField;
        }
        Object __rawValue = this._map.get("isGeneral");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("isGeneral");
        }
        this._isGeneralField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isGeneralField;
    }

    public SlackConversation setIsGeneral(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsGeneral(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isGeneral of com.linkedin.dataplatform.slack.SlackConversation");
                }
                CheckedUtil.putWithoutChecking(this._map, "isGeneral", value);
                this._isGeneralField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsGeneral();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isGeneral", value);
                this._isGeneralField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isGeneral", value);
                this._isGeneralField = value;
            }
        }
        return this;
    }

    public SlackConversation setIsGeneral(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isGeneral of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isGeneral", value);
        this._isGeneralField = value;
        return this;
    }

    public SlackConversation setIsGeneral(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isGeneral", value);
        this._isGeneralField = value;
        return this;
    }

    public boolean hasContextTeamID() {
        if (this._contextTeamIDField != null) {
            return true;
        }
        return this._map.containsKey("contextTeamID");
    }

    public void removeContextTeamID() {
        this._map.remove("contextTeamID");
    }

    @Nullable
    public String getContextTeamID(GetMode mode) {
        return this.getContextTeamID();
    }

    @Nullable
    public String getContextTeamID() {
        if (this._contextTeamIDField != null) {
            return this._contextTeamIDField;
        }
        Object __rawValue = this._map.get("contextTeamID");
        this._contextTeamIDField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._contextTeamIDField;
    }

    public SlackConversation setContextTeamID(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContextTeamID(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContextTeamID();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "contextTeamID", value);
                this._contextTeamIDField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "contextTeamID", value);
                this._contextTeamIDField = value;
            }
        }
        return this;
    }

    public SlackConversation setContextTeamID(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field contextTeamID of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "contextTeamID", value);
        this._contextTeamIDField = value;
        return this;
    }

    public boolean hasPurpose() {
        if (this._purposeField != null) {
            return true;
        }
        return this._map.containsKey("purpose");
    }

    public void removePurpose() {
        this._map.remove("purpose");
    }

    @Nullable
    public String getPurpose(GetMode mode) {
        return this.getPurpose();
    }

    @Nullable
    public String getPurpose() {
        if (this._purposeField != null) {
            return this._purposeField;
        }
        Object __rawValue = this._map.get("purpose");
        this._purposeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._purposeField;
    }

    public SlackConversation setPurpose(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPurpose(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePurpose();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "purpose", value);
                this._purposeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "purpose", value);
                this._purposeField = value;
            }
        }
        return this;
    }

    public SlackConversation setPurpose(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field purpose of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "purpose", value);
        this._purposeField = value;
        return this;
    }

    public boolean hasTopic() {
        if (this._topicField != null) {
            return true;
        }
        return this._map.containsKey("topic");
    }

    public void removeTopic() {
        this._map.remove("topic");
    }

    @Nullable
    public String getTopic(GetMode mode) {
        return this.getTopic();
    }

    @Nullable
    public String getTopic() {
        if (this._topicField != null) {
            return this._topicField;
        }
        Object __rawValue = this._map.get("topic");
        this._topicField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._topicField;
    }

    public SlackConversation setTopic(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTopic(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTopic();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "topic", value);
                this._topicField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "topic", value);
                this._topicField = value;
            }
        }
        return this;
    }

    public SlackConversation setTopic(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field topic of com.linkedin.dataplatform.slack.SlackConversation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "topic", value);
        this._topicField = value;
        return this;
    }

    @Override
    public SlackConversation clone() throws CloneNotSupportedException {
        SlackConversation __clone = (SlackConversation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SlackConversation copy() throws CloneNotSupportedException {
        SlackConversation __copy = (SlackConversation)super.copy();
        __copy._isGeneralField = null;
        __copy._isChannelField = null;
        __copy._contextTeamIDField = null;
        __copy._purposeField = null;
        __copy._displayNameField = null;
        __copy._isArchivedField = null;
        __copy._topicField = null;
        __copy._isExtSharedField = null;
        __copy._idField = null;
        __copy._isPrivateField = null;
        __copy._isGroupField = null;
        __copy._isSharedField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SlackConversation __objectRef;

        private ChangeListener(SlackConversation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "isGeneral": {
                    this.__objectRef._isGeneralField = null;
                    break;
                }
                case "isChannel": {
                    this.__objectRef._isChannelField = null;
                    break;
                }
                case "contextTeamID": {
                    this.__objectRef._contextTeamIDField = null;
                    break;
                }
                case "purpose": {
                    this.__objectRef._purposeField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "isArchived": {
                    this.__objectRef._isArchivedField = null;
                    break;
                }
                case "topic": {
                    this.__objectRef._topicField = null;
                    break;
                }
                case "isExtShared": {
                    this.__objectRef._isExtSharedField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                    break;
                }
                case "isPrivate": {
                    this.__objectRef._isPrivateField = null;
                    break;
                }
                case "isGroup": {
                    this.__objectRef._isGroupField = null;
                    break;
                }
                case "isShared": {
                    this.__objectRef._isSharedField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec isChannel() {
            return new PathSpec(this.getPathComponents(), "isChannel");
        }

        public PathSpec isGroup() {
            return new PathSpec(this.getPathComponents(), "isGroup");
        }

        public PathSpec isPrivate() {
            return new PathSpec(this.getPathComponents(), "isPrivate");
        }

        public PathSpec isArchived() {
            return new PathSpec(this.getPathComponents(), "isArchived");
        }

        public PathSpec isShared() {
            return new PathSpec(this.getPathComponents(), "isShared");
        }

        public PathSpec isExtShared() {
            return new PathSpec(this.getPathComponents(), "isExtShared");
        }

        public PathSpec isGeneral() {
            return new PathSpec(this.getPathComponents(), "isGeneral");
        }

        public PathSpec contextTeamID() {
            return new PathSpec(this.getPathComponents(), "contextTeamID");
        }

        public PathSpec purpose() {
            return new PathSpec(this.getPathComponents(), "purpose");
        }

        public PathSpec topic() {
            return new PathSpec(this.getPathComponents(), "topic");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withIsChannel() {
            this.getDataMap().put("isChannel", 1);
            return this;
        }

        public ProjectionMask withIsGroup() {
            this.getDataMap().put("isGroup", 1);
            return this;
        }

        public ProjectionMask withIsPrivate() {
            this.getDataMap().put("isPrivate", 1);
            return this;
        }

        public ProjectionMask withIsArchived() {
            this.getDataMap().put("isArchived", 1);
            return this;
        }

        public ProjectionMask withIsShared() {
            this.getDataMap().put("isShared", 1);
            return this;
        }

        public ProjectionMask withIsExtShared() {
            this.getDataMap().put("isExtShared", 1);
            return this;
        }

        public ProjectionMask withIsGeneral() {
            this.getDataMap().put("isGeneral", 1);
            return this;
        }

        public ProjectionMask withContextTeamID() {
            this.getDataMap().put("contextTeamID", 1);
            return this;
        }

        public ProjectionMask withPurpose() {
            this.getDataMap().put("purpose", 1);
            return this;
        }

        public ProjectionMask withTopic() {
            this.getDataMap().put("topic", 1);
            return this;
        }
    }
}

