/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datacontract;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataQualityContract
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datacontract/**A data quality contract pertaining to a physical data asset\nData Quality contracts are used to make assertions about data quality metrics for a physical data asset*/record DataQualityContract{/**The assertion representing the Data Quality contract.\nE.g. a table or column-level assertion.*/@Relationship={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesDataQualityAssertion\"}assertion:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private Urn _assertionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Assertion = SCHEMA.getField("assertion");

    public DataQualityContract() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataQualityContract(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAssertion() {
        if (this._assertionField != null) {
            return true;
        }
        return this._map.containsKey("assertion");
    }

    public void removeAssertion() {
        this._map.remove("assertion");
    }

    @Nullable
    public Urn getAssertion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAssertion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._assertionField != null) {
                    return this._assertionField;
                }
                Object __rawValue = this._map.get("assertion");
                this._assertionField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._assertionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getAssertion() {
        if (this._assertionField != null) {
            return this._assertionField;
        }
        Object __rawValue = this._map.get("assertion");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("assertion");
        }
        this._assertionField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._assertionField;
    }

    public DataQualityContract setAssertion(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAssertion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field assertion of com.linkedin.datacontract.DataQualityContract");
                }
                CheckedUtil.putWithoutChecking(this._map, "assertion", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._assertionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAssertion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "assertion", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._assertionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "assertion", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._assertionField = value;
            }
        }
        return this;
    }

    public DataQualityContract setAssertion(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field assertion of com.linkedin.datacontract.DataQualityContract to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "assertion", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._assertionField = value;
        return this;
    }

    @Override
    public DataQualityContract clone() throws CloneNotSupportedException {
        DataQualityContract __clone = (DataQualityContract)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataQualityContract copy() throws CloneNotSupportedException {
        DataQualityContract __copy = (DataQualityContract)super.copy();
        __copy._assertionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataQualityContract __objectRef;

        private ChangeListener(DataQualityContract reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "assertion": {
                    this.__objectRef._assertionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec assertion() {
            return new PathSpec(this.getPathComponents(), "assertion");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withAssertion() {
            this.getDataMap().put("assertion", 1);
            return this;
        }
    }
}

