/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.it.AlwaysFalsePredicate;
import com.linkedin.data.it.AlwaysTruePredicate;
import com.linkedin.data.it.AndPredicate;
import com.linkedin.data.it.DataSchemaNameEqualsPredicate;
import com.linkedin.data.it.DataSchemaTypeEqualsPredicate;
import com.linkedin.data.it.HasChildWithNameValuePredicate;
import com.linkedin.data.it.NameEqualsPredicate;
import com.linkedin.data.it.NotPredicate;
import com.linkedin.data.it.OrPredicate;
import com.linkedin.data.it.ParentPredicate;
import com.linkedin.data.it.PathMatchesPatternPredicate;
import com.linkedin.data.it.Predicate;
import com.linkedin.data.it.ValueEqualsPredicate;
import com.linkedin.data.it.ValueInstanceOfPredicate;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PathSpec;
import java.util.Collection;

public class Predicates {
    private static final Predicate ALWAYS_TRUE = new AlwaysTruePredicate();
    private static final Predicate ALWAYS_FALSE = new AlwaysFalsePredicate();

    public static Predicate valueInstanceOf(Class<?> clazz) {
        return new ValueInstanceOfPredicate(clazz);
    }

    public static Predicate nameEquals(Object name) {
        return new NameEqualsPredicate(name);
    }

    public static Predicate valueEquals(Object value) {
        return new ValueEqualsPredicate(value);
    }

    public static Predicate dataSchemaTypeEquals(DataSchema.Type type) {
        return new DataSchemaTypeEqualsPredicate(type);
    }

    public static Predicate dataSchemaNameEquals(String fullName) {
        return new DataSchemaNameEqualsPredicate(fullName);
    }

    public static Predicate hasChildWithNameValue(Object name, Object value) {
        return new HasChildWithNameValuePredicate(name, value);
    }

    public static Predicate pathMatchesPattern(Object ... patterns) {
        return new PathMatchesPatternPredicate(patterns);
    }

    public static Predicate pathMatchesPathSpec(PathSpec pathSpec) {
        return new PathMatchesPatternPredicate(pathSpec);
    }

    public static Predicate and(Collection<? extends Predicate> predicates) {
        return new AndPredicate(predicates);
    }

    public static Predicate and(Predicate ... predicates) {
        return new AndPredicate(predicates);
    }

    public static Predicate or(Collection<? extends Predicate> predicates) {
        return new OrPredicate(predicates);
    }

    public static Predicate or(Predicate ... predicates) {
        return new OrPredicate(predicates);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate parent(Predicate predicate) {
        return new ParentPredicate(predicate);
    }

    public static Predicate alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static Predicate alwaysFalse() {
        return ALWAYS_FALSE;
    }
}

