/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.symbol;

import com.linkedin.data.codec.symbol.SymbolTableMetadata;

public class SymbolTableMetadataExtractor {
    protected static char SERVER_NODE_URI_PREFIX_TABLENAME_SEPARATOR = (char)124;

    public SymbolTableMetadata extractMetadata(String fullName) {
        int index = fullName.indexOf(SERVER_NODE_URI_PREFIX_TABLENAME_SEPARATOR);
        if (index == -1) {
            return new SymbolTableMetadata(null, fullName, false);
        }
        if (index == 0 || index == fullName.length() - 1) {
            throw new RuntimeException("Unexpected name format for name: " + fullName);
        }
        String serverNodeUri = fullName.substring(0, index);
        String tableName = fullName.substring(index + 1);
        return this.createMetadata(serverNodeUri, tableName);
    }

    protected SymbolTableMetadata createMetadata(String serverNodeUri, String tableName) {
        return new SymbolTableMetadata(serverNodeUri, tableName, true);
    }
}

