/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.AbstractJacksonDataCodec;
import com.linkedin.data.codec.entitystream.AbstractDataEncoder;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;

abstract class AbstractJacksonDataEncoder
extends AbstractDataEncoder {
    protected JsonFactory _jsonFactory;
    protected JsonGenerator _generator;

    protected AbstractJacksonDataEncoder(JsonFactory jsonFactory, DataMap dataMap, int bufferSize) {
        super(dataMap, bufferSize);
        this._jsonFactory = jsonFactory;
    }

    protected AbstractJacksonDataEncoder(JsonFactory jsonFactory, DataList dataList, int bufferSize) {
        super(dataList, bufferSize);
        this._jsonFactory = jsonFactory;
    }

    @Override
    protected Data.TraverseCallback createTraverseCallback(OutputStream out) throws IOException {
        this._generator = this._jsonFactory.createGenerator(out);
        return new JacksonStreamTraverseCallback(this._generator);
    }

    @Deprecated
    protected void writeStartObject() throws IOException {
        this._generator.writeStartObject();
    }

    @Deprecated
    protected void writeStartArray() throws IOException {
        this._generator.writeStartArray();
    }

    @Deprecated
    protected void writeFieldName(String name) throws IOException {
        this._generator.writeFieldName(name);
    }

    @Deprecated
    protected void writeEndObject() throws IOException {
        this._generator.writeEndObject();
    }

    @Deprecated
    protected void writeEndArray() throws IOException {
        this._generator.writeEndArray();
    }

    @Deprecated
    protected void writeByteString(ByteString value) throws IOException {
        char[] charArray = value.asAvroCharArray();
        this._generator.writeString(charArray, 0, charArray.length);
    }

    protected class JacksonStreamTraverseCallback
    extends AbstractJacksonDataCodec.JacksonTraverseCallback {
        protected JacksonStreamTraverseCallback(JsonGenerator generator) {
            super(generator);
        }

        @Override
        public void byteStringValue(ByteString value) throws IOException {
            AbstractJacksonDataEncoder.this.writeByteString(value);
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            AbstractJacksonDataEncoder.this.writeStartObject();
        }

        @Override
        public void key(String key) throws IOException {
            AbstractJacksonDataEncoder.this.writeFieldName(key);
        }

        @Override
        public void endMap() throws IOException {
            AbstractJacksonDataEncoder.this.writeEndObject();
        }

        @Override
        public void startList(DataList list) throws IOException {
            AbstractJacksonDataEncoder.this.writeStartArray();
        }

        @Override
        public void endList() throws IOException {
            AbstractJacksonDataEncoder.this.writeEndArray();
        }
    }
}

