/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DataMapBuilder
implements DataComplex {
    private List<Object> _dataMapContents = new ArrayList<Object>(20);
    private boolean _inUse;

    public void addKVPair(String field, Object value) {
        assert (this._inUse);
        this._dataMapContents.add(field);
        this._dataMapContents.add(value);
    }

    public boolean smallHashMapThresholdReached() {
        return this._dataMapContents.size() >= 12;
    }

    public DataMap convertToDataMap() {
        DataMap dataMap = new DataMap(this.optimumCapacityFromSize());
        for (int i = 0; i < this._dataMapContents.size(); i += 2) {
            dataMap.put((String)this._dataMapContents.get(i), this._dataMapContents.get(i + 1));
        }
        this._dataMapContents.clear();
        this._inUse = false;
        return dataMap;
    }

    public boolean inUse() {
        return this._inUse;
    }

    public void setInUse(boolean v) {
        this._inUse = v;
    }

    private int optimumCapacityFromSize() {
        return DataMapBuilder.getOptimumHashMapCapacityFromSize(this._dataMapContents.size() / 2);
    }

    public static int getOptimumHashMapCapacityFromSize(int size) {
        return size % 3 == 0 ? size * 4 / 3 : (int)((double)size / 0.75) + 1;
    }

    @Override
    public void makeReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMadeReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataComplex clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataComplex copy() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int dataComplexHashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startInstrumentingAccess() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopInstrumentingAccess() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearInstrumentedData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectInstrumentedData(StringBuilder keyPrefix, Map<String, Map<String, Object>> instrumentedData, boolean collectAllData) {
        throw new UnsupportedOperationException();
    }
}

