/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dashboard;

import com.linkedin.dashboard.DashboardUserUsageCountsArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DashboardUsageStatistics
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dashboard/**Experimental (Subject to breaking change) -- Stats corresponding to dashboard's usage.\n\nIf this aspect represents the latest snapshot of the statistics about a Dashboard, the eventGranularity field should be null. \nIf this aspect represents a bucketed window of usage statistics (e.g. over a day), then the eventGranularity field should be set accordingly. */@Aspect={\"name\":\"dashboardUsageStatistics\",\"type\":\"timeseries\"}record DashboardUsageStatistics includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**The total number of times dashboard has been viewed*/@TimeseriesField={}viewsCount:optional int/**The total number of dashboard executions (refreshes / syncs) */@TimeseriesField={}executionsCount:optional int/**Unique user count*/@TimeseriesField={}uniqueUserCount:optional int/**Users within this bucket, with frequency counts*/@TimeseriesFieldCollection.key=\"user\"userCounts:optional array[/**Records a single user's usage counts for a given resource*/record DashboardUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The number of times the user has viewed the dashboard*/@TimeseriesField={}viewsCount:optional int/**The number of times the user has executed (refreshed) the dashboard*/@TimeseriesField={}executionsCount:optional int/**Normalized numeric metric representing user's dashboard usage -- the number of times the user executed or viewed the dashboard. */@TimeseriesField={}usageCount:optional int/**If user_email is set, we attempt to resolve the user's urn upon ingest*/@TimeseriesField={}userEmail:optional string}]/**The total number of times that the dashboard has been favorited */@TimeseriesField={}favoritesCount:optional int/**Last viewed at\n\nThis should not be set in cases where statistics are windowed. */@TimeseriesField={}lastViewedAt:optional long}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private Integer _viewsCountField = null;
    private Integer _executionsCountField = null;
    private Integer _uniqueUserCountField = null;
    private DashboardUserUsageCountsArray _userCountsField = null;
    private Integer _favoritesCountField = null;
    private Long _lastViewedAtField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_ViewsCount;
    private static final RecordDataSchema.Field FIELD_ExecutionsCount;
    private static final RecordDataSchema.Field FIELD_UniqueUserCount;
    private static final RecordDataSchema.Field FIELD_UserCounts;
    private static final RecordDataSchema.Field FIELD_FavoritesCount;
    private static final RecordDataSchema.Field FIELD_LastViewedAt;

    public DashboardUsageStatistics() {
        super(new DataMap(14, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DashboardUsageStatistics(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public DashboardUsageStatistics setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.dashboard.DashboardUsageStatistics");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public DashboardUsageStatistics setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public DashboardUsageStatistics setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public DashboardUsageStatistics setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public DashboardUsageStatistics setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasViewsCount() {
        if (this._viewsCountField != null) {
            return true;
        }
        return this._map.containsKey("viewsCount");
    }

    public void removeViewsCount() {
        this._map.remove("viewsCount");
    }

    @Nullable
    public Integer getViewsCount(GetMode mode) {
        return this.getViewsCount();
    }

    @Nullable
    public Integer getViewsCount() {
        if (this._viewsCountField != null) {
            return this._viewsCountField;
        }
        Object __rawValue = this._map.get("viewsCount");
        this._viewsCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._viewsCountField;
    }

    public DashboardUsageStatistics setViewsCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViewsCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViewsCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
                this._viewsCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
                this._viewsCountField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setViewsCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field viewsCount of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
        this._viewsCountField = value;
        return this;
    }

    public DashboardUsageStatistics setViewsCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
        this._viewsCountField = value;
        return this;
    }

    public boolean hasExecutionsCount() {
        if (this._executionsCountField != null) {
            return true;
        }
        return this._map.containsKey("executionsCount");
    }

    public void removeExecutionsCount() {
        this._map.remove("executionsCount");
    }

    @Nullable
    public Integer getExecutionsCount(GetMode mode) {
        return this.getExecutionsCount();
    }

    @Nullable
    public Integer getExecutionsCount() {
        if (this._executionsCountField != null) {
            return this._executionsCountField;
        }
        Object __rawValue = this._map.get("executionsCount");
        this._executionsCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._executionsCountField;
    }

    public DashboardUsageStatistics setExecutionsCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExecutionsCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExecutionsCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
                this._executionsCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
                this._executionsCountField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setExecutionsCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field executionsCount of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
        this._executionsCountField = value;
        return this;
    }

    public DashboardUsageStatistics setExecutionsCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
        this._executionsCountField = value;
        return this;
    }

    public boolean hasUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return true;
        }
        return this._map.containsKey("uniqueUserCount");
    }

    public void removeUniqueUserCount() {
        this._map.remove("uniqueUserCount");
    }

    @Nullable
    public Integer getUniqueUserCount(GetMode mode) {
        return this.getUniqueUserCount();
    }

    @Nullable
    public Integer getUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return this._uniqueUserCountField;
        }
        Object __rawValue = this._map.get("uniqueUserCount");
        this._uniqueUserCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._uniqueUserCountField;
    }

    public DashboardUsageStatistics setUniqueUserCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUniqueUserCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUniqueUserCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setUniqueUserCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uniqueUserCount of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public DashboardUsageStatistics setUniqueUserCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public boolean hasUserCounts() {
        if (this._userCountsField != null) {
            return true;
        }
        return this._map.containsKey("userCounts");
    }

    public void removeUserCounts() {
        this._map.remove("userCounts");
    }

    @Nullable
    public DashboardUserUsageCountsArray getUserCounts(GetMode mode) {
        return this.getUserCounts();
    }

    @Nullable
    public DashboardUserUsageCountsArray getUserCounts() {
        if (this._userCountsField != null) {
            return this._userCountsField;
        }
        Object __rawValue = this._map.get("userCounts");
        this._userCountsField = __rawValue == null ? null : new DashboardUserUsageCountsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._userCountsField;
    }

    public DashboardUsageStatistics setUserCounts(@Nullable DashboardUserUsageCountsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserCounts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserCounts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
                this._userCountsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
                this._userCountsField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setUserCounts(@Nonnull DashboardUserUsageCountsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userCounts of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
        this._userCountsField = value;
        return this;
    }

    public boolean hasFavoritesCount() {
        if (this._favoritesCountField != null) {
            return true;
        }
        return this._map.containsKey("favoritesCount");
    }

    public void removeFavoritesCount() {
        this._map.remove("favoritesCount");
    }

    @Nullable
    public Integer getFavoritesCount(GetMode mode) {
        return this.getFavoritesCount();
    }

    @Nullable
    public Integer getFavoritesCount() {
        if (this._favoritesCountField != null) {
            return this._favoritesCountField;
        }
        Object __rawValue = this._map.get("favoritesCount");
        this._favoritesCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._favoritesCountField;
    }

    public DashboardUsageStatistics setFavoritesCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFavoritesCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFavoritesCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "favoritesCount", DataTemplateUtil.coerceIntInput(value));
                this._favoritesCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "favoritesCount", DataTemplateUtil.coerceIntInput(value));
                this._favoritesCountField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setFavoritesCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field favoritesCount of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "favoritesCount", DataTemplateUtil.coerceIntInput(value));
        this._favoritesCountField = value;
        return this;
    }

    public DashboardUsageStatistics setFavoritesCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "favoritesCount", DataTemplateUtil.coerceIntInput(value));
        this._favoritesCountField = value;
        return this;
    }

    public boolean hasLastViewedAt() {
        if (this._lastViewedAtField != null) {
            return true;
        }
        return this._map.containsKey("lastViewedAt");
    }

    public void removeLastViewedAt() {
        this._map.remove("lastViewedAt");
    }

    @Nullable
    public Long getLastViewedAt(GetMode mode) {
        return this.getLastViewedAt();
    }

    @Nullable
    public Long getLastViewedAt() {
        if (this._lastViewedAtField != null) {
            return this._lastViewedAtField;
        }
        Object __rawValue = this._map.get("lastViewedAt");
        this._lastViewedAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastViewedAtField;
    }

    public DashboardUsageStatistics setLastViewedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastViewedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastViewedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastViewedAt", DataTemplateUtil.coerceLongInput(value));
                this._lastViewedAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastViewedAt", DataTemplateUtil.coerceLongInput(value));
                this._lastViewedAtField = value;
            }
        }
        return this;
    }

    public DashboardUsageStatistics setLastViewedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastViewedAt of com.linkedin.dashboard.DashboardUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastViewedAt", DataTemplateUtil.coerceLongInput(value));
        this._lastViewedAtField = value;
        return this;
    }

    public DashboardUsageStatistics setLastViewedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastViewedAt", DataTemplateUtil.coerceLongInput(value));
        this._lastViewedAtField = value;
        return this;
    }

    @Override
    public DashboardUsageStatistics clone() throws CloneNotSupportedException {
        DashboardUsageStatistics __clone = (DashboardUsageStatistics)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DashboardUsageStatistics copy() throws CloneNotSupportedException {
        DashboardUsageStatistics __copy = (DashboardUsageStatistics)super.copy();
        __copy._timestampMillisField = null;
        __copy._viewsCountField = null;
        __copy._executionsCountField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._userCountsField = null;
        __copy._favoritesCountField = null;
        __copy._partitionSpecField = null;
        __copy._uniqueUserCountField = null;
        __copy._lastViewedAtField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_ViewsCount = SCHEMA.getField("viewsCount");
        FIELD_ExecutionsCount = SCHEMA.getField("executionsCount");
        FIELD_UniqueUserCount = SCHEMA.getField("uniqueUserCount");
        FIELD_UserCounts = SCHEMA.getField("userCounts");
        FIELD_FavoritesCount = SCHEMA.getField("favoritesCount");
        FIELD_LastViewedAt = SCHEMA.getField("lastViewedAt");
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DashboardUsageStatistics __objectRef;

        private ChangeListener(DashboardUsageStatistics reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "viewsCount": {
                    this.__objectRef._viewsCountField = null;
                    break;
                }
                case "executionsCount": {
                    this.__objectRef._executionsCountField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "userCounts": {
                    this.__objectRef._userCountsField = null;
                    break;
                }
                case "favoritesCount": {
                    this.__objectRef._favoritesCountField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "uniqueUserCount": {
                    this.__objectRef._uniqueUserCountField = null;
                    break;
                }
                case "lastViewedAt": {
                    this.__objectRef._lastViewedAtField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec viewsCount() {
            return new PathSpec(this.getPathComponents(), "viewsCount");
        }

        public PathSpec executionsCount() {
            return new PathSpec(this.getPathComponents(), "executionsCount");
        }

        public PathSpec uniqueUserCount() {
            return new PathSpec(this.getPathComponents(), "uniqueUserCount");
        }

        public DashboardUserUsageCountsArray.Fields userCounts() {
            return new DashboardUserUsageCountsArray.Fields(this.getPathComponents(), "userCounts");
        }

        public PathSpec userCounts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "userCounts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec favoritesCount() {
            return new PathSpec(this.getPathComponents(), "favoritesCount");
        }

        public PathSpec lastViewedAt() {
            return new PathSpec(this.getPathComponents(), "lastViewedAt");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;
        private DashboardUserUsageCountsArray.ProjectionMask _userCountsMask;

        ProjectionMask() {
            super(14);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withViewsCount() {
            this.getDataMap().put("viewsCount", 1);
            return this;
        }

        public ProjectionMask withExecutionsCount() {
            this.getDataMap().put("executionsCount", 1);
            return this;
        }

        public ProjectionMask withUniqueUserCount() {
            this.getDataMap().put("uniqueUserCount", 1);
            return this;
        }

        public ProjectionMask withUserCounts(Function<DashboardUserUsageCountsArray.ProjectionMask, DashboardUserUsageCountsArray.ProjectionMask> nestedMask) {
            this._userCountsMask = nestedMask.apply(this._userCountsMask == null ? DashboardUserUsageCountsArray.createMask() : this._userCountsMask);
            this.getDataMap().put("userCounts", this._userCountsMask.getDataMap());
            return this;
        }

        public ProjectionMask withUserCounts() {
            this._userCountsMask = null;
            this.getDataMap().put("userCounts", 1);
            return this;
        }

        public ProjectionMask withUserCounts(Function<DashboardUserUsageCountsArray.ProjectionMask, DashboardUserUsageCountsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._userCountsMask = nestedMask.apply(this._userCountsMask == null ? DashboardUserUsageCountsArray.createMask() : this._userCountsMask);
            this.getDataMap().put("userCounts", this._userCountsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("userCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("userCounts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUserCounts(Integer start, Integer count) {
            this._userCountsMask = null;
            this.getDataMap().put("userCounts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("userCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("userCounts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFavoritesCount() {
            this.getDataMap().put("favoritesCount", 1);
            return this;
        }

        public ProjectionMask withLastViewedAt() {
            this.getDataMap().put("lastViewedAt", 1);
            return this;
        }
    }
}

