/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.SerializedValueContentType;
import com.linkedin.common.SerializedValueSchemaType;
import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SerializedValue
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Captures the serialized value of a (usually) schema-d blob.*/record SerializedValue{/**The serialized blob value.*/blob:bytes/**The content-type of the serialized blob value.*/contentType:enum SerializedValueContentType{JSON,BINARY}=\"JSON\"/**The schema type for the schema that models the object that was serialized\n       into the blob.\nAbsence of this field indicates that the schema is not known.\nIf the schema is known, the value should be set to the appropriate schema\ntype.\nUse the NONE value if the existing schema categories do not apply.*/schemaType:optional enum SerializedValueSchemaType{AVRO,PROTOBUF,PEGASUS,THRIFT,JSON,NONE}/**An optional reference to the schema that models the object.\ne.g., 'com.linkedin.platformresource.slack.SlackConversation'*/schemaRef:optional string}", SchemaFormatType.PDL);
    private ByteString _blobField = null;
    private SerializedValueContentType _contentTypeField = null;
    private SerializedValueSchemaType _schemaTypeField = null;
    private String _schemaRefField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Blob = SCHEMA.getField("blob");
    private static final RecordDataSchema.Field FIELD_ContentType = SCHEMA.getField("contentType");
    private static final SerializedValueContentType DEFAULT_ContentType;
    private static final RecordDataSchema.Field FIELD_SchemaType;
    private static final RecordDataSchema.Field FIELD_SchemaRef;

    public SerializedValue() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SerializedValue(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBlob() {
        if (this._blobField != null) {
            return true;
        }
        return this._map.containsKey("blob");
    }

    public void removeBlob() {
        this._map.remove("blob");
    }

    @Nullable
    public ByteString getBlob(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getBlob();
            }
            case DEFAULT: 
            case NULL: {
                if (this._blobField != null) {
                    return this._blobField;
                }
                Object __rawValue = this._map.get("blob");
                this._blobField = DataTemplateUtil.coerceBytesOutput(__rawValue);
                return this._blobField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ByteString getBlob() {
        if (this._blobField != null) {
            return this._blobField;
        }
        Object __rawValue = this._map.get("blob");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("blob");
        }
        this._blobField = DataTemplateUtil.coerceBytesOutput(__rawValue);
        return this._blobField;
    }

    public SerializedValue setBlob(@Nullable ByteString value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBlob(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field blob of com.linkedin.common.SerializedValue");
                }
                CheckedUtil.putWithoutChecking(this._map, "blob", value);
                this._blobField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBlob();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "blob", value);
                this._blobField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "blob", value);
                this._blobField = value;
            }
        }
        return this;
    }

    public SerializedValue setBlob(@Nonnull ByteString value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field blob of com.linkedin.common.SerializedValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "blob", value);
        this._blobField = value;
        return this;
    }

    public boolean hasContentType() {
        if (this._contentTypeField != null) {
            return true;
        }
        return this._map.containsKey("contentType");
    }

    public void removeContentType() {
        this._map.remove("contentType");
    }

    @Nullable
    public SerializedValueContentType getContentType(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getContentType();
            }
            case NULL: {
                if (this._contentTypeField != null) {
                    return this._contentTypeField;
                }
                Object __rawValue = this._map.get("contentType");
                this._contentTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SerializedValueContentType.class, SerializedValueContentType.$UNKNOWN);
                return this._contentTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SerializedValueContentType getContentType() {
        if (this._contentTypeField != null) {
            return this._contentTypeField;
        }
        Object __rawValue = this._map.get("contentType");
        if (__rawValue == null) {
            return DEFAULT_ContentType;
        }
        this._contentTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SerializedValueContentType.class, SerializedValueContentType.$UNKNOWN);
        return this._contentTypeField;
    }

    public SerializedValue setContentType(@Nullable SerializedValueContentType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContentType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field contentType of com.linkedin.common.SerializedValue");
                }
                CheckedUtil.putWithoutChecking(this._map, "contentType", value.name());
                this._contentTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContentType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "contentType", value.name());
                this._contentTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "contentType", value.name());
                this._contentTypeField = value;
            }
        }
        return this;
    }

    public SerializedValue setContentType(@Nonnull SerializedValueContentType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field contentType of com.linkedin.common.SerializedValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "contentType", value.name());
        this._contentTypeField = value;
        return this;
    }

    public boolean hasSchemaType() {
        if (this._schemaTypeField != null) {
            return true;
        }
        return this._map.containsKey("schemaType");
    }

    public void removeSchemaType() {
        this._map.remove("schemaType");
    }

    @Nullable
    public SerializedValueSchemaType getSchemaType(GetMode mode) {
        return this.getSchemaType();
    }

    @Nullable
    public SerializedValueSchemaType getSchemaType() {
        if (this._schemaTypeField != null) {
            return this._schemaTypeField;
        }
        Object __rawValue = this._map.get("schemaType");
        this._schemaTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SerializedValueSchemaType.class, SerializedValueSchemaType.$UNKNOWN);
        return this._schemaTypeField;
    }

    public SerializedValue setSchemaType(@Nullable SerializedValueSchemaType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchemaType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchemaType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaType", value.name());
                this._schemaTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schemaType", value.name());
                this._schemaTypeField = value;
            }
        }
        return this;
    }

    public SerializedValue setSchemaType(@Nonnull SerializedValueSchemaType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schemaType of com.linkedin.common.SerializedValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schemaType", value.name());
        this._schemaTypeField = value;
        return this;
    }

    public boolean hasSchemaRef() {
        if (this._schemaRefField != null) {
            return true;
        }
        return this._map.containsKey("schemaRef");
    }

    public void removeSchemaRef() {
        this._map.remove("schemaRef");
    }

    @Nullable
    public String getSchemaRef(GetMode mode) {
        return this.getSchemaRef();
    }

    @Nullable
    public String getSchemaRef() {
        if (this._schemaRefField != null) {
            return this._schemaRefField;
        }
        Object __rawValue = this._map.get("schemaRef");
        this._schemaRefField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._schemaRefField;
    }

    public SerializedValue setSchemaRef(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchemaRef(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchemaRef();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaRef", value);
                this._schemaRefField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schemaRef", value);
                this._schemaRefField = value;
            }
        }
        return this;
    }

    public SerializedValue setSchemaRef(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schemaRef of com.linkedin.common.SerializedValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schemaRef", value);
        this._schemaRefField = value;
        return this;
    }

    @Override
    public SerializedValue clone() throws CloneNotSupportedException {
        SerializedValue __clone = (SerializedValue)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SerializedValue copy() throws CloneNotSupportedException {
        SerializedValue __copy = (SerializedValue)super.copy();
        __copy._blobField = null;
        __copy._schemaRefField = null;
        __copy._schemaTypeField = null;
        __copy._contentTypeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_SchemaType = SCHEMA.getField("schemaType");
        FIELD_SchemaRef = SCHEMA.getField("schemaRef");
        DEFAULT_ContentType = DataTemplateUtil.coerceEnumOutput(FIELD_ContentType.getDefault(), SerializedValueContentType.class, SerializedValueContentType.$UNKNOWN);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SerializedValue __objectRef;

        private ChangeListener(SerializedValue reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "blob": {
                    this.__objectRef._blobField = null;
                    break;
                }
                case "schemaRef": {
                    this.__objectRef._schemaRefField = null;
                    break;
                }
                case "schemaType": {
                    this.__objectRef._schemaTypeField = null;
                    break;
                }
                case "contentType": {
                    this.__objectRef._contentTypeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec blob() {
            return new PathSpec(this.getPathComponents(), "blob");
        }

        public PathSpec contentType() {
            return new PathSpec(this.getPathComponents(), "contentType");
        }

        public PathSpec schemaType() {
            return new PathSpec(this.getPathComponents(), "schemaType");
        }

        public PathSpec schemaRef() {
            return new PathSpec(this.getPathComponents(), "schemaRef");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withBlob() {
            this.getDataMap().put("blob", 1);
            return this;
        }

        public ProjectionMask withContentType() {
            this.getDataMap().put("contentType", 1);
            return this;
        }

        public ProjectionMask withSchemaType() {
            this.getDataMap().put("schemaType", 1);
            return this;
        }

        public ProjectionMask withSchemaRef() {
            this.getDataMap().put("schemaRef", 1);
            return this;
        }
    }
}

