/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.IncidentSummaryDetailsArray;
import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentsSummary
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Summary related incidents on an entity.*/@Aspect.name=\"incidentsSummary\"record IncidentsSummary{/**Resolved incidents for an asset\nDeprecated! Use the richer resolvedIncidentsDetails instead.*/@deprecated,resolvedIncidents:array[@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string]=[]/**Active incidents for an asset\nDeprecated! Use the richer activeIncidentsDetails instead.*/@deprecated,activeIncidents:array[Urn]=[]/**Summary details about the set of resolved incidents*/@Relationship.`/*/urn`={\"entityTypes\":[\"incident\"],\"name\":\"ResolvedIncidents\"}@Searchable={\"/*/createdAt\":{\"fieldName\":\"resolvedIncidentCreatedTimes\",\"fieldType\":\"DATETIME\"},\"/*/priority\":{\"fieldName\":\"resolvedIncidentPriorities\",\"fieldType\":\"COUNT\"},\"/*/resolvedAt\":{\"fieldName\":\"resolvedIncidentResolvedTimes\",\"fieldType\":\"DATETIME\"},\"/*/type\":{\"fieldName\":\"resolvedIncidentTypes\",\"fieldType\":\"KEYWORD\"},\"/*/urn\":{\"fieldName\":\"resolvedIncidents\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasResolvedIncidents\",\"numValuesFieldName\":\"numResolvedIncidents\",\"queryByDefault\":false}}resolvedIncidentDetails:array[/**Summary statistics about incidents on an entity.*/record IncidentSummaryDetails{/**The urn of the incident*/urn:Urn/**The type of an incident*/type:string/**The time at which the incident was raised in milliseconds since epoch.*/createdAt:long/**The time at which the incident was marked as resolved in milliseconds since epoch. Null if the incident is still active.*/resolvedAt:optional long/**The priority of the incident*/priority:optional int}]=[]/**Summary details about the set of active incidents*/@Relationship.`/*/urn`={\"entityTypes\":[\"incident\"],\"name\":\"ActiveIncidents\"}@Searchable={\"/*/createdAt\":{\"fieldName\":\"activeIncidentCreatedTimes\",\"fieldType\":\"DATETIME\"},\"/*/priority\":{\"fieldName\":\"activeIncidentPriorities\",\"fieldType\":\"COUNT\"},\"/*/type\":{\"fieldName\":\"activeIncidentTypes\",\"fieldType\":\"KEYWORD\"},\"/*/urn\":{\"addHasValuesToFilters\":true,\"fieldName\":\"activeIncidents\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasActiveIncidents\",\"numValuesFieldName\":\"numActiveIncidents\",\"queryByDefault\":false}}activeIncidentDetails:array[IncidentSummaryDetails]=[]}", SchemaFormatType.PDL);
    private UrnArray _resolvedIncidentsField = null;
    private UrnArray _activeIncidentsField = null;
    private IncidentSummaryDetailsArray _resolvedIncidentDetailsField = null;
    private IncidentSummaryDetailsArray _activeIncidentDetailsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ResolvedIncidents = SCHEMA.getField("resolvedIncidents");
    private static final UrnArray DEFAULT_ResolvedIncidents;
    private static final RecordDataSchema.Field FIELD_ActiveIncidents;
    private static final UrnArray DEFAULT_ActiveIncidents;
    private static final RecordDataSchema.Field FIELD_ResolvedIncidentDetails;
    private static final IncidentSummaryDetailsArray DEFAULT_ResolvedIncidentDetails;
    private static final RecordDataSchema.Field FIELD_ActiveIncidentDetails;
    private static final IncidentSummaryDetailsArray DEFAULT_ActiveIncidentDetails;

    public IncidentsSummary() {
        super(new DataMap(6, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public IncidentsSummary(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    @Deprecated
    public boolean hasResolvedIncidents() {
        if (this._resolvedIncidentsField != null) {
            return true;
        }
        return this._map.containsKey("resolvedIncidents");
    }

    @Deprecated
    public void removeResolvedIncidents() {
        this._map.remove("resolvedIncidents");
    }

    @Deprecated
    @Nullable
    public UrnArray getResolvedIncidents(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getResolvedIncidents();
            }
            case NULL: {
                if (this._resolvedIncidentsField != null) {
                    return this._resolvedIncidentsField;
                }
                Object __rawValue = this._map.get("resolvedIncidents");
                this._resolvedIncidentsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._resolvedIncidentsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public UrnArray getResolvedIncidents() {
        if (this._resolvedIncidentsField != null) {
            return this._resolvedIncidentsField;
        }
        Object __rawValue = this._map.get("resolvedIncidents");
        if (__rawValue == null) {
            return DEFAULT_ResolvedIncidents;
        }
        this._resolvedIncidentsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._resolvedIncidentsField;
    }

    @Deprecated
    public IncidentsSummary setResolvedIncidents(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResolvedIncidents(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field resolvedIncidents of com.linkedin.common.IncidentsSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "resolvedIncidents", value.data());
                this._resolvedIncidentsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResolvedIncidents();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resolvedIncidents", value.data());
                this._resolvedIncidentsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resolvedIncidents", value.data());
                this._resolvedIncidentsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public IncidentsSummary setResolvedIncidents(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resolvedIncidents of com.linkedin.common.IncidentsSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resolvedIncidents", value.data());
        this._resolvedIncidentsField = value;
        return this;
    }

    @Deprecated
    public boolean hasActiveIncidents() {
        if (this._activeIncidentsField != null) {
            return true;
        }
        return this._map.containsKey("activeIncidents");
    }

    @Deprecated
    public void removeActiveIncidents() {
        this._map.remove("activeIncidents");
    }

    @Deprecated
    @Nullable
    public UrnArray getActiveIncidents(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getActiveIncidents();
            }
            case NULL: {
                if (this._activeIncidentsField != null) {
                    return this._activeIncidentsField;
                }
                Object __rawValue = this._map.get("activeIncidents");
                this._activeIncidentsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._activeIncidentsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public UrnArray getActiveIncidents() {
        if (this._activeIncidentsField != null) {
            return this._activeIncidentsField;
        }
        Object __rawValue = this._map.get("activeIncidents");
        if (__rawValue == null) {
            return DEFAULT_ActiveIncidents;
        }
        this._activeIncidentsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._activeIncidentsField;
    }

    @Deprecated
    public IncidentsSummary setActiveIncidents(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActiveIncidents(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field activeIncidents of com.linkedin.common.IncidentsSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "activeIncidents", value.data());
                this._activeIncidentsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActiveIncidents();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "activeIncidents", value.data());
                this._activeIncidentsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "activeIncidents", value.data());
                this._activeIncidentsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public IncidentsSummary setActiveIncidents(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field activeIncidents of com.linkedin.common.IncidentsSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "activeIncidents", value.data());
        this._activeIncidentsField = value;
        return this;
    }

    public boolean hasResolvedIncidentDetails() {
        if (this._resolvedIncidentDetailsField != null) {
            return true;
        }
        return this._map.containsKey("resolvedIncidentDetails");
    }

    public void removeResolvedIncidentDetails() {
        this._map.remove("resolvedIncidentDetails");
    }

    @Nullable
    public IncidentSummaryDetailsArray getResolvedIncidentDetails(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getResolvedIncidentDetails();
            }
            case NULL: {
                if (this._resolvedIncidentDetailsField != null) {
                    return this._resolvedIncidentDetailsField;
                }
                Object __rawValue = this._map.get("resolvedIncidentDetails");
                this._resolvedIncidentDetailsField = __rawValue == null ? null : new IncidentSummaryDetailsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._resolvedIncidentDetailsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncidentSummaryDetailsArray getResolvedIncidentDetails() {
        if (this._resolvedIncidentDetailsField != null) {
            return this._resolvedIncidentDetailsField;
        }
        Object __rawValue = this._map.get("resolvedIncidentDetails");
        if (__rawValue == null) {
            return DEFAULT_ResolvedIncidentDetails;
        }
        this._resolvedIncidentDetailsField = __rawValue == null ? null : new IncidentSummaryDetailsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._resolvedIncidentDetailsField;
    }

    public IncidentsSummary setResolvedIncidentDetails(@Nullable IncidentSummaryDetailsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResolvedIncidentDetails(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field resolvedIncidentDetails of com.linkedin.common.IncidentsSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "resolvedIncidentDetails", value.data());
                this._resolvedIncidentDetailsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResolvedIncidentDetails();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resolvedIncidentDetails", value.data());
                this._resolvedIncidentDetailsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resolvedIncidentDetails", value.data());
                this._resolvedIncidentDetailsField = value;
            }
        }
        return this;
    }

    public IncidentsSummary setResolvedIncidentDetails(@Nonnull IncidentSummaryDetailsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resolvedIncidentDetails of com.linkedin.common.IncidentsSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resolvedIncidentDetails", value.data());
        this._resolvedIncidentDetailsField = value;
        return this;
    }

    public boolean hasActiveIncidentDetails() {
        if (this._activeIncidentDetailsField != null) {
            return true;
        }
        return this._map.containsKey("activeIncidentDetails");
    }

    public void removeActiveIncidentDetails() {
        this._map.remove("activeIncidentDetails");
    }

    @Nullable
    public IncidentSummaryDetailsArray getActiveIncidentDetails(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getActiveIncidentDetails();
            }
            case NULL: {
                if (this._activeIncidentDetailsField != null) {
                    return this._activeIncidentDetailsField;
                }
                Object __rawValue = this._map.get("activeIncidentDetails");
                this._activeIncidentDetailsField = __rawValue == null ? null : new IncidentSummaryDetailsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._activeIncidentDetailsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncidentSummaryDetailsArray getActiveIncidentDetails() {
        if (this._activeIncidentDetailsField != null) {
            return this._activeIncidentDetailsField;
        }
        Object __rawValue = this._map.get("activeIncidentDetails");
        if (__rawValue == null) {
            return DEFAULT_ActiveIncidentDetails;
        }
        this._activeIncidentDetailsField = __rawValue == null ? null : new IncidentSummaryDetailsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._activeIncidentDetailsField;
    }

    public IncidentsSummary setActiveIncidentDetails(@Nullable IncidentSummaryDetailsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActiveIncidentDetails(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field activeIncidentDetails of com.linkedin.common.IncidentsSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "activeIncidentDetails", value.data());
                this._activeIncidentDetailsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActiveIncidentDetails();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "activeIncidentDetails", value.data());
                this._activeIncidentDetailsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "activeIncidentDetails", value.data());
                this._activeIncidentDetailsField = value;
            }
        }
        return this;
    }

    public IncidentsSummary setActiveIncidentDetails(@Nonnull IncidentSummaryDetailsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field activeIncidentDetails of com.linkedin.common.IncidentsSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "activeIncidentDetails", value.data());
        this._activeIncidentDetailsField = value;
        return this;
    }

    @Override
    public IncidentsSummary clone() throws CloneNotSupportedException {
        IncidentsSummary __clone = (IncidentsSummary)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncidentsSummary copy() throws CloneNotSupportedException {
        IncidentsSummary __copy = (IncidentsSummary)super.copy();
        __copy._resolvedIncidentsField = null;
        __copy._activeIncidentsField = null;
        __copy._resolvedIncidentDetailsField = null;
        __copy._activeIncidentDetailsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ActiveIncidents = SCHEMA.getField("activeIncidents");
        FIELD_ResolvedIncidentDetails = SCHEMA.getField("resolvedIncidentDetails");
        FIELD_ActiveIncidentDetails = SCHEMA.getField("activeIncidentDetails");
        DEFAULT_ResolvedIncidents = FIELD_ResolvedIncidents.getDefault() == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(FIELD_ResolvedIncidents.getDefault(), DataList.class));
        DEFAULT_ActiveIncidents = FIELD_ActiveIncidents.getDefault() == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(FIELD_ActiveIncidents.getDefault(), DataList.class));
        DEFAULT_ResolvedIncidentDetails = FIELD_ResolvedIncidentDetails.getDefault() == null ? null : new IncidentSummaryDetailsArray(DataTemplateUtil.castOrThrow(FIELD_ResolvedIncidentDetails.getDefault(), DataList.class));
        DEFAULT_ActiveIncidentDetails = FIELD_ActiveIncidentDetails.getDefault() == null ? null : new IncidentSummaryDetailsArray(DataTemplateUtil.castOrThrow(FIELD_ActiveIncidentDetails.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncidentsSummary __objectRef;

        private ChangeListener(IncidentsSummary reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "resolvedIncidents": {
                    this.__objectRef._resolvedIncidentsField = null;
                    break;
                }
                case "activeIncidents": {
                    this.__objectRef._activeIncidentsField = null;
                    break;
                }
                case "resolvedIncidentDetails": {
                    this.__objectRef._resolvedIncidentDetailsField = null;
                    break;
                }
                case "activeIncidentDetails": {
                    this.__objectRef._activeIncidentDetailsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        @Deprecated
        public PathSpec resolvedIncidents() {
            return new PathSpec(this.getPathComponents(), "resolvedIncidents");
        }

        @Deprecated
        public PathSpec resolvedIncidents(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "resolvedIncidents");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec activeIncidents() {
            return new PathSpec(this.getPathComponents(), "activeIncidents");
        }

        @Deprecated
        public PathSpec activeIncidents(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "activeIncidents");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public IncidentSummaryDetailsArray.Fields resolvedIncidentDetails() {
            return new IncidentSummaryDetailsArray.Fields(this.getPathComponents(), "resolvedIncidentDetails");
        }

        public PathSpec resolvedIncidentDetails(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "resolvedIncidentDetails");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public IncidentSummaryDetailsArray.Fields activeIncidentDetails() {
            return new IncidentSummaryDetailsArray.Fields(this.getPathComponents(), "activeIncidentDetails");
        }

        public PathSpec activeIncidentDetails(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "activeIncidentDetails");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private IncidentSummaryDetailsArray.ProjectionMask _resolvedIncidentDetailsMask;
        private IncidentSummaryDetailsArray.ProjectionMask _activeIncidentDetailsMask;

        ProjectionMask() {
            super(6);
        }

        @Deprecated
        public ProjectionMask withResolvedIncidents() {
            this.getDataMap().put("resolvedIncidents", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withResolvedIncidents(Integer start, Integer count) {
            this.getDataMap().put("resolvedIncidents", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("resolvedIncidents").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("resolvedIncidents").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withActiveIncidents() {
            this.getDataMap().put("activeIncidents", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withActiveIncidents(Integer start, Integer count) {
            this.getDataMap().put("activeIncidents", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("activeIncidents").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("activeIncidents").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withResolvedIncidentDetails(Function<IncidentSummaryDetailsArray.ProjectionMask, IncidentSummaryDetailsArray.ProjectionMask> nestedMask) {
            this._resolvedIncidentDetailsMask = nestedMask.apply(this._resolvedIncidentDetailsMask == null ? IncidentSummaryDetailsArray.createMask() : this._resolvedIncidentDetailsMask);
            this.getDataMap().put("resolvedIncidentDetails", this._resolvedIncidentDetailsMask.getDataMap());
            return this;
        }

        public ProjectionMask withResolvedIncidentDetails() {
            this._resolvedIncidentDetailsMask = null;
            this.getDataMap().put("resolvedIncidentDetails", 1);
            return this;
        }

        public ProjectionMask withResolvedIncidentDetails(Function<IncidentSummaryDetailsArray.ProjectionMask, IncidentSummaryDetailsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._resolvedIncidentDetailsMask = nestedMask.apply(this._resolvedIncidentDetailsMask == null ? IncidentSummaryDetailsArray.createMask() : this._resolvedIncidentDetailsMask);
            this.getDataMap().put("resolvedIncidentDetails", this._resolvedIncidentDetailsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("resolvedIncidentDetails").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("resolvedIncidentDetails").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withResolvedIncidentDetails(Integer start, Integer count) {
            this._resolvedIncidentDetailsMask = null;
            this.getDataMap().put("resolvedIncidentDetails", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("resolvedIncidentDetails").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("resolvedIncidentDetails").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withActiveIncidentDetails(Function<IncidentSummaryDetailsArray.ProjectionMask, IncidentSummaryDetailsArray.ProjectionMask> nestedMask) {
            this._activeIncidentDetailsMask = nestedMask.apply(this._activeIncidentDetailsMask == null ? IncidentSummaryDetailsArray.createMask() : this._activeIncidentDetailsMask);
            this.getDataMap().put("activeIncidentDetails", this._activeIncidentDetailsMask.getDataMap());
            return this;
        }

        public ProjectionMask withActiveIncidentDetails() {
            this._activeIncidentDetailsMask = null;
            this.getDataMap().put("activeIncidentDetails", 1);
            return this;
        }

        public ProjectionMask withActiveIncidentDetails(Function<IncidentSummaryDetailsArray.ProjectionMask, IncidentSummaryDetailsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._activeIncidentDetailsMask = nestedMask.apply(this._activeIncidentDetailsMask == null ? IncidentSummaryDetailsArray.createMask() : this._activeIncidentDetailsMask);
            this.getDataMap().put("activeIncidentDetails", this._activeIncidentDetailsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("activeIncidentDetails").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("activeIncidentDetails").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withActiveIncidentDetails(Integer start, Integer count) {
            this._activeIncidentDetailsMask = null;
            this.getDataMap().put("activeIncidentDetails", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("activeIncidentDetails").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("activeIncidentDetails").put("$count", count);
            }
            return this;
        }
    }
}

